/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.message;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.resources.message.MessageResources;
import org.apache.commons.resources.message.MessageResourcesFactory;

public class PropertyMessageResources
extends MessageResources {
    protected static MessageResources messageResources = MessageResourcesFactory.createFactory().createResources("org.apache.commons.resources.message.LocalStrings");
    protected HashMap locales = new HashMap();
    protected HashMap messages = new HashMap();

    public PropertyMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
    }

    public PropertyMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key) {
        HashMap hashMap;
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String messageKey = null;
        String message = null;
        int underscore = 0;
        boolean addIt = false;
        while (true) {
            this.loadLocale(localeKey);
            messageKey = this.messageKey(localeKey, key);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    if (addIt) {
                        this.messages.put(originalKey, message);
                    }
                    return message;
                }
            }
            addIt = true;
            underscore = localeKey.lastIndexOf("_");
            if (underscore < 0) break;
            localeKey = localeKey.substring(0, underscore);
        }
        if (!this.defaultLocale.equals(locale)) {
            localeKey = this.localeKey(this.defaultLocale);
            messageKey = this.messageKey(localeKey, key);
            this.loadLocale(localeKey);
            hashMap = this.messages;
            synchronized (hashMap) {
                message = (String)this.messages.get(messageKey);
                if (message != null) {
                    if (addIt) {
                        this.messages.put(originalKey, message);
                    }
                    return message;
                }
            }
        }
        localeKey = "";
        messageKey = this.messageKey(localeKey, key);
        this.loadLocale(localeKey);
        hashMap = this.messages;
        synchronized (hashMap) {
            message = (String)this.messages.get(messageKey);
            if (message != null) {
                if (addIt) {
                    this.messages.put(originalKey, message);
                }
                return message;
            }
        }
        if (this.returnNull) {
            return null;
        }
        return "???" + this.messageKey(locale, key) + "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLocale(String localeKey) {
        Properties props;
        block15: {
            HashMap hashMap = this.locales;
            synchronized (hashMap) {
                if (this.locales.get(localeKey) != null) {
                    return;
                }
                this.locales.put(localeKey, localeKey);
            }
            String name = this.config.replace('.', '/');
            if (localeKey.length() > 0) {
                name = name + "_" + localeKey;
            }
            name = name + ".properties";
            InputStream is = null;
            props = new Properties();
            try {
                is = this.getClass().getClassLoader().getResourceAsStream(name);
                if (is != null) {
                    props.load(is);
                    is.close();
                }
            }
            catch (Throwable t) {
                if (is == null) break block15;
                try {
                    is.close();
                }
                catch (Throwable tr) {
                    System.out.println(messageResources.getMessage("resources.message.ioexception", (Object)tr.getMessage()));
                }
            }
        }
        if (props.size() < 1) {
            return;
        }
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            Enumeration<Object> names = props.keys();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                this.messages.put(this.messageKey(localeKey, key), props.getProperty(key));
            }
        }
    }
}

