/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.Algorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.Cache;
import org.apache.tools.ant.types.selectors.modifiedselector.DigestAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.EqualComparator;
import org.apache.tools.ant.types.selectors.modifiedselector.PropertiesfileCache;

public class ModifiedSelector
extends BaseExtendSelector {
    private Cache cache = null;
    private Algorithm algorithm = null;
    private Comparator comparator = null;
    private boolean update = true;
    private boolean selectDirectories = true;
    private boolean isConfigured = false;
    private AlgorithmName algoName = null;
    private CacheName cacheName = null;
    private ComparatorName compName = null;
    private Vector configParameter = new Vector();
    private Vector specialParameter = new Vector();

    public void verifySettings() {
        this.configure();
        if (this.cache == null) {
            this.setError("Cache must be set.");
        } else if (this.algorithm == null) {
            this.setError("Algorithm must be set.");
        } else if (!this.cache.isValid()) {
            this.setError("Cache must be proper configured.");
        } else if (!this.algorithm.isValid()) {
            this.setError("Algorithm must be proper configured.");
        }
    }

    public void configure() {
        if (this.isConfigured) {
            return;
        }
        this.isConfigured = true;
        Project project = this.getProject();
        String filename = "cache.properties";
        File cachefile = null;
        cachefile = project != null ? new File(project.getBaseDir(), filename) : new File(filename);
        this.cache = new PropertiesfileCache(cachefile);
        this.algorithm = new DigestAlgorithm();
        this.comparator = new EqualComparator();
        this.update = true;
        this.selectDirectories = true;
        Iterator itConfig = this.configParameter.iterator();
        while (itConfig.hasNext()) {
            Parameter par = (Parameter)itConfig.next();
            if (par.getName().indexOf(".") > 0) {
                this.specialParameter.add(par);
                continue;
            }
            this.useParameter(par);
        }
        this.configParameter = new Vector();
        String className = null;
        String pkg = "org.apache.tools.ant.types.selectors.cacheselector";
        if (this.algorithm == null) {
            if ("hashvalue".equals(this.algoName.getValue())) {
                className = pkg + ".HashvalueAlgorithm";
            } else if ("digest".equals(this.algoName.getValue())) {
                className = pkg + ".DigestAlgorithm";
            }
            if (className != null) {
                try {
                    this.algorithm = (Algorithm)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.cache == null) {
            if ("propertyfile".equals(this.cacheName.getValue())) {
                className = pkg + ".PropertiesfileCache";
            }
            if (className != null) {
                try {
                    this.cache = (Cache)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.comparator == null) {
            if ("equal".equals(this.compName.getValue())) {
                className = pkg + ".EqualComparator";
            } else if ("role".equals(this.compName.getValue())) {
                className = "java.text.RuleBasedCollator";
            }
            if (className != null) {
                try {
                    this.comparator = (Comparator)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Iterator itSpecial = this.specialParameter.iterator();
        while (itSpecial.hasNext()) {
            Parameter par = (Parameter)itSpecial.next();
            this.useParameter(par);
        }
        this.specialParameter = new Vector();
    }

    public boolean isSelected(File basedir, String filename, File file) {
        String newValue;
        boolean rv;
        this.validate();
        File f = new File(basedir, filename);
        if (f.isDirectory()) {
            return this.selectDirectories;
        }
        String cachedValue = String.valueOf(this.cache.get(f.getAbsolutePath()));
        boolean bl = rv = this.comparator.compare(cachedValue, newValue = this.algorithm.getValue(f)) != 0;
        if (this.update && !cachedValue.equals(newValue)) {
            this.cache.put(f.getAbsolutePath(), newValue);
            this.cache.save();
        }
        return rv;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setSeldirs(boolean seldirs) {
        this.selectDirectories = seldirs;
    }

    public void addParam(String key, Object value) {
        Parameter par = new Parameter();
        par.setName(key);
        par.setValue(String.valueOf(value));
        this.configParameter.add(par);
    }

    public void addParam(Parameter parameter) {
        this.configParameter.add(parameter);
    }

    public void setParameters(Parameter[] parameters) {
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                this.configParameter.add(parameters[i]);
                ++i;
            }
        }
    }

    public void useParameter(Parameter parameter) {
        String key = parameter.getName();
        String value = parameter.getValue();
        if ("cache".equals(key)) {
            CacheName cn = new CacheName();
            cn.setValue(value);
            this.setCache(cn);
        } else if ("algorithm".equals(key)) {
            AlgorithmName an = new AlgorithmName();
            an.setValue(value);
            this.setAlgorithm(an);
        } else if ("comparator".equals(key)) {
            ComparatorName cn = new ComparatorName();
            cn.setValue(value);
            this.setComparator(cn);
        } else if ("update".equals(key)) {
            boolean updateValue = "true".equalsIgnoreCase(value);
            this.setUpdate(updateValue);
        } else if ("seldirs".equals(key)) {
            boolean sdValue = "true".equalsIgnoreCase(value);
            this.setSeldirs(sdValue);
        } else if (key.startsWith("cache.")) {
            String name = key.substring(6);
            this.tryToSetAParameter(this.cache, name, value);
        } else if (key.startsWith("algorithm.")) {
            String name = key.substring(10);
            this.tryToSetAParameter(this.algorithm, name, value);
        } else if (key.startsWith("comparator.")) {
            String name = key.substring(11);
            this.tryToSetAParameter(this.comparator, name, value);
        } else {
            this.setError("Invalid parameter " + key);
        }
    }

    protected void tryToSetAParameter(Object obj, String name, String value) {
        Project prj = this.getProject() != null ? this.getProject() : new Project();
        IntrospectionHelper iHelper = IntrospectionHelper.getHelper(prj, obj.getClass());
        try {
            iHelper.setAttribute(prj, obj, name, value);
        }
        catch (BuildException e) {}
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{modifiedselector");
        buf.append(" update=").append(this.update);
        buf.append(" seldirs=").append(this.selectDirectories);
        buf.append(" cache=").append(this.cache);
        buf.append(" algorithm=").append(this.algorithm);
        buf.append(" comparator=").append(this.comparator);
        buf.append("}");
        return buf.toString();
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(CacheName name) {
        this.cacheName = name;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmName name) {
        this.algoName = name;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorName name) {
        this.compName = name;
    }

    public static class ComparatorName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"equal", "rule"};
        }
    }

    public static class AlgorithmName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"hashvalue", "digest"};
        }
    }

    public static class CacheName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"propertyfile"};
        }
    }
}

