/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ebxml.registry.security;

import com.sun.ebxml.registry.RegistryException;
import com.sun.ebxml.registry.security.PayloadResolver;
import com.sun.ebxml.registry.util.RegistryProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecurityUtil {
    private Log log = LogFactory.getLog(this.getClass());
    private static SecurityUtil instance;
    static /* synthetic */ Class class$com$sun$ebxml$registry$security$SecurityUtil;

    protected SecurityUtil() {
    }

    public void signSOAPMessage(InputStream soapStream, OutputStream signedSoapStream, PrivateKey privateKey, Certificate[] certs, String signatureAlgo) throws RegistryException {
        try {
            this.log.info((Object)("Enter signSOAPMessage at: " + System.currentTimeMillis()));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document soapDoc = db.parse(new InputSource(soapStream));
            Element headerElement = (Element)soapDoc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header").item(0);
            String baseURI = "";
            if (signatureAlgo == null) {
                signatureAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            if (!signatureAlgo.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") && !signatureAlgo.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                throw new RegistryException("Unsupported signature algorithm");
            }
            XMLSignature sig = new XMLSignature(soapDoc, baseURI, signatureAlgo);
            headerElement.appendChild(sig.getElement());
            sig.addDocument("#Body");
            for (int i = 0; certs != null && i < certs.length; ++i) {
                sig.addKeyInfo((X509Certificate)certs[i]);
            }
            if (certs != null) {
                sig.addKeyInfo(((X509Certificate)certs[0]).getPublicKey());
                sig.sign((Key)privateKey);
            }
            XMLUtils.outputDOMc14nWithComments((Node)soapDoc, (OutputStream)signedSoapStream);
            this.log.info((Object)("Leaving signSOAPMessage at: " + System.currentTimeMillis()));
        }
        catch (IOException e) {
            throw new RegistryException(e);
        }
        catch (SAXException e) {
            throw new RegistryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RegistryException(e);
        }
        catch (XMLSecurityException e) {
            throw new RegistryException((Exception)((Object)e));
        }
    }

    public void signPayload(MimeMultipart mp, String id, OutputStream payloadSigStream, PrivateKey privateKey, Certificate cert, String signingAlgo) throws RegistryException {
        try {
            if (mp.getCount() != 1) {
                throw new RegistryException("Cannot sign the payload. The MimeMultipart should have only one MimeBodyPart with content id 'payload2'");
            }
            if (mp.getBodyPart("payload2") == null) {
                throw new RegistryException("Cannot sign the payload. The MimeBodyPart contained in the MimeMultipart should have content id 'payload2'");
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document sigDoc = db.newDocument();
            String baseURI = "";
            if (!signingAlgo.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") && !signingAlgo.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                throw new RegistryException("Unsupported signature algorithm");
            }
            XMLSignature sig = new XMLSignature(sigDoc, baseURI, signingAlgo);
            sigDoc.appendChild(sig.getElement());
            sig.addKeyInfo((X509Certificate)cert);
            sig.addKeyInfo(((X509Certificate)cert).getPublicKey());
            ResourceResolver resolver = new ResourceResolver((ResourceResolverSpi)new PayloadResolver(mp, id));
            sig.addResourceResolver(resolver);
            sig.addDocument("payload2");
            sig.sign((Key)privateKey);
            XMLUtils.outputDOMc14nWithComments((Node)sigDoc, (OutputStream)payloadSigStream);
            payloadSigStream.flush();
            payloadSigStream.close();
        }
        catch (IOException e) {
            throw new RegistryException("Cannot sign the payload", e);
        }
        catch (ParserConfigurationException e) {
            throw new RegistryException("Cannot sign the payload", e);
        }
        catch (MessagingException e) {
            throw new RegistryException("Cannot sign the payload", (Exception)((Object)e));
        }
        catch (XMLSecurityException e) {
            throw new RegistryException("Cannot sign the payload", (Exception)((Object)e));
        }
    }

    public XMLSignature verifySOAPMessage(SOAPMessage msg) throws RegistryException {
        XMLSignature signature = null;
        try {
            this.log.info((Object)("Entering verifySOAPMessage at: " + System.currentTimeMillis()));
            ByteArrayOutputStream msgOutStream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)msgOutStream);
            ByteArrayInputStream msgInStream = new ByteArrayInputStream(msgOutStream.toByteArray());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document doc = db.parse(new InputSource(msgInStream));
            Element headerElement = (Element)doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header").item(0);
            if (headerElement == null) {
                throw new RegistryException("Missing SOAP Header");
            }
            Element sigElement = (Element)headerElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            if (sigElement != null) {
                signature = new XMLSignature(sigElement, "");
                signature.addResourceResolver((ResourceResolverSpi)new ResolverFragment());
            }
            this.log.info((Object)("Leaving verifySOAPMessage at: " + System.currentTimeMillis()));
        }
        catch (Exception e) {
            this.handleHeaderVerificationException(e);
        }
        return signature;
    }

    private void handleHeaderVerificationException(Exception e) throws RegistryException {
        boolean ignoreInvalidHeaderSignatures = Boolean.valueOf(RegistryProperties.getInstance().getProperty("ebxmlrr.security.ignoreInvalidHeaderSignatures"));
        if (!ignoreInvalidHeaderSignatures) {
            throw new RegistryException("Invalid header signature. The message is tampered with in transit.", e);
        }
        this.log.error((Object)("Invalid header signature. The message is tampered with in transit." + e.toString()));
    }

    protected boolean verifyXMLSignature(XMLSignature signature) throws RegistryException, KeyResolverException, Exception {
        KeyInfo ki = signature.getKeyInfo();
        if (ki != null) {
            if (!ki.containsX509Data()) {
                throw new RegistryException("Missing X509Data element in the KeyInfo element");
            }
            X509Certificate cert = signature.getKeyInfo().getX509Certificate();
            if (cert != null) {
                return signature.checkSignatureValue(cert);
            }
            throw new RegistryException("Missing X509Certificate element in Signature element");
        }
        throw new RegistryException("Missing KeyIno element in Signature element");
    }

    public boolean verifyPayloadSignature(String id, MimeMultipart multipart) throws RegistryException {
        boolean isValid = false;
        try {
            boolean ignoreInvalidPayloadSignatures;
            if (multipart.getCount() != 2) {
                throw new RegistryException("Cannot verify the payload signature. The MimeMultipart should have two MimeBodyPart");
            }
            BodyPart signaturePart = multipart.getBodyPart("payload1");
            if (signaturePart == null) {
                throw new RegistryException("Cannot verify the payload signature. The MimeMultipart does not have MimeBodyPart with content id 'payload1'");
            }
            BodyPart payloadPart = multipart.getBodyPart("payload2");
            if (payloadPart == null) {
                throw new RegistryException("Cannot verify the payload signature. The MimeMultipart does not have MimeBodyPart with content id 'payload2'");
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document sigDoc = db.parse(new InputSource(signaturePart.getInputStream()));
            XMLSignature signature = new XMLSignature(sigDoc.getDocumentElement(), "");
            signature.addResourceResolver((ResourceResolverSpi)new PayloadResolver(multipart, id));
            isValid = this.verifyXMLSignature(signature);
            if (!isValid && (ignoreInvalidPayloadSignatures = Boolean.valueOf(RegistryProperties.getInstance().getProperty("ebxmlrr.security.ignoreInvalidPayloadSignatures")).booleanValue())) {
                isValid = true;
            }
        }
        catch (IOException e) {
            this.handlePayloadVerificationException(e);
        }
        catch (SAXException e) {
            this.handlePayloadVerificationException(e);
        }
        catch (MessagingException e) {
            this.handlePayloadVerificationException((Exception)((Object)e));
        }
        catch (ParserConfigurationException e) {
            this.handlePayloadVerificationException(e);
        }
        catch (XMLSignatureException e) {
            this.handlePayloadVerificationException((Exception)((Object)e));
        }
        catch (KeyResolverException e) {
            this.handlePayloadVerificationException((Exception)((Object)e));
        }
        catch (XMLSecurityException e) {
            this.handlePayloadVerificationException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handlePayloadVerificationException(e);
        }
        return isValid;
    }

    private void handlePayloadVerificationException(Exception e) throws RegistryException {
        boolean ignoreInvalidPayloadSignatures = Boolean.valueOf(RegistryProperties.getInstance().getProperty("ebxmlrr.security.ignoreInvalidPayloadSignatures"));
        if (!ignoreInvalidPayloadSignatures) {
            throw new RegistryException("Cannot verify the payload signature", e);
        }
        this.log.error((Object)("Cannot verify the payload signature. " + e.toString()));
    }

    public static void main(String[] unused) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityUtil getInstance() {
        if (instance == null) {
            Class clazz = class$com$sun$ebxml$registry$security$SecurityUtil == null ? (class$com$sun$ebxml$registry$security$SecurityUtil = SecurityUtil.class$("com.sun.ebxml.registry.security.SecurityUtil")) : class$com$sun$ebxml$registry$security$SecurityUtil;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new SecurityUtil();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
        instance = null;
    }
}

