/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ebxml.registry.util;

import com.sun.ebxml.registry.RegistryException;
import com.sun.ebxml.registry.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequest;
import org.oasis.ebxml.registry.bindings.query.GetContentRequest;
import org.oasis.ebxml.registry.bindings.rim.Association;
import org.oasis.ebxml.registry.bindings.rim.LeafRegistryObjectList;
import org.oasis.ebxml.registry.bindings.rim.LeafRegistryObjectListType;
import org.oasis.ebxml.registry.bindings.rim.LeafRegistryObjectListTypeItem;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefList;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefListItem;
import org.oasis.ebxml.registry.bindings.rim.ObjectRefType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rs.AddSlotsRequest;
import org.oasis.ebxml.registry.bindings.rs.ApproveObjectsRequest;
import org.oasis.ebxml.registry.bindings.rs.DeprecateObjectsRequest;
import org.oasis.ebxml.registry.bindings.rs.RemoveObjectsRequest;
import org.oasis.ebxml.registry.bindings.rs.RemoveSlotsRequest;
import org.oasis.ebxml.registry.bindings.rs.SubmitObjectsRequest;
import org.oasis.ebxml.registry.bindings.rs.UpdateObjectsRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BindingUtility {
    private static BindingUtility instance = null;
    static /* synthetic */ Class class$com$sun$ebxml$registry$util$BindingUtility;

    protected BindingUtility() {
    }

    public ArrayList getRegistryObjectList(LeafRegistryObjectListType objs) throws RegistryException {
        ArrayList<Association> al = new ArrayList<Association>();
        if (objs != null) {
            Enumeration e = objs.enumerateLeafRegistryObjectListTypeItem();
            while (e.hasMoreElements()) {
                LeafRegistryObjectListTypeItem obj = (LeafRegistryObjectListTypeItem)e.nextElement();
                Serializable ro = null;
                if (obj.getAssociation() != null) {
                    ro = obj.getAssociation();
                } else if (obj.getAuditableEvent() != null) {
                    ro = obj.getAuditableEvent();
                } else if (obj.getClassification() != null) {
                    ro = obj.getClassification();
                } else if (obj.getClassificationNode() != null) {
                    ro = obj.getClassificationNode();
                } else if (obj.getClassificationScheme() != null) {
                    ro = obj.getClassificationScheme();
                } else if (obj.getExternalIdentifier() != null) {
                    ro = obj.getExternalIdentifier();
                } else if (obj.getExternalLink() != null) {
                    ro = obj.getExternalLink();
                } else if (obj.getExtrinsicObject() != null) {
                    ro = obj.getExtrinsicObject();
                } else if (obj.getObjectRef() != null) {
                    ro = obj.getObjectRef();
                } else if (obj.getOrganization() != null) {
                    ro = obj.getOrganization();
                } else if (obj.getRegistryPackage() != null) {
                    ro = obj.getRegistryPackage();
                } else if (obj.getService() != null) {
                    ro = obj.getService();
                } else if (obj.getServiceBinding() != null) {
                    ro = obj.getServiceBinding();
                } else if (obj.getSpecificationLink() != null) {
                    ro = obj.getSpecificationLink();
                } else if (obj.getUser() != null) {
                    ro = obj.getUser();
                } else {
                    throw new RegistryException("Null LeafRegistryObjectListTypeItem");
                }
                if (ro instanceof ObjectRef || ro instanceof ObjectRefType) continue;
                al.add((Association)ro);
            }
        }
        return al;
    }

    public ArrayList getObjectRefIds(LeafRegistryObjectListType objs) throws RegistryException {
        ArrayList<String> objectRefIds = new ArrayList<String>();
        if (objs != null) {
            Enumeration e = objs.enumerateLeafRegistryObjectListTypeItem();
            while (e.hasMoreElements()) {
                LeafRegistryObjectListTypeItem obj = (LeafRegistryObjectListTypeItem)e.nextElement();
                if (obj.getObjectRef() == null) continue;
                ObjectRef objectRef = obj.getObjectRef();
                objectRefIds.add(objectRef.getId());
            }
        }
        return objectRefIds;
    }

    public String getObjectId(Object obj) throws RegistryException {
        String id = null;
        if (obj != null) {
            if (obj instanceof ObjectRefType) {
                id = ((ObjectRef)obj).getId();
            } else if (obj instanceof RegistryObjectType) {
                id = ((RegistryObjectType)obj).getId();
            } else if (obj instanceof String) {
                id = (String)obj;
            } else {
                throw new RegistryException("Unexpected object of type " + obj.getClass() + ". Expected String or ObjectRef or RegistryObjectType");
            }
        }
        return id;
    }

    public void setObjectId(Object obj, String id) throws RegistryException {
        if (obj != null) {
            if (obj instanceof ObjectRefType) {
                ((ObjectRef)obj).setId(id);
            } else if (obj instanceof RegistryObjectType) {
                ((RegistryObjectType)obj).setId(id);
            } else {
                throw new RegistryException("Unexpected object of type " + obj.getClass() + ". Expected Object or ObjectRef or RegistryObjectType");
            }
        }
    }

    public String getRequestRootElement(InputStream request) throws RegistryException {
        String rootElementName = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(request);
            Element root = doc.getDocumentElement();
            rootElementName = root.getLocalName();
        }
        catch (IOException e) {
            throw new RegistryException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RegistryException(e);
        }
        catch (SAXException e) {
            throw new RegistryException(e);
        }
        return rootElementName;
    }

    public Object getRequestObject(File file) throws RegistryException {
        Object obj = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            String rootElement = this.getRequestRootElement(fis);
            fis.close();
            fis = new FileInputStream(file);
            String requestStr = new String(Utility.getInstance().getStringBufferFromInputStream(fis));
            obj = this.getRequestObject(rootElement, requestStr);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        return obj;
    }

    public Object getRequestObject(String rootElement, String message) throws RegistryException {
        Serializable req;
        block12: {
            req = null;
            try {
                if (rootElement.equals("AdhocQueryRequest")) {
                    req = AdhocQueryRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("GetContentRequest")) {
                    req = GetContentRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("ApproveObjectsRequest")) {
                    req = ApproveObjectsRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("DeprecateObjectsRequest")) {
                    req = DeprecateObjectsRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("AddSlotsRequest")) {
                    req = AddSlotsRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("RemoveObjectsRequest")) {
                    req = RemoveObjectsRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("RemoveSlotsRequest")) {
                    req = RemoveSlotsRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("SubmitObjectsRequest")) {
                    req = SubmitObjectsRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                if (rootElement.equals("UpdateObjectsRequest")) {
                    req = UpdateObjectsRequest.unmarshal(new StringReader(message));
                    break block12;
                }
                throw new RegistryException("InvalidRequest: Unknown element " + rootElement);
            }
            catch (MarshalException e) {
                throw new RegistryException((Exception)((Object)e));
            }
            catch (ValidationException e) {
                throw new RegistryException((Exception)((Object)e));
            }
        }
        return req;
    }

    public StringBuffer getIdListFromRegistryObjects(ArrayList objs) {
        StringBuffer idList = new StringBuffer();
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            RegistryObjectType obj = (RegistryObjectType)iter.next();
            String id = obj.getId();
            idList.append("'" + id + "'");
            if (!iter.hasNext()) continue;
            idList.append(", ");
        }
        return idList;
    }

    public ArrayList getIdsFromRegistryObjects(ArrayList objs) {
        ArrayList<String> ids = new ArrayList<String>();
        if (objs.size() > 0) {
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                RegistryObjectType ro = (RegistryObjectType)iter.next();
                ids.add(ro.getId());
            }
        }
        return ids;
    }

    public ArrayList getRegistryObjectsFromIds(ArrayList objs, ArrayList ids) {
        ArrayList<RegistryObjectType> ros = new ArrayList<RegistryObjectType>();
        if (ids.size() > 0 && objs.size() > 0) {
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                RegistryObjectType ro = (RegistryObjectType)iter.next();
                if (!ids.contains(ro.getId())) continue;
                ros.add(ro);
            }
        }
        return ros;
    }

    public StringBuffer getIdListFromObjectRefList(ObjectRefList refList) {
        StringBuffer idList = new StringBuffer();
        ObjectRefListItem[] items = refList.getObjectRefListItem();
        int cnt = items.length;
        for (int i = 0; i < cnt; ++i) {
            ObjectRef ref = items[i].getObjectRef();
            String id = ref.getId();
            idList.append("'" + id + "'");
            if (i >= cnt - 1) continue;
            idList.append(", ");
        }
        return idList;
    }

    public StringBuffer getIdListFromIds(ArrayList ids) {
        StringBuffer idList = new StringBuffer();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            idList.append("'" + id + "'");
            if (!iter.hasNext()) continue;
            idList.append(",");
        }
        return idList;
    }

    public ArrayList getIdsFromObjectRefList(ObjectRefList objectRefList) {
        ArrayList<String> ids = new ArrayList<String>();
        Enumeration enumeration = objectRefList.enumerateObjectRefListItem();
        while (enumeration.hasMoreElements()) {
            ObjectRef ref = ((ObjectRefListItem)enumeration.nextElement()).getObjectRef();
            ids.add(ref.getId());
        }
        return ids;
    }

    public Object getObjectFromRequest(SubmitObjectsRequest registryRequest, String id) throws RegistryException {
        Object result = null;
        LeafRegistryObjectList objList = registryRequest.getLeafRegistryObjectList();
        ArrayList objs = this.getRegistryObjectList(objList);
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            String objId = this.getObjectId(obj);
            if (!id.equalsIgnoreCase(objId)) continue;
            result = obj;
            break;
        }
        return result;
    }

    public ArrayList getIdsFromRequest(Object registryRequest) throws RegistryException {
        ArrayList<String> ids = new ArrayList<String>();
        if (!(registryRequest instanceof AdhocQueryRequest) && !(registryRequest instanceof GetContentRequest)) {
            if (registryRequest instanceof ApproveObjectsRequest) {
                ObjectRefList refList = ((ApproveObjectsRequest)registryRequest).getObjectRefList();
                ids.addAll(this.getIdsFromObjectRefList(refList));
            } else if (registryRequest instanceof DeprecateObjectsRequest) {
                ObjectRefList refList = ((DeprecateObjectsRequest)registryRequest).getObjectRefList();
                ids.addAll(this.getIdsFromObjectRefList(refList));
            } else if (registryRequest instanceof RemoveObjectsRequest) {
                ObjectRefList refList = ((RemoveObjectsRequest)registryRequest).getObjectRefList();
                ids.addAll(this.getIdsFromObjectRefList(refList));
            } else if (registryRequest instanceof SubmitObjectsRequest) {
                LeafRegistryObjectList objList = ((SubmitObjectsRequest)registryRequest).getLeafRegistryObjectList();
                ArrayList objs = this.getRegistryObjectList(objList);
                ids.addAll(this.getIdsFromRegistryObjects(objs));
            } else if (registryRequest instanceof UpdateObjectsRequest) {
                LeafRegistryObjectList objList = ((UpdateObjectsRequest)registryRequest).getLeafRegistryObjectList();
                ArrayList objs = this.getRegistryObjectList(objList);
                ids.addAll(this.getIdsFromRegistryObjects(objs));
            } else if (registryRequest instanceof AddSlotsRequest) {
                ObjectRef ref = ((AddSlotsRequest)registryRequest).getObjectRef();
                ids.add(ref.getId());
            } else if (registryRequest instanceof RemoveSlotsRequest) {
                ObjectRef ref = ((RemoveSlotsRequest)registryRequest).getObjectRef();
                ids.add(ref.getId());
            } else {
                throw new RegistryException("InvalidRequest: Unknown request " + registryRequest.getClass().getName());
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingUtility getInstance() {
        if (instance == null) {
            Class clazz = class$com$sun$ebxml$registry$util$BindingUtility == null ? (class$com$sun$ebxml$registry$util$BindingUtility = BindingUtility.class$("com.sun.ebxml.registry.util.BindingUtility")) : class$com$sun$ebxml$registry$util$BindingUtility;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new BindingUtility();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

