/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTreeDialog;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class ClassificationPanel
extends RegistryObjectPanel {
    JTextField schemeText = null;
    JTextField conceptText = null;
    JTextField valueText = null;

    public ClassificationPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Classification Details"));
        JLabel schemeLabel = new JLabel("ClassificationScheme:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(schemeLabel, this.c);
        this.add(schemeLabel);
        this.schemeText = new JTextField();
        this.schemeText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.schemeText, this.c);
        this.add(this.schemeText);
        JButton showSchemeButton = new JButton("Select ClassificationScheme or Concept...");
        showSchemeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ClassificationPanel.this.getSelectedSchemeOrConcept();
            }
        });
        this.c.gridx = 1;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(showSchemeButton, this.c);
        this.add(showSchemeButton);
        JLabel conceptLabel = new JLabel("Concept:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(conceptLabel, this.c);
        this.add(conceptLabel);
        this.conceptText = new JTextField();
        this.conceptText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(this.conceptText, this.c);
        this.add(this.conceptText);
        JLabel valueLabel = new JLabel("Value:", 2);
        this.c.gridx = 1;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(valueLabel, this.c);
        this.add(valueLabel);
        this.valueText = new JTextField();
        this.valueText.setEditable(false);
        this.c.gridx = 1;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(this.valueText, this.c);
        this.add(this.valueText);
    }

    private void getSelectedSchemeOrConcept() {
        ConceptsTreeDialog dialog = ConceptsTreeDialog.showSchemes(this, true, true);
        if (dialog.getStatus() == 1) {
            ArrayList selectedObjects = dialog.getSelectedObjects();
            int selectionCount = selectedObjects.size();
            if (selectionCount == 0) {
                RegistryBrowser.displayError("Must select a ClassificationScheme or Concept in ClassificationScheme dialog");
            } else {
                if (selectionCount > 1) {
                    RegistryBrowser.displayError("Only one selection allowed in ClassificationScheme dialog. Using last selection");
                }
                Classification classification = (Classification)this.model;
                Object obj = selectedObjects.get(selectionCount - 1);
                try {
                    ClassificationScheme scheme = null;
                    if (obj instanceof Concept) {
                        Concept concept = (Concept)obj;
                        classification.setConcept(concept);
                        this.valueText.setEditable(false);
                        this.conceptText.setText(concept.getKey().getId());
                        this.valueText.setText(concept.getValue());
                        scheme = concept.getClassificationScheme();
                    } else if (obj instanceof ClassificationScheme) {
                        scheme = (ClassificationScheme)obj;
                        classification.setClassificationScheme(scheme);
                        this.valueText.setEditable(true);
                    }
                    String schemeName = RegistryBrowser.getName(scheme);
                    if (schemeName != null && schemeName.length() > 0) {
                        this.schemeText.setText(schemeName);
                    } else {
                        this.schemeText.setText(scheme.getKey().getId());
                    }
                }
                catch (JAXRException e) {
                    RegistryBrowser.displayError(e);
                }
            }
        }
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof Classification)) {
            throw new InvalidRequestException("Expecting a Classification. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        Classification classification = (Classification)obj;
        try {
            if (classification != null) {
                ClassificationScheme scheme = classification.getClassificationScheme();
                Concept concept = classification.getConcept();
                if (concept != null) {
                    if (scheme == null) {
                        scheme = concept.getClassificationScheme();
                    }
                    this.conceptText.setText(concept.getKey().getId());
                    this.valueText.setText(concept.getValue());
                } else {
                    this.conceptText.setText("");
                    this.valueText.setText(classification.getValue());
                }
                if (scheme != null) {
                    this.schemeText.setText(RegistryBrowser.getName((RegistryObject)scheme));
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            Classification classification = (Classification)this.model;
            String value = this.valueText.getText();
            if (value != null && value.length() > 0) {
                classification.setValue(value);
            }
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        Concept concept;
        super.validateInput();
        Classification classification = (Classification)this.model;
        String value = this.valueText.getText();
        if ((value == null || value.length() == 0) && (concept = classification.getConcept()) == null) {
            throw new JAXRException("Error. An Classification must have a ClassificationScheme or Concept specified. If ClassificationScheme is specified instead of Concept then a Value must also be provided.");
        }
    }

    public void clear() throws JAXRException {
        super.clear();
        this.schemeText.setText("");
        this.conceptText.setText("");
        this.valueText.setText("");
    }
}

