/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.PersonName;

public class PersonNamePanel
extends JBPanel {
    JTextField firstNameText = null;
    JTextField middleNameText = null;
    JTextField lastNameText = null;

    public PersonNamePanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gbl);
        JLabel firstNameLabel = new JLabel("First name (Given name):", 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(firstNameLabel, c);
        this.add(firstNameLabel);
        this.firstNameText = new JTextField();
        this.firstNameText.setEditable(this.editable);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.75;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.firstNameText, c);
        this.add(this.firstNameText);
        JLabel middleNameLabel = new JLabel("Middle name:", 2);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(middleNameLabel, c);
        this.add(middleNameLabel);
        this.middleNameText = new JTextField();
        this.middleNameText.setEditable(this.editable);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.middleNameText, c);
        this.add(this.middleNameText);
        JLabel lastNameLabel = new JLabel("Last name (Surname):", 2);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(lastNameLabel, c);
        this.add(lastNameLabel);
        this.lastNameText = new JTextField();
        this.lastNameText.setEditable(this.editable);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.lastNameText, c);
        this.add(this.lastNameText);
    }

    public PersonName getPersonName() throws JAXRException {
        PersonName personName = null;
        if (this.model != null) {
            personName = (PersonName)this.getModel();
        }
        return personName;
    }

    public void setPersonName(PersonName personName) throws JAXRException {
        this.setModel(personName);
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof PersonName)) {
            throw new InvalidRequestException("Expecting a PersonName. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        PersonName personName = (PersonName)obj;
        try {
            if (personName != null) {
                this.firstNameText.setText(personName.getFirstName());
                this.middleNameText.setText(personName.getMiddleName());
                this.lastNameText.setText(personName.getLastName());
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            PersonName personName = (PersonName)this.model;
            personName.setFirstName(this.firstNameText.getText());
            personName.setMiddleName(this.middleNameText.getText());
            personName.setLastName(this.lastNameText.getText());
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
    }

    public void clear() throws JAXRException {
        super.clear();
        this.firstNameText.setText("");
        this.middleNameText.setText("");
        this.lastNameText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.firstNameText.setEditable(editable);
        this.middleNameText.setEditable(editable);
        this.lastNameText.setEditable(editable);
    }
}

