/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;

public class PostalAddressPanel
extends JBPanel {
    JTextField streetNumText = null;
    JTextField streetText = null;
    JTextField cityText = null;
    JTextField stateText = null;
    JTextField postalCodeText = null;
    JTextField countryText = null;
    String[] addressTypes = new String[]{"Home", "Office", "Vacation", "Temporary"};
    JComboBox typeCombo = null;
    JTextField postalSchemeText = null;

    public PostalAddressPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gbl);
        JLabel streetNumLabel = new JLabel("Street Number:", 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(streetNumLabel, c);
        this.add(streetNumLabel);
        this.streetNumText = new JTextField();
        this.streetNumText.setEditable(this.editable);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.streetNumText, c);
        this.add(this.streetNumText);
        JLabel streetLabel = new JLabel("Street:", 2);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(streetLabel, c);
        this.add(streetLabel);
        this.streetText = new JTextField();
        this.streetText.setEditable(this.editable);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.streetText, c);
        this.add(this.streetText);
        JLabel cityLabel = new JLabel("City:", 2);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(cityLabel, c);
        this.add(cityLabel);
        this.cityText = new JTextField();
        this.cityText.setEditable(this.editable);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.cityText, c);
        this.add(this.cityText);
        JLabel stateLabel = new JLabel("State/Province:", 2);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(stateLabel, c);
        this.add(stateLabel);
        this.stateText = new JTextField();
        this.stateText.setEditable(this.editable);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.stateText, c);
        this.add(this.stateText);
        JLabel postalCodeLabel = new JLabel("Postal Code:", 2);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(postalCodeLabel, c);
        this.add(postalCodeLabel);
        this.postalCodeText = new JTextField();
        this.postalCodeText.setEditable(this.editable);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.postalCodeText, c);
        this.add(this.postalCodeText);
        JLabel countryLabel = new JLabel("Country:", 2);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(countryLabel, c);
        this.add(countryLabel);
        this.countryText = new JTextField();
        this.countryText.setEditable(this.editable);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.countryText, c);
        this.add(this.countryText);
        JLabel typeLabel = new JLabel("Address Type:", 2);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(typeLabel, c);
        this.typeCombo = new JComboBox<String>(this.addressTypes);
        this.typeCombo.setEditable(true);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.typeCombo, c);
        JLabel postalSchemeLabel = new JLabel("Postal Address Scheme:", 2);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(postalSchemeLabel, c);
    }

    public PostalAddress getPostalAddress() throws JAXRException {
        PostalAddress postalAddress = null;
        if (this.model != null) {
            postalAddress = (PostalAddress)this.getModel();
        }
        return postalAddress;
    }

    public void setPostalAddress(PostalAddress addr) throws JAXRException {
        this.setModel(addr);
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof PostalAddress)) {
            throw new InvalidRequestException("Expecting a PostalAddress. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        PostalAddress addr = (PostalAddress)obj;
        try {
            if (addr != null) {
                String schemeName;
                this.streetNumText.setText(addr.getStreetNumber());
                this.streetText.setText(addr.getStreet());
                this.cityText.setText(addr.getCity());
                this.stateText.setText(addr.getStateOrProvince());
                this.postalCodeText.setText(addr.getPostalCode());
                this.countryText.setText(addr.getCountry());
                ClassificationScheme scheme = addr.getPostalScheme();
                if (scheme != null && (schemeName = RegistryBrowser.getName((RegistryObject)scheme)) != null && schemeName.length() > 0) {
                    this.postalSchemeText.setText(schemeName);
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            PostalAddress postalAddress = (PostalAddress)this.model;
            postalAddress.setStreetNumber(this.streetNumText.getText());
            postalAddress.setStreet(this.streetText.getText());
            postalAddress.setCity(this.cityText.getText());
            postalAddress.setStateOrProvince(this.stateText.getText());
            postalAddress.setPostalCode(this.postalCodeText.getText());
            postalAddress.setCountry(this.countryText.getText());
            postalAddress.setType((String)this.typeCombo.getSelectedItem());
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        PostalAddress postalAddress = (PostalAddress)this.model;
    }

    public void clear() throws JAXRException {
        super.clear();
        this.streetNumText.setText("");
        this.streetText.setText("");
        this.cityText.setText("");
        this.stateText.setText("");
        this.postalCodeText.setText("");
        this.countryText.setText("");
        if (this.postalSchemeText != null) {
            this.postalSchemeText.setText("");
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.streetNumText.setEditable(editable);
        this.streetText.setEditable(editable);
        this.cityText.setEditable(editable);
        this.stateText.setEditable(editable);
        this.postalCodeText.setEditable(editable);
        this.countryText.setEditable(editable);
    }
}

