/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ClassificationsList;
import com.sun.xml.registry.client.browser.ClassificationsListModel;
import com.sun.xml.registry.client.browser.ExternalIdentifiersList;
import com.sun.xml.registry.client.browser.ExternalIdentifiersListModel;
import com.sun.xml.registry.client.browser.ExternalLinksList;
import com.sun.xml.registry.client.browser.ExternalLinksListModel;
import com.sun.xml.registry.client.browser.JBEditorDialog;
import com.sun.xml.registry.client.browser.JBPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.SlotsList;
import com.sun.xml.registry.client.browser.SlotsListModel;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.RegistryObject;

public class RegistryObjectPanel
extends JBPanel {
    JTextField idText = null;
    JTextField nameText = null;
    JTextArea descriptionText = null;
    JTextField nameLocaleText = null;
    JTextField descriptionLocaleText = null;
    ClassificationsList classificationsList = null;
    ExternalIdentifiersList extIdsList = null;
    ExternalLinksList linksList = null;
    SlotsList slotsList = null;
    protected int row = 0;
    protected GridBagConstraints c = null;
    protected GridBagLayout gbl = new GridBagLayout();
    private Locale localeOnSetModel = null;
    private Locale nameLocaleOnSetModel = null;
    private Locale descriptionLocaleOnSetModel = null;

    public RegistryObjectPanel() {
        this.c = new GridBagConstraints();
        this.setLayout(this.gbl);
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        JLabel nameLabel = new JLabel("Name:", 2);
        namePanel.add((Component)nameLabel, "West");
        this.nameLocaleText = new JTextField();
        this.nameLocaleText.setEditable(false);
        this.nameLocaleText.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.nameLocaleText.setAlignmentX(0.5f);
        namePanel.add((Component)this.nameLocaleText, "Center");
        JButton showNameInternationalStringButton = new JButton("Details");
        showNameInternationalStringButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                RegistryObjectPanel.this.showNameInternationalString();
            }
        });
        namePanel.add((Component)showNameInternationalStringButton, "East");
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(namePanel, this.c);
        this.add(namePanel);
        this.nameText = new JTextField();
        this.nameText.setEditable(this.editable);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(this.nameText, this.c);
        this.add(this.nameText);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new BorderLayout());
        JLabel descriptionLabel = new JLabel("Description:", 2);
        descriptionPanel.add((Component)descriptionLabel, "West");
        this.descriptionLocaleText = new JTextField();
        this.descriptionLocaleText.setEditable(false);
        this.descriptionLocaleText.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.descriptionLocaleText.setAlignmentX(0.5f);
        descriptionPanel.add((Component)this.descriptionLocaleText, "Center");
        JButton showDescriptionInternationalStringButton = new JButton("Details");
        showDescriptionInternationalStringButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                RegistryObjectPanel.this.showDescriptionInternationalString();
            }
        });
        descriptionPanel.add((Component)showDescriptionInternationalStringButton, "East");
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(descriptionPanel, this.c);
        this.add(descriptionPanel);
        this.descriptionText = new JTextArea();
        this.descriptionText.setEditable(this.editable);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setRows(2);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 2;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.descriptionText, this.c);
        this.add(this.descriptionText);
        JLabel idLabel = new JLabel("Unique Identifier:", 2);
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(idLabel, this.c);
        this.add(idLabel);
        this.idText = new JTextField();
        this.idText.setEditable(false);
        this.c.gridx = 1;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.idText, this.c);
        this.add(this.idText);
        JButton submitterButton = new JButton("Submitter...");
        this.c.gridx = 1;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(submitterButton, this.c);
        JLabel classificationsLabel = new JLabel("Classifications:", 2);
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(classificationsLabel, this.c);
        this.add(classificationsLabel);
        this.classificationsList = new ClassificationsList();
        this.classificationsList.setEditable(this.editable);
        this.classificationsList.setVisibleRowCount(3);
        JScrollPane classificationsListScrollPane = new JScrollPane(this.classificationsList);
        this.c.gridx = 0;
        this.c.gridy = 6;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(classificationsListScrollPane, this.c);
        this.add(classificationsListScrollPane);
        JLabel extIdsLabel = new JLabel("External Identifiers:", 2);
        this.c.gridx = 1;
        this.c.gridy = 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(extIdsLabel, this.c);
        this.add(extIdsLabel);
        this.extIdsList = new ExternalIdentifiersList();
        this.extIdsList.setEditable(this.editable);
        this.extIdsList.setVisibleRowCount(3);
        JScrollPane extIdsListScrollPane = new JScrollPane(this.extIdsList);
        this.c.gridx = 1;
        this.c.gridy = 6;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(extIdsListScrollPane, this.c);
        this.add(extIdsListScrollPane);
        JLabel linksLabel = new JLabel("External Links:", 2);
        this.c.gridx = 0;
        this.c.gridy = 7;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(linksLabel, this.c);
        this.add(linksLabel);
        this.linksList = new ExternalLinksList();
        this.linksList.setEditable(this.editable);
        this.linksList.setVisibleRowCount(3);
        JScrollPane linksListScrollPane = new JScrollPane(this.linksList);
        this.c.gridx = 0;
        this.c.gridy = 8;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(linksListScrollPane, this.c);
        this.add(linksListScrollPane);
        JLabel slotsLabel = new JLabel("Slots:", 2);
        this.c.gridx = 1;
        this.c.gridy = 7;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(slotsLabel, this.c);
        this.add(slotsLabel);
        this.slotsList = new SlotsList();
        this.slotsList.setEditable(this.editable);
        this.slotsList.setVisibleRowCount(3);
        JScrollPane slotsListScrollPane = new JScrollPane(this.slotsList);
        this.c.gridx = 1;
        this.c.gridy = 8;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 4, 4);
        this.gbl.setConstraints(slotsListScrollPane, this.c);
        this.add(slotsListScrollPane);
        this.row = 9;
    }

    public void showNameInternationalString() {
        try {
            InternationalString iName = null;
            if (this.model != null) {
                iName = ((RegistryObject)this.model).getName();
            }
            JBEditorDialog.showObjectDetails(this, iName, true, this.editable);
            this.updateName((InternationalStringImpl)iName);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public void showDescriptionInternationalString() {
        try {
            InternationalString iDescription = null;
            if (this.model != null) {
                iDescription = ((RegistryObject)this.model).getDescription();
            }
            JBEditorDialog.showObjectDetails(this, iDescription, true, this.editable);
            if (this.model != null) {
                this.updateDescription((InternationalStringImpl)iDescription);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    private void updateName(InternationalStringImpl name) throws JAXRException {
        if (name != null) {
            LocalizedString lName = name.getClosestLocalizedString(this.localeOnSetModel, null);
            if (lName == null) {
                this.nameText.setText("");
                this.nameLocaleOnSetModel = this.localeOnSetModel;
            } else {
                this.nameText.setText(lName.getValue());
                this.nameLocaleOnSetModel = lName.getLocale();
            }
            this.nameLocaleText.setText("(" + this.nameLocaleOnSetModel + ")");
        }
    }

    private void updateDescription(InternationalStringImpl description) throws JAXRException {
        if (description != null) {
            LocalizedString lDescription = description.getClosestLocalizedString(this.localeOnSetModel, null);
            if (lDescription == null) {
                this.descriptionText.setText("");
                this.descriptionLocaleOnSetModel = this.localeOnSetModel;
            } else {
                this.descriptionText.setText(lDescription.getValue());
                this.descriptionLocaleOnSetModel = lDescription.getLocale();
            }
            this.descriptionLocaleText.setText("(" + this.descriptionLocaleOnSetModel + ")");
        }
    }

    public void setModel(Object obj) throws JAXRException {
        this.localeOnSetModel = RegistryBrowser.getInstance().getSelectedLocale();
        if (!(obj instanceof RegistryObject)) {
            throw new InvalidRequestException("Expecting a RegistryObject. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        RegistryObject ro = (RegistryObject)obj;
        try {
            ClassificationsListModel classificationsListModel = (ClassificationsListModel)this.classificationsList.getModel();
            ExternalIdentifiersListModel extIdsListModel = (ExternalIdentifiersListModel)this.extIdsList.getModel();
            ExternalLinksListModel linksListModel = (ExternalLinksListModel)this.linksList.getModel();
            SlotsListModel slotsListModel = (SlotsListModel)this.slotsList.getModel();
            if (ro != null) {
                this.updateName((InternationalStringImpl)ro.getName());
                this.updateDescription((InternationalStringImpl)ro.getDescription());
                if (ro.getKey() != null) {
                    this.idText.setText(ro.getKey().getId());
                }
                Collection c = ro.getClassifications();
                classificationsListModel.setModels(new ArrayList(c));
                Collection e = ro.getExternalIdentifiers();
                extIdsListModel.setModels(new ArrayList(e));
                Collection links = ro.getExternalLinks();
                linksListModel.setModels(new ArrayList(links));
                Collection slots = ro.getSlots();
                slotsListModel.setModels(new ArrayList(slots));
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            RegistryObjectImpl registryObject = (RegistryObjectImpl)this.model;
            String nameStr = this.nameText.getText();
            InternationalString name = registryObject.getName();
            if (name != null) {
                name.setValue(this.nameLocaleOnSetModel, nameStr);
            } else {
                registryObject.setName(registryObject.getLifeCycleManager().createInternationalString(this.nameLocaleOnSetModel, nameStr));
            }
            InternationalString description = registryObject.getDescription();
            if (description != null) {
                description.setValue(this.descriptionLocaleOnSetModel, this.descriptionText.getText());
            } else {
                registryObject.setDescription(registryObject.getLifeCycleManager().createInternationalString(this.descriptionLocaleOnSetModel, this.descriptionText.getText()));
            }
            ClassificationsListModel classificationsListModel = (ClassificationsListModel)this.classificationsList.getModel();
            registryObject.setClassifications(Arrays.asList(classificationsListModel.toArray()));
            ExternalIdentifiersListModel extIdsListModel = (ExternalIdentifiersListModel)this.extIdsList.getModel();
            registryObject.setExternalIdentifiers(Arrays.asList(extIdsListModel.toArray()));
            ExternalLinksListModel linksListModel = (ExternalLinksListModel)this.linksList.getModel();
            registryObject.setExternalLinks(Arrays.asList(linksListModel.toArray()));
            SlotsListModel slotsListModel = (SlotsListModel)this.slotsList.getModel();
            registryObject.setSlots(Arrays.asList(slotsListModel.toArray()));
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        RegistryObject registryObject = (RegistryObject)this.model;
        String nameStr = this.nameText.getText();
        if (nameStr.length() > 256) {
            throw new JAXRException("Error. RegistryObject.name length must be <= 256");
        }
        String descStr = this.descriptionText.getText();
        if (descStr.length() > 256) {
            throw new JAXRException("Error. RegistryObject.description length must be <= 256");
        }
    }

    public void clear() throws JAXRException {
        super.clear();
        this.nameText.setText("");
        this.descriptionText.setText("");
        this.idText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.nameText.setEditable(editable);
        this.descriptionText.setEditable(editable);
        this.classificationsList.setEditable(editable);
        this.extIdsList.setEditable(editable);
        this.linksList.setEditable(editable);
        this.slotsList.setEditable(editable);
    }
}

