/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.graph;

import com.jgraph.JGraph;
import com.jgraph.event.GraphSelectionEvent;
import com.jgraph.event.GraphSelectionListener;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellView;
import com.jgraph.graph.ConnectionSet;
import com.jgraph.graph.DefaultEdge;
import com.jgraph.graph.DefaultGraphCell;
import com.jgraph.graph.DefaultPort;
import com.jgraph.graph.Edge;
import com.jgraph.graph.EdgeView;
import com.jgraph.graph.GraphCell;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.GraphModel;
import com.jgraph.graph.GraphUndoManager;
import com.jgraph.graph.GraphView;
import com.jgraph.graph.ParentMap;
import com.jgraph.graph.Port;
import com.jgraph.graph.VertexView;
import com.sun.xml.registry.client.browser.BusinessQueryPanel;
import com.sun.xml.registry.client.browser.ConceptsTreeModel;
import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.JBDialog;
import com.sun.xml.registry.client.browser.JBEditorDialog;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.TreeCombo;
import com.sun.xml.registry.client.browser.graph.JBGraphCell;
import com.sun.xml.registry.client.browser.graph.JBGraphModel;
import com.sun.xml.registry.client.browser.graph.JBGraphPanel;
import com.sun.xml.registry.client.browser.graph.JBMarqueeHandler;
import com.sun.xml.registry.client.browser.graph.RelationshipPanel;
import com.sun.xml.registry.ebxml.infomodel.ExtrinsicObjectImpl;
import com.sun.xml.registry.ebxml.util.QueryUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.User;

public class JBGraph
extends JGraph
implements GraphSelectionListener,
KeyListener {
    static int LINK_TYPE_UNSPECIFIED = 0;
    static int LINK_TYPE_ASSOCIATION = 1;
    static int LINK_TYPE_COMPOSITION = 2;
    static int LINK_TYPE_AGGREGATION = 3;
    protected GraphUndoManager undoManager;
    private JToolBar toolBar = null;
    private HashMap registryObjectToCellMap = new HashMap();
    private TreeCombo objectTypeCombo = null;
    protected Action undo;
    protected Action redo;
    protected Action remove;
    protected Action tofront;
    protected Action toback;
    private boolean editable = true;

    public JBGraph() {
        this(new JBGraphModel());
    }

    public JBGraph(JBGraphModel model) {
        super((GraphModel)model);
        this.setMarqueeHandler(new JBMarqueeHandler(this));
        this.setSelectNewCells(true);
        this.setPortsVisible(true);
        this.setGridEnabled(true);
        this.setGridSize(6);
        this.setSnapSize(1);
        this.undoManager = new GraphUndoManager(){

            public void undoableEditHappened(UndoableEditEvent e) {
                super.undoableEditHappened(e);
                JBGraph.this.updateHistoryButtons();
            }
        };
        this.getModel().addUndoableEditListener((UndoableEditListener)this.undoManager);
        this.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        this.addKeyListener(this);
        this.toolBar = this.createToolBar();
    }

    protected EdgeView createEdgeView(Edge e, CellMapper cm) {
        return new EdgeView(e, this, cm){

            public boolean isAddPointEvent(MouseEvent event) {
                return event.isShiftDown();
            }

            public boolean isRemovePointEvent(MouseEvent event) {
                return event.isShiftDown();
            }
        };
    }

    public void insert(Point point) {
        RegistryBrowser.setWaitCursor();
        try {
            if (RegistryBrowser.getInstance().getClient().getConnection() == null) {
                RegistryBrowser.displayError("Connect to a registry by specifying Registry Location first.");
                return;
            }
            RegistryObject ro = this.createRegistryObject();
            JBGraphCell vertex = new JBGraphCell(ro, true);
            this.registryObjectToCellMap.put(ro, vertex);
            vertex.add((MutableTreeNode)new DefaultPort());
            point = this.snap(new Point(point));
            Dimension size = new Dimension(25, 25);
            Map map = GraphConstants.createMap();
            GraphConstants.setBounds((Map)map, (Rectangle)new Rectangle(point, size));
            GraphConstants.setBorderColor((Map)map, (Color)Color.black);
            GraphConstants.setBackground((Map)map, (Color)Color.white);
            GraphConstants.setOpaque((Map)map, (boolean)true);
            Hashtable<JBGraphCell, Map> attributes = new Hashtable<JBGraphCell, Map>();
            attributes.put(vertex, map);
            this.getModel().insert(new Object[]{vertex}, null, null, attributes);
        }
        catch (JAXRException e) {
            e.printStackTrace();
            RegistryBrowser.displayError(e);
        }
        RegistryBrowser.setDefaultCursor();
    }

    public void save() {
        RegistryBrowser.setWaitCursor();
        Object[] selectedCells = this.getSelectionCells();
        HashSet<RegistryObject> objectsToSave = new HashSet<RegistryObject>();
        for (int i = 0; i < selectedCells.length; ++i) {
            DefaultGraphCell cell;
            List children;
            if (selectedCells[i] instanceof JBGraphCell) {
                RegistryObject ro = ((JBGraphCell)((Object)selectedCells[i])).getRegistryObject();
                objectsToSave.add(ro);
                continue;
            }
            if (!(selectedCells[i] instanceof DefaultGraphCell) || (children = (cell = (DefaultGraphCell)selectedCells[i]).getChildren()) == null) continue;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof JBGraphCell)) continue;
                RegistryObject ro = ((JBGraphCell)((Object)obj)).getRegistryObject();
                objectsToSave.add(ro);
            }
        }
        try {
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            client.saveObjects(objectsToSave);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        RegistryBrowser.setDefaultCursor();
    }

    public void export() {
        RegistryBrowser.setWaitCursor();
        Object[] selectedCells = this.getSelectionCells();
        HashSet<RegistryObject> objectsToExport = new HashSet<RegistryObject>();
        for (int i = 0; i < selectedCells.length; ++i) {
            if (selectedCells[i] instanceof JBGraphCell) {
                RegistryObject ro = ((JBGraphCell)((Object)selectedCells[i])).getRegistryObject();
                objectsToExport.add(ro);
                continue;
            }
            if (!(selectedCells[i] instanceof DefaultGraphCell)) continue;
            DefaultGraphCell cell = (DefaultGraphCell)selectedCells[i];
            List children = cell.getChildren();
            Iterator iter = children.iterator();
            if (children == null) continue;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof JBGraphCell)) continue;
                RegistryObject ro = ((JBGraphCell)((Object)obj)).getRegistryObject();
                objectsToExport.add(ro);
            }
        }
        JAXRClient client = RegistryBrowser.getInstance().getClient();
        client.exportObjects(objectsToExport);
        RegistryBrowser.setDefaultCursor();
    }

    public void connect(Port source, Port target) {
        try {
            if (RegistryBrowser.getInstance().getClient().getConnection() == null) {
                RegistryBrowser.displayError("Connect to a registry by specifying Registry Location first.");
                return;
            }
            TreeNode srcObj = ((DefaultPort)source).getParent();
            TreeNode targetObj = ((DefaultPort)target).getParent();
            if (!(srcObj instanceof JBGraphCell) || !(srcObj instanceof JBGraphCell)) {
                return;
            }
            RegistryObject srcRO = ((JBGraphCell)((Object)srcObj)).getRegistryObject();
            RegistryObject targetRO = ((JBGraphCell)((Object)targetObj)).getRegistryObject();
            RelationshipPanel relPanel = new RelationshipPanel(srcRO, targetRO);
            JBDialog dialog = new JBDialog(RegistryBrowser.getInstance(), true, (JPanel)relPanel);
            dialog.setTitle("Relationship");
            dialog.setEditable(this.editable);
            dialog.setVisible(true);
            if (dialog.getStatus() != 1) {
                return;
            }
            String relationshipType = relPanel.getRelationshipType();
            boolean reverse = false;
            boolean directed = true;
            int linkType = LINK_TYPE_ASSOCIATION;
            String relationshipName = relPanel.getRelationshipName();
            boolean collection = true;
            if (relationshipType == "Association") {
                directed = true;
                collection = false;
                linkType = LINK_TYPE_ASSOCIATION;
            } else if (relationshipType == "Reference") {
                directed = true;
                relPanel.setReferenceAttributeOnSourceObject();
            }
            ConnectionSet cs = new ConnectionSet();
            DefaultEdge edge = new DefaultEdge((Object)relationshipName);
            if (!reverse) {
                cs.connect((Object)edge, (Object)source, (Object)target);
            } else {
                cs.connect((Object)edge, (Object)target, (Object)source);
            }
            Map map = GraphConstants.createMap();
            if (directed) {
                GraphConstants.setLineEnd((Map)map, (int)4);
            }
            if (linkType == LINK_TYPE_COMPOSITION) {
                GraphConstants.setBeginFill((Map)map, (boolean)true);
                GraphConstants.setLineBegin((Map)map, (int)9);
            } else if (linkType == LINK_TYPE_AGGREGATION) {
                GraphConstants.setBeginFill((Map)map, (boolean)false);
                GraphConstants.setLineBegin((Map)map, (int)9);
            }
            Hashtable<DefaultEdge, Map> attributes = new Hashtable<DefaultEdge, Map>();
            attributes.put(edge, map);
            this.getModel().insert(new Object[]{edge}, cs, null, attributes);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public DefaultGraphCell group(Object[] cells) {
        DefaultGraphCell group = null;
        cells = this.getView().order(cells);
        if (cells != null && cells.length > 0) {
            group = new DefaultGraphCell();
            DefaultPort port = new DefaultPort((Object)"Center");
            group.add((MutableTreeNode)port);
            ParentMap map = new ParentMap();
            for (int i = 0; i < cells.length; ++i) {
                map.addEntry(cells[i], (Object)group);
            }
            this.getModel().insert(new Object[]{group}, null, map, null);
        }
        return group;
    }

    public void ungroup(Object[] cells) {
        if (cells != null && cells.length > 0) {
            ArrayList<Object> groups = new ArrayList<Object>();
            ArrayList<Object> children = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isGroup(cells[i])) continue;
                groups.add(cells[i]);
                for (int j = 0; j < this.getModel().getChildCount(cells[i]); ++j) {
                    Object child = this.getModel().getChild(cells[i], j);
                    if (child instanceof Port) continue;
                    children.add(child);
                }
            }
            this.getModel().remove(groups.toArray());
            this.setSelectionCells(children.toArray());
        }
    }

    public boolean isGroup(Object cell) {
        CellView view = this.getView().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public void toFront(Object[] c) {
        if (c != null && c.length > 0) {
            this.getView().toFront(this.getView().getMapping(c));
        }
    }

    public void toBack(Object[] c) {
        if (c != null && c.length > 0) {
            this.getView().toBack(this.getView().getMapping(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        try {
            this.undoManager.undo((Object)this.getView());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        try {
            this.undoManager.redo((Object)this.getView());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    protected void updateHistoryButtons() {
        this.undo.setEnabled(this.undoManager.canUndo((Object)this.getView()));
        this.redo.setEnabled(this.undoManager.canRedo((Object)this.getView()));
    }

    public void valueChanged(GraphSelectionEvent e) {
        boolean enabled = !this.isSelectionEmpty();
        this.remove.setEnabled(enabled);
        this.tofront.setEnabled(enabled);
        this.toback.setEnabled(enabled);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.remove.actionPerformed(null);
        }
    }

    public JBGraphCell addRegistryObject(RegistryObject ro, Rectangle bounds, boolean createIcon) {
        JBGraphCell cell = null;
        if (!this.registryObjectToCellMap.containsKey(ro)) {
            cell = new JBGraphCell(ro, createIcon);
            Hashtable<JBGraphCell, Map> viewMap = new Hashtable<JBGraphCell, Map>();
            Map map = GraphConstants.createMap();
            viewMap.put(cell, map);
            GraphConstants.setBounds((Map)map, (Rectangle)bounds);
            Object[] insert = new Object[]{cell};
            this.getModel().insert(insert, null, null, viewMap);
            this.registryObjectToCellMap.put(ro, cell);
            Component c = this.getCellRenderer((GraphCell)cell);
            if (c instanceof JComponent) {
                ((JComponent)c).setToolTipText(this.getToolTipText(ro));
            }
        }
        return cell;
    }

    private String getToolTipText(RegistryObject ro) {
        String toolTipText = null;
        try {
            String desc;
            String name = RegistryBrowser.getName(ro);
            if (name != null && name.length() != 0) {
                toolTipText = toolTipText + "Name: " + name;
            }
            if ((desc = RegistryBrowser.getDescription(ro)) != null) {
                toolTipText = toolTipText + "\nDescription: " + desc;
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return toolTipText;
    }

    public JBGraphCell addRelatedObject(JBGraphCell sourceCell, RegistryObject ro, Rectangle bounds, String relationshipName, boolean reverseDirection) {
        JBGraphCell targetCell = null;
        if (!this.registryObjectToCellMap.containsKey(ro)) {
            targetCell = this.addRegistryObject(ro, bounds, true);
            if (!reverseDirection) {
                this.connectCells(sourceCell, targetCell, relationshipName, false);
            } else {
                this.connectCells(targetCell, sourceCell, relationshipName, false);
            }
        }
        return targetCell;
    }

    public void connectCells(JBGraphCell sourceCell, DefaultGraphCell targetCell, String relationshipName, boolean reverseDirection) {
        Map aggregateStyle = GraphConstants.createMap();
        GraphConstants.setLineBegin((Map)aggregateStyle, (int)9);
        GraphConstants.setBeginFill((Map)aggregateStyle, (boolean)true);
        GraphConstants.setBeginSize((Map)aggregateStyle, (int)6);
        GraphConstants.setLineEnd((Map)aggregateStyle, (int)4);
        GraphConstants.setEndSize((Map)aggregateStyle, (int)8);
        GraphConstants.setFontSize((Map)aggregateStyle, (float)10.0f);
        ConnectionSet cs = new ConnectionSet();
        Hashtable<DefaultEdge, Map> viewAttributes = new Hashtable<DefaultEdge, Map>();
        DefaultEdge edge = new DefaultEdge((Object)relationshipName);
        if (!reverseDirection) {
            cs.connect((Object)edge, (Object)sourceCell.getChildAt(0), (Object)targetCell.getChildAt(0));
        } else {
            cs.connect((Object)edge, (Object)targetCell.getChildAt(0), (Object)sourceCell.getChildAt(0));
        }
        viewAttributes.put(edge, aggregateStyle);
        Object[] insert = new Object[]{edge};
        this.getModel().insert(insert, cs, null, viewAttributes);
    }

    private Component getCellRenderer(GraphCell cell) {
        GraphView graphView = this.getView();
        CellView cellView = graphView.getMapping((Object)cell, true);
        Component renderer = cellView.getRendererComponent((JGraph)this, false, false, false);
        return renderer;
    }

    void showRelatedObjects(JBGraphCell cell) {
        RegistryBrowser.setWaitCursor();
        RegistryObject ro = cell.getRegistryObject();
        ArrayList relatedCells = this.showRelatedObjects(cell, ro);
        ArrayList moreRelatedCells = null;
        if (ro instanceof Organization) {
            moreRelatedCells = this.showRelatedObjects(cell, (Organization)ro);
        } else if (ro instanceof Service) {
            moreRelatedCells = this.showRelatedObjects(cell, (Service)ro);
        } else if (ro instanceof ServiceBinding) {
            moreRelatedCells = this.showRelatedObjects(cell, (ServiceBinding)ro);
        } else if (ro instanceof SpecificationLink) {
            moreRelatedCells = this.showRelatedObjects(cell, (SpecificationLink)ro);
        } else if (ro instanceof User) {
            moreRelatedCells = this.showRelatedObjects(cell, (User)ro);
        } else if (ro instanceof Classification) {
            moreRelatedCells = this.showRelatedObjects(cell, (Classification)ro);
        } else if (ro instanceof ExternalIdentifier) {
            moreRelatedCells = this.showRelatedObjects(cell, (ExternalIdentifier)ro);
        } else if (ro instanceof ClassificationScheme) {
            moreRelatedCells = this.showRelatedObjects(cell, (ClassificationScheme)ro);
        } else if (ro instanceof Concept) {
            moreRelatedCells = this.showRelatedObjects(cell, (Concept)ro);
        }
        if (moreRelatedCells != null) {
            relatedCells.addAll(moreRelatedCells);
        }
        System.err.println("relatedCells.size() = " + relatedCells.size());
        JBGraph.circleLayout(this, (GraphCell)cell, relatedCells);
        RegistryBrowser.setDefaultCursor();
    }

    void browseObject(JBGraphCell cell) {
        RegistryObject ro = cell.getRegistryObject();
        JBGraphPanel.browseObject((Window)SwingUtilities.getRoot((Component)((Object)this)), ro, this.editable);
    }

    public void retrieveItem(JBGraphCell cell) {
        RegistryBrowser.retrieveItem(cell.getRegistryObject());
    }

    public void showAuditTrail(JBGraphCell cell) {
        RegistryBrowser.showAuditTrail(cell.getRegistryObject());
    }

    private DefaultGraphCell createGroupFromObjectCollection(Collection objs) {
        DefaultGraphCell groupCell = null;
        if (objs != null) {
            ArrayList<JBGraphCell> groupedCells = new ArrayList<JBGraphCell>();
            boolean createIcon = true;
            int x = 50;
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                RegistryObject ro = (RegistryObject)iter.next();
                JBGraphCell newCell = (JBGraphCell)((Object)this.registryObjectToCellMap.get(ro));
                if (newCell == null) {
                    newCell = this.addRegistryObject(ro, new Rectangle(0, x, 50, 50), createIcon);
                    createIcon = false;
                }
                CellView newCellView = this.getView().getMapping((Object)newCell, false);
                Rectangle bounds = newCellView.getBounds();
                x = (int)((double)x + 1.25 * (double)bounds.height);
                groupedCells.add(newCell);
            }
            if (groupedCells.size() > 0) {
                groupCell = this.group(groupedCells.toArray());
            }
        }
        return groupCell;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, RegistryObject ro) {
        ArrayList<DefaultGraphCell> relatedCells = new ArrayList<DefaultGraphCell>();
        if (ro == null) {
            return relatedCells;
        }
        try {
            Collection extLinks;
            Collection extIds;
            CellView cellView = this.getView().getMapping((Object)cell, false);
            Rectangle bounds = cellView.getBounds();
            Collection classifications = ro.getClassifications();
            DefaultGraphCell groupCell = this.createGroupFromObjectCollection(classifications);
            if (groupCell != null) {
                this.connectCells(cell, groupCell, "classifications", false);
                relatedCells.add(groupCell);
            }
            if ((groupCell = this.createGroupFromObjectCollection(extIds = ro.getExternalIdentifiers())) != null) {
                this.connectCells(cell, groupCell, "externalIdentifiers", false);
                relatedCells.add(groupCell);
            }
            if ((groupCell = this.createGroupFromObjectCollection(extLinks = ro.getExternalLinks())) != null) {
                this.connectCells(cell, groupCell, "externalLinks", false);
                relatedCells.add(groupCell);
            }
            try {
                Collection assocs = ro.getAssociations();
                Iterator iter = assocs.iterator();
                while (iter.hasNext()) {
                    Association assoc = (Association)iter.next();
                    RegistryObject srcObj = assoc.getSourceObject();
                    RegistryObject targetObj = assoc.getTargetObject();
                    Concept concept = assoc.getAssociationType();
                    String label = "associatedWith";
                    if (concept != null) {
                        label = concept.getValue();
                    }
                    if (srcObj != null && targetObj != null) {
                        JBGraphCell newCell = null;
                        newCell = srcObj.getKey().getId().equalsIgnoreCase(ro.getKey().getId()) ? this.addRelatedObject(cell, targetObj, new Rectangle(bounds.x + 100, bounds.y, 50, 50), label, false) : this.addRelatedObject(cell, srcObj, new Rectangle(bounds.x + 100, bounds.y, 50, 50), label, true);
                        relatedCells.add(newCell);
                        continue;
                    }
                    System.err.println("Invalid association. Source or traget is null: " + assoc.getKey().getId());
                }
            }
            catch (UnsupportedCapabilityException e) {
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, Organization org) {
        ArrayList<DefaultGraphCell> relatedCells = new ArrayList<DefaultGraphCell>();
        if (org == null) {
            return relatedCells;
        }
        try {
            Collection services = org.getServices();
            DefaultGraphCell groupCell = this.createGroupFromObjectCollection(services);
            if (groupCell != null) {
                this.connectCells(cell, groupCell, "services", false);
                relatedCells.add(groupCell);
            }
            try {
                Organization parentOrg = org.getParentOrganization();
                if (parentOrg != null) {
                    JBGraphCell newCell = this.addRelatedObject(cell, (RegistryObject)parentOrg, new Rectangle(0, 0, 50, 50), "parent Oragnization", false);
                    relatedCells.add(newCell);
                }
            }
            catch (UnsupportedCapabilityException e) {
                // empty catch block
            }
            try {
                Collection children = org.getChildOrganizations();
                groupCell = this.createGroupFromObjectCollection(children);
                if (groupCell != null) {
                    this.connectCells(cell, groupCell, "parent Organization", true);
                    relatedCells.add(groupCell);
                }
            }
            catch (UnsupportedCapabilityException e) {
                // empty catch block
            }
            Collection users = org.getUsers();
            groupCell = this.createGroupFromObjectCollection(users);
            if (groupCell != null) {
                this.connectCells(cell, groupCell, "users", false);
                relatedCells.add(groupCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, Service service) {
        ArrayList<DefaultGraphCell> relatedCells = new ArrayList<DefaultGraphCell>();
        if (service == null) {
            return relatedCells;
        }
        try {
            Organization parentOrg;
            Collection bindings = service.getServiceBindings();
            DefaultGraphCell groupCell = this.createGroupFromObjectCollection(bindings);
            if (groupCell != null) {
                this.connectCells(cell, groupCell, "service bindings", false);
                relatedCells.add(groupCell);
            }
            if ((parentOrg = service.getProvidingOrganization()) != null) {
                JBGraphCell newCell = this.addRelatedObject(cell, (RegistryObject)parentOrg, new Rectangle(0, 0, 50, 50), "parent Oragnization", false);
                relatedCells.add(newCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, ServiceBinding binding) {
        ArrayList<DefaultGraphCell> relatedCells = new ArrayList<DefaultGraphCell>();
        if (binding == null) {
            return relatedCells;
        }
        try {
            Collection specLinks = binding.getSpecificationLinks();
            System.err.println("Binding has " + specLinks.size() + " specLinks");
            DefaultGraphCell groupCell = this.createGroupFromObjectCollection(specLinks);
            if (groupCell != null) {
                this.connectCells(cell, groupCell, "specification links", false);
                relatedCells.add(groupCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, SpecificationLink specLink) {
        ArrayList<JBGraphCell> relatedCells = new ArrayList<JBGraphCell>();
        if (specLink == null) {
            return relatedCells;
        }
        try {
            RegistryObject specObject = specLink.getSpecificationObject();
            if (specObject != null) {
                JBGraphCell newCell = this.addRelatedObject(cell, specObject, new Rectangle(0, 0, 50, 50), "specification object", false);
                relatedCells.add(newCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, User user) {
        ArrayList<JBGraphCell> relatedCells = new ArrayList<JBGraphCell>();
        if (user == null) {
            return relatedCells;
        }
        try {
            Organization org = user.getOrganization();
            if (org != null) {
                JBGraphCell newCell = this.addRelatedObject(cell, (RegistryObject)org, new Rectangle(0, 0, 50, 50), "affiliated with", false);
                relatedCells.add(newCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, Classification classification) {
        ArrayList<JBGraphCell> relatedCells = new ArrayList<JBGraphCell>();
        if (classification == null) {
            return relatedCells;
        }
        try {
            ClassificationScheme scheme = classification.getClassificationScheme();
            JBGraphCell newCell = this.addRelatedObject(cell, (RegistryObject)scheme, new Rectangle(0, 0, 50, 50), "classification scheme", false);
            relatedCells.add(newCell);
            Concept concept = classification.getConcept();
            if (concept != null) {
                newCell = this.addRelatedObject(cell, (RegistryObject)concept, new Rectangle(0, 0, 50, 50), "value", false);
                relatedCells.add(newCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, ExternalIdentifier externalIdentifier) {
        ArrayList<JBGraphCell> relatedCells = new ArrayList<JBGraphCell>();
        if (externalIdentifier == null) {
            return relatedCells;
        }
        try {
            ClassificationScheme scheme = externalIdentifier.getIdentificationScheme();
            JBGraphCell newCell = this.addRelatedObject(cell, (RegistryObject)scheme, new Rectangle(0, 0, 50, 50), "identification scheme", false);
            relatedCells.add(newCell);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, ClassificationScheme scheme) {
        ArrayList<DefaultGraphCell> relatedCells = new ArrayList<DefaultGraphCell>();
        if (scheme == null) {
            return relatedCells;
        }
        try {
            Collection childConcepts = scheme.getChildrenConcepts();
            DefaultGraphCell groupCell = this.createGroupFromObjectCollection(childConcepts);
            if (groupCell != null) {
                this.connectCells(cell, groupCell, "child Concepts", false);
                relatedCells.add(groupCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private ArrayList showRelatedObjects(JBGraphCell cell, Concept concept) {
        ArrayList<DefaultGraphCell> relatedCells = new ArrayList<DefaultGraphCell>();
        if (concept == null) {
            return relatedCells;
        }
        try {
            Concept parentConcept = concept.getParentConcept();
            if (parentConcept != null) {
                JBGraphCell newCell = this.addRelatedObject(cell, (RegistryObject)parentConcept, new Rectangle(0, 0, 50, 50), "parent", false);
                relatedCells.add(newCell);
            } else {
                ClassificationScheme scheme = concept.getClassificationScheme();
                if (scheme != null) {
                    JBGraphCell newCell = this.addRelatedObject(cell, (RegistryObject)scheme, new Rectangle(0, 0, 50, 50), "classification scheme", false);
                    relatedCells.add(newCell);
                }
            }
            Collection childConcepts = concept.getChildrenConcepts();
            DefaultGraphCell groupCell = this.createGroupFromObjectCollection(childConcepts);
            if (groupCell != null) {
                this.connectCells(cell, groupCell, "child Concepts", false);
                relatedCells.add(groupCell);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return relatedCells;
    }

    private RegistryObject createRegistryObject() throws JAXRException {
        RegistryObject ro = null;
        JAXRClient client = RegistryBrowser.getInstance().getClient();
        BusinessLifeCycleManager lcm = client.getBusinessLifeCycleManager();
        String objectType = this.objectTypeCombo.getSelectedItem().toString();
        QueryUtil qu = QueryUtil.getInstance();
        if (qu.getUnsupportedObjectTypes().contains(objectType)) {
            throw new JAXRException("Search not supported for: " + objectType);
        }
        boolean isIntrinsic = BusinessQueryPanel.isIntrinsicObjectType(objectType);
        String newObjectType = objectType;
        if (!isIntrinsic) {
            newObjectType = "ExtrinsicObject";
        }
        if ((ro = (RegistryObject)lcm.createObject(newObjectType)) instanceof ExtrinsicObjectImpl) {
            ExtrinsicObjectImpl eo = (ExtrinsicObjectImpl)ro;
            eo.setObjectType(objectType);
        }
        return ro;
    }

    public JToolBar createToolBar() {
        JButton button = null;
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        ConceptsTreeModel objectTypesTreeModel = BusinessQueryPanel.getObjectTypesTreeModel();
        this.objectTypeCombo = new TreeCombo(objectTypesTreeModel);
        toolbar.add(this.objectTypeCombo);
        URL insertUrl = this.getClass().getClassLoader().getResource("icons/insert.gif");
        ImageIcon insertIcon = new ImageIcon(insertUrl);
        button = toolbar.add(new AbstractAction("", insertIcon){

            public void actionPerformed(ActionEvent e) {
                JBGraph.this.insert(new Point(10, 10));
            }
        });
        button.setText("");
        button.setToolTipText("Insert");
        URL connectUrl = this.getClass().getClassLoader().getResource("icons/connecton.gif");
        ImageIcon connectIcon = new ImageIcon(connectUrl);
        button = toolbar.add(new AbstractAction("", connectIcon){

            public void actionPerformed(ActionEvent e) {
                JBGraph.this.setPortsVisible(!JBGraph.this.isPortsVisible());
                URL connectUrl = JBGraph.this.isPortsVisible() ? this.getClass().getClassLoader().getResource("icons/connecton.gif") : this.getClass().getClassLoader().getResource("icons/connectoff.gif");
                ImageIcon connectIcon = new ImageIcon(connectUrl);
                this.putValue("SmallIcon", connectIcon);
            }
        });
        button.setText("");
        button.setToolTipText("Toggle Connect Mode");
        toolbar.addSeparator();
        URL undoUrl = this.getClass().getClassLoader().getResource("icons/undo.gif");
        ImageIcon undoIcon = new ImageIcon(undoUrl);
        this.undo = new AbstractAction("", undoIcon){

            public void actionPerformed(ActionEvent e) {
                JBGraph.this.undo();
            }
        };
        this.undo.setEnabled(false);
        button = toolbar.add(this.undo);
        button.setText("");
        button.setToolTipText("Undo");
        URL redoUrl = this.getClass().getClassLoader().getResource("icons/redo.gif");
        ImageIcon redoIcon = new ImageIcon(redoUrl);
        this.redo = new AbstractAction("", redoIcon){

            public void actionPerformed(ActionEvent e) {
                JBGraph.this.redo();
            }
        };
        this.redo.setEnabled(false);
        button = toolbar.add(this.redo);
        button.setText("");
        button.setToolTipText("Redo");
        toolbar.addSeparator();
        Action action = TransferHandler.getCopyAction();
        URL url = this.getClass().getClassLoader().getResource("icons/copy.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        button.setText("");
        button.setToolTipText("Copy");
        action = TransferHandler.getPasteAction();
        url = this.getClass().getClassLoader().getResource("icons/paste.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        button.setText("");
        button.setToolTipText("Paste");
        action = TransferHandler.getCutAction();
        url = this.getClass().getClassLoader().getResource("icons/cut.gif");
        action.putValue("SmallIcon", new ImageIcon(url));
        button.setText("");
        button.setToolTipText("Cut");
        URL removeUrl = this.getClass().getClassLoader().getResource("icons/delete.gif");
        ImageIcon removeIcon = new ImageIcon(removeUrl);
        this.remove = new AbstractAction("", removeIcon){

            public void actionPerformed(ActionEvent e) {
                if (!JBGraph.this.isSelectionEmpty()) {
                    Object[] cells = JBGraph.this.getSelectionCells();
                    cells = JBGraph.this.getDescendants(cells);
                    JBGraph.this.getModel().remove(cells);
                    for (int i = 0; i < cells.length; ++i) {
                        Object cell = cells[i];
                        if (!(cell instanceof JBGraphCell)) continue;
                        RegistryObject ro = ((JBGraphCell)((Object)cell)).getRegistryObject();
                        JBGraph.this.registryObjectToCellMap.remove(ro);
                    }
                }
            }
        };
        this.remove.setEnabled(false);
        button = toolbar.add(this.remove);
        button.setText("");
        button.setToolTipText("Remove");
        toolbar.addSeparator();
        URL zoomUrl = this.getClass().getClassLoader().getResource("icons/zoom.gif");
        ImageIcon zoomIcon = new ImageIcon(zoomUrl);
        button = toolbar.add(new AbstractAction("", zoomIcon){

            public void actionPerformed(ActionEvent e) {
                JBGraph.this.setScale(1.0);
            }
        });
        button.setText("");
        button.setToolTipText("Zoom");
        URL zoomInUrl = this.getClass().getClassLoader().getResource("icons/zoomin.gif");
        ImageIcon zoomInIcon = new ImageIcon(zoomInUrl);
        button = toolbar.add(new AbstractAction("", zoomInIcon){

            public void actionPerformed(ActionEvent e) {
                JBGraph.this.setScale(2.0 * JBGraph.this.getScale());
            }
        });
        button.setText("");
        button.setToolTipText("Zoom In");
        URL zoomOutUrl = this.getClass().getClassLoader().getResource("icons/zoomout.gif");
        ImageIcon zoomOutIcon = new ImageIcon(zoomOutUrl);
        button = toolbar.add(new AbstractAction("", zoomOutIcon){

            public void actionPerformed(ActionEvent e) {
                JBGraph.this.setScale(JBGraph.this.getScale() / 2.0);
            }
        });
        button.setText("");
        button.setToolTipText("Zoom Out");
        toolbar.addSeparator();
        URL toFrontUrl = this.getClass().getClassLoader().getResource("icons/tofront.gif");
        ImageIcon toFrontIcon = new ImageIcon(toFrontUrl);
        this.tofront = new AbstractAction("", toFrontIcon){

            public void actionPerformed(ActionEvent e) {
                if (!JBGraph.this.isSelectionEmpty()) {
                    JBGraph.this.toFront(JBGraph.this.getSelectionCells());
                }
            }
        };
        this.tofront.setEnabled(false);
        button = toolbar.add(this.tofront);
        button.setText("");
        button.setToolTipText("To Front");
        URL toBackUrl = this.getClass().getClassLoader().getResource("icons/toback.gif");
        ImageIcon toBackIcon = new ImageIcon(toBackUrl);
        this.toback = new AbstractAction("", toBackIcon){

            public void actionPerformed(ActionEvent e) {
                if (!JBGraph.this.isSelectionEmpty()) {
                    JBGraph.this.toBack(JBGraph.this.getSelectionCells());
                }
            }
        };
        this.toback.setEnabled(false);
        button = toolbar.add(this.toback);
        button.setText("");
        button.setToolTipText("To Back");
        return toolbar;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    void editCell(JBGraphCell cell) {
        RegistryObject ro = cell.getRegistryObject();
        if (ro != null) {
            JBEditorDialog.showObjectDetails((Component)((Object)this), ro, false, this.editable);
        }
    }

    public static void circleLayout(JGraph graph) {
        Object[] selectedCells = graph.getSelectionCells();
        if (selectedCells.length > 1) {
            GraphCell hubCell = (GraphCell)selectedCells[0];
            ArrayList<Object> spokeCells = new ArrayList<Object>();
            for (int i = 1; i < selectedCells.length; ++i) {
                spokeCells.add(selectedCells[i]);
            }
            JBGraph.circleLayout(graph, hubCell, spokeCells);
        }
    }

    public static void circleLayout(JGraph graph, GraphCell hubCell, ArrayList spokeCells) {
        if (spokeCells.size() == 0) {
            return;
        }
        GraphView graphView = graph.getView();
        CellView hubCellView = graphView.getMapping((Object)hubCell, true);
        int max = 0;
        Rectangle bounds = hubCellView.getBounds();
        if (bounds != null) {
            max = Math.max(Math.max(bounds.width, bounds.height), max);
        }
        ArrayList<CellView> spokeCellViews = new ArrayList<CellView>();
        Iterator iter = spokeCells.iterator();
        while (iter.hasNext()) {
            GraphCell spokeCell = (GraphCell)iter.next();
            CellView spokeCellView = graphView.getMapping((Object)spokeCell, true);
            if (spokeCellView != null) {
                spokeCellViews.add(spokeCellView);
                continue;
            }
            System.err.println("Null spokeCellView for spokeCell: " + spokeCell);
        }
        Rectangle hubBounds = hubCellView.getBounds();
        int r = (int)Math.max((double)(spokeCellViews.size() * max) / Math.PI, 100.0);
        if (r > 250) {
            r = 250;
        }
        double stepAngle = Math.toRadians(360.0 / (double)spokeCellViews.size());
        double theta = Math.toRadians(90.0);
        if (spokeCells.size() % 2 == 0) {
            theta = Math.toRadians(135.0);
        }
        iter = spokeCellViews.iterator();
        while (iter.hasNext()) {
            VertexView spokeCellView = (VertexView)iter.next();
            DefaultGraphCell spokeCell = (DefaultGraphCell)spokeCellView.getCell();
            Rectangle spokeBounds = spokeCellView.getBounds();
            if (spokeBounds != null) {
                int x = hubBounds.x + (int)((double)r * Math.cos(theta)) - (int)((double)spokeBounds.width / 2.0);
                int y = hubBounds.y - (int)((double)r * Math.sin(theta)) - (int)((double)spokeBounds.height / 2.0);
                JBGraph.translate((CellView)spokeCellView, x - spokeBounds.x, y - spokeBounds.y);
            }
            theta -= stepAngle;
        }
    }

    private static void translate(CellView view, int dx, int dy) {
        if (view.isLeaf()) {
            GraphConstants.translate((Map)view.getAttributes(), (int)dx, (int)dy);
        } else {
            CellView[] childViews = view.getChildViews();
            for (int i = 0; i < childViews.length; ++i) {
                JBGraph.translate(childViews[i], dx, dy);
            }
        }
    }

    public JBGraphCell getJBGraphCellAt(DefaultGraphCell parent, int x, int y) {
        JBGraphCell jbCell = null;
        List children = parent.getChildren();
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                JBGraphCell _jbCell;
                Rectangle bounds;
                Object obj = iter.next();
                if (!(obj instanceof JBGraphCell) || !(bounds = this.getCellBounds((Object)(_jbCell = (JBGraphCell)((Object)obj)))).contains(x, y)) continue;
                jbCell = _jbCell;
                break;
            }
        }
        return jbCell;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected class EventRedirector
    extends AbstractAction {
        protected Action action;

        public EventRedirector(Action a) {
            super("", (ImageIcon)a.getValue("SmallIcon"));
            this.action = a;
        }

        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(JBGraph.this, e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }
}

