/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.QueryManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.PostalAddressImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import com.sun.xml.registry.ebxml.infomodel.TelephoneNumberImpl;
import com.sun.xml.registry.ebxml.infomodel.UserImpl;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.Query;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.User;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.Address;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.OrganizationType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.TelephoneNumber;

public class OrganizationImpl
extends RegistryObjectImpl
implements Organization {
    private RegistryObjectRef parentRef = null;
    private PostalAddressImpl address = null;
    private RegistryObjectRef primaryContactRef = null;
    private HashSet users = new HashSet();
    private ArrayList phones = new ArrayList();
    private ArrayList services = new ArrayList();
    private HashSet childOrgs = new HashSet();
    private boolean loadedServices;
    private boolean loadedUsers;

    public OrganizationImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
        this.address = new PostalAddressImpl(lcm);
        User user = ((QueryManagerImpl)lcm.getRegistryService().getBusinessQueryManager()).getCallersUser();
        this.setPrimaryContact(user);
    }

    public OrganizationImpl(LifeCycleManagerImpl lcm, OrganizationType ebOrg) throws JAXRException {
        super(lcm, ebOrg);
        Object ebPrimaryContactRef;
        this.address = new PostalAddressImpl(lcm, ebOrg.getAddress());
        TelephoneNumber[] tels = ebOrg.getTelephoneNumber();
        for (int i = 0; i < tels.length; ++i) {
            this.addTelephoneNumber(new TelephoneNumberImpl(lcm, tels[i]));
        }
        Object ebParentRef = ebOrg.getParent();
        if (ebParentRef != null) {
            this.parentRef = new RegistryObjectRef(lcm, ebParentRef);
        }
        if ((ebPrimaryContactRef = ebOrg.getPrimaryContact()) == null) {
            throw new JAXRException("primaryContact cannot be null in an Organization");
        }
        this.primaryContactRef = new RegistryObjectRef(lcm, ebPrimaryContactRef);
    }

    public String toXML() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.Organization ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (ValidationException x) {
            throw new JAXRException((Throwable)x);
        }
        return sw.toString();
    }

    public PostalAddress getPostalAddress() throws JAXRException {
        return this.address;
    }

    public void setPostalAddress(PostalAddress par1) throws JAXRException {
        this.address = (PostalAddressImpl)par1;
        this.setModified(true);
    }

    public User getPrimaryContact() throws JAXRException {
        RegistryObject primaryContact = null;
        if (this.primaryContactRef != null) {
            primaryContact = this.primaryContactRef.getRegistryObject("User");
        }
        return (User)primaryContact;
    }

    public void setPrimaryContact(User primaryContact) throws JAXRException {
        this.primaryContactRef = new RegistryObjectRef(this.lcm, (RegistryObject)primaryContact);
        this.setModified(true);
    }

    public void addUser(User par1) throws JAXRException {
        if (!this.users.contains(par1)) {
            ((UserImpl)par1).setOrganization(this);
            this.users.add(par1);
            this.setModified(true);
        }
    }

    public void addUsers(Collection par1) throws JAXRException {
        Iterator i = par1.iterator();
        while (i.hasNext()) {
            this.addUser((User)i.next());
        }
    }

    public void removeUser(User par1) throws JAXRException {
        if (!this.loadedUsers) {
            this.getUsers();
        }
        ((UserImpl)par1).setOrganization(null);
        this.users.remove(par1);
        this.lcm.saveObjects(Collections.singletonList(par1));
        this.setModified(true);
    }

    public void removeUsers(Collection par1) throws JAXRException {
        Iterator i = par1.iterator();
        while (i.hasNext()) {
            this.removeUser((User)i.next());
        }
    }

    public Collection getUsers() throws JAXRException {
        if (!this.loadedUsers) {
            DeclarativeQueryManager dqm = this.lcm.getRegistryService().getDeclarativeQueryManager();
            String qs = "SELECT * FROM User_ WHERE organization = '" + this.getKey().getId() + "'";
            Query query = dqm.createQuery(0, qs);
            this.loadedUsers = true;
            Iterator i = dqm.executeQuery(query).getCollection().iterator();
            while (i.hasNext()) {
                this.addUser((User)i.next());
            }
        }
        return (Collection)this.users.clone();
    }

    public void addTelephoneNumber(javax.xml.registry.infomodel.TelephoneNumber _phone) throws JAXRException {
        this.getTelephoneNumbers().add(_phone);
        this.setModified(true);
    }

    public void addTelephoneNumbers(Collection telephoneNumbers) throws JAXRException {
        Iterator iter = telephoneNumbers.iterator();
        while (iter.hasNext()) {
            javax.xml.registry.infomodel.TelephoneNumber phone = (javax.xml.registry.infomodel.TelephoneNumber)iter.next();
            this.addTelephoneNumber(phone);
        }
        this.setModified(true);
    }

    public void removeTelephoneNumber(javax.xml.registry.infomodel.TelephoneNumber _phone) throws JAXRException {
        if (this.phones != null) {
            this.getTelephoneNumbers().remove(_phone);
            this.setModified(true);
        }
    }

    public void removeTelephoneNumbers(Collection _phones) throws JAXRException {
        if (this.phones != null) {
            this.getTelephoneNumbers().removeAll(_phones);
            this.setModified(true);
        }
    }

    public void removeAllTelephoneNumbers() throws JAXRException {
        if (this.phones != null) {
            this.removeTelephoneNumbers(this.phones);
            this.setModified(true);
        }
    }

    public void setTelephoneNumbers(Collection _phones) throws JAXRException {
        this.removeAllTelephoneNumbers();
        this.addTelephoneNumbers(_phones);
        this.setModified(true);
    }

    public Collection getTelephoneNumbers() throws JAXRException {
        if (this.phones == null) {
            this.phones = new ArrayList();
        }
        return this.phones;
    }

    public Collection getTelephoneNumbers(String phoneType) throws JAXRException {
        return this.getTelephoneNumbers();
    }

    public void addService(Service par1) throws JAXRException {
        if (!this.services.contains(par1)) {
            if (!this.equals(par1.getProvidingOrganization())) {
                Concept assocType = this.bqm.findConceptByPath("/urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d/OffersService");
                par1.setProvidingOrganization((Organization)this);
                Association assoc = this.lcm.createAssociation((RegistryObject)par1, assocType);
                assoc.setSourceObject((RegistryObject)this);
            }
            this.setModified(true);
        }
    }

    public void addServices(Collection par1) throws JAXRException {
        Iterator i = par1.iterator();
        while (i.hasNext()) {
            this.addService((Service)i.next());
        }
    }

    public void removeService(Service par1) throws JAXRException {
        if (!this.loadedServices) {
            this.getServices();
        }
        this.services.remove(par1);
        this.setModified(true);
    }

    public void removeServices(Collection par1) throws JAXRException {
        Iterator i = par1.iterator();
        while (i.hasNext()) {
            this.removeService((Service)i.next());
        }
    }

    public Collection getServices() throws JAXRException {
        if (!this.loadedServices) {
            Iterator i = this.getAssociations().iterator();
            ArrayList list = new ArrayList();
            while (i.hasNext()) {
                Association a = (Association)i.next();
                if (!a.getAssociationType().getValue().equalsIgnoreCase("OffersService")) continue;
                RegistryObject service = a.getTargetObject();
                if (!(service instanceof Service)) {
                    throw new IllegalStateException("Target object is not Service but " + service.getClass().getName());
                }
                if (this.services.contains(service)) continue;
                this.services.add(service);
            }
            this.loadedServices = true;
        }
        return (Collection)this.services.clone();
    }

    public void addChildOrganization(Organization par1) throws JAXRException {
        this.childOrgs.add(par1);
        this.setModified(true);
    }

    public void addChildOrganizations(Collection par1) throws JAXRException {
        this.childOrgs.addAll(par1);
        this.setModified(true);
    }

    public void removeChildOrganization(Organization par1) throws JAXRException {
        this.childOrgs.remove(par1);
        this.setModified(true);
    }

    public void removeChildOrganizations(Collection par1) throws JAXRException {
        this.childOrgs.removeAll(par1);
        this.setModified(true);
    }

    public int getChildOrganizationCount() throws JAXRException {
        return this.childOrgs.size();
    }

    public Collection getChildOrganizations() throws JAXRException {
        return (Collection)this.childOrgs.clone();
    }

    public Collection getDescendantOrganizations() throws JAXRException {
        ArrayList descendants = new ArrayList(this.childOrgs);
        Iterator iter = this.childOrgs.iterator();
        while (iter.hasNext()) {
            Organization child = (Organization)iter.next();
            if (child.getChildOrganizationCount() <= 0) continue;
            descendants.addAll(child.getDescendantOrganizations());
        }
        return descendants;
    }

    public Organization getParentOrganization() throws JAXRException {
        RegistryObject parentObj;
        Organization parent = null;
        if (this.parentRef != null && (parentObj = this.parentRef.getRegistryObject("Organization")) instanceof Organization) {
            parent = (Organization)parentObj;
        }
        return parent;
    }

    public Organization getRootOrganization() throws JAXRException {
        OrganizationImpl root = this;
        while (root.getParentOrganization() != null) {
            root = root.getParentOrganization();
        }
        return root;
    }

    public void getComposedObjects(HashSet composedObjects) throws JAXRException {
        super.getComposedObjects(composedObjects);
        composedObjects.addAll(this.childOrgs);
    }

    public org.oasis.ebxml.registry.bindings.rim.Organization toBindingObject() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.Organization ebOrg = new org.oasis.ebxml.registry.bindings.rim.Organization();
        this.setBindingObject(ebOrg);
        return ebOrg;
    }

    protected void setBindingObject(OrganizationType ebOrg) throws JAXRException {
        boolean compatibilityMode;
        super.setBindingObject(ebOrg);
        if (this.parentRef != null) {
            ObjectRef ebParentRef = new ObjectRef();
            ebParentRef.setId(this.parentRef.getId());
            ebOrg.setParent(ebParentRef);
        }
        if (compatibilityMode = Boolean.valueOf(ProviderProperties.getInstance().getProperty("jaxr-ebxml.tck.compatibilityMode", "false")).booleanValue()) {
            if (this.address == null) {
                PostalAddress _address = this.lcm.createPostalAddress("streetNumber", "street", "city", "stateOrProvince", "country", "postalCode", "type");
                this.setPostalAddress(_address);
            }
            if (this.phones.size() == 0) {
                javax.xml.registry.infomodel.TelephoneNumber phone = this.lcm.createTelephoneNumber();
                ArrayList<javax.xml.registry.infomodel.TelephoneNumber> _phones = new ArrayList<javax.xml.registry.infomodel.TelephoneNumber>();
                _phones.add(phone);
                this.setTelephoneNumbers(_phones);
            }
        }
        Address ebAddress = new Address();
        if (this.address == null) {
            throw new InvalidRequestException("Organization is missing required address attribute");
        }
        this.address.setBindingObject(ebAddress);
        ebOrg.setAddress(ebAddress);
        if (this.primaryContactRef == null) {
            throw new InvalidRequestException("Organization is missing required primaryContact attribute");
        }
        ObjectRef ebPrimaryContactRef = new ObjectRef();
        ebPrimaryContactRef.setId(this.primaryContactRef.getId());
        ebOrg.setPrimaryContact(ebPrimaryContactRef);
        Iterator iter = this.getTelephoneNumbers().iterator();
        while (iter.hasNext()) {
            TelephoneNumberImpl phone = (TelephoneNumberImpl)iter.next();
            TelephoneNumber ebPhone = phone.toBindingObject();
            ebOrg.addTelephoneNumber(ebPhone);
        }
    }

    public HashSet getRegistryObjectRefs() {
        HashSet<RegistryObjectRef> refs = new HashSet<RegistryObjectRef>();
        if (this.parentRef != null) {
            refs.add(this.parentRef);
        }
        if (this.primaryContactRef != null) {
            refs.add(this.primaryContactRef);
        }
        return refs;
    }

    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified) {
            boolean i = false;
        } else {
            boolean bl = false;
        }
    }
}

