/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.har;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.hibernate.har.HARDeployerMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceControllerMBean;

public class HARDeployer
extends SubDeployerSupport
implements HARDeployerMBean {
    private static final ObjectName OBJECT_NAME = ObjectNameFactory.create((String)"jboss.har:service=HARDeployer");
    private ServiceControllerMBean serviceController;
    private HashMap deployments = new HashMap();
    private boolean validateDTDs;
    static /* synthetic */ Class class$org$jboss$system$ServiceControllerMBean;
    static /* synthetic */ Class class$org$jboss$hibernate$jmx$Hibernate;

    public HARDeployer() {
        this.setSuffixes(new String[]{"har"});
        this.setRelativeOrder(400);
    }

    public Iterator getDeployedApplications() {
        return this.deployments.values().iterator();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create((Class)(class$org$jboss$system$ServiceControllerMBean == null ? (class$org$jboss$system$ServiceControllerMBean = HARDeployer.class$("org.jboss.system.ServiceControllerMBean")) : class$org$jboss$system$ServiceControllerMBean), (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        super.startService();
    }

    protected void stopService() throws Exception {
        DeploymentInfo di;
        Iterator modules = this.deployments.values().iterator();
        while (modules.hasNext()) {
            di = (DeploymentInfo)modules.next();
            this.stop(di);
        }
        modules = new ArrayList(this.deployments.values()).iterator();
        while (modules.hasNext()) {
            di = (DeploymentInfo)modules.next();
            this.destroy(di);
        }
        this.deployments.clear();
        super.stopService();
        this.serviceController = null;
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.getFile();
        if (!urlStr.endsWith("har") && !urlStr.endsWith("har/")) {
            return false;
        }
        boolean accepts = false;
        try {
            String ddStr;
            URL dd = di.localCl.findResource("META-INF/hibernate-service.xml");
            if (dd == null) {
                return false;
            }
            if (di.localUrl != null) {
                urlStr = di.localUrl.toString();
            }
            if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                accepts = true;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.log.debug((Object)("accepts> url=" + di.url + ", accepted=" + accepts));
        return accepts;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        try {
            File file;
            di.watch = "file".equalsIgnoreCase(di.url.getProtocol()) ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "hibernate-service.xml")) : di.url;
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException("failed to initialize", (Throwable)e);
        }
        super.init(di);
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
        super.processNestedDeployments(di);
    }

    protected void deployUrl(DeploymentInfo di, URL url, String name) throws DeploymentException {
        super.deployUrl(di, url, name);
    }

    public boolean isDeployable(String name, URL url) {
        return name.endsWith("-service.xml") || super.isDeployable(name, url);
    }

    public synchronized void create(DeploymentInfo di) throws DeploymentException {
        super.create(di);
        Iterator iter = di.subDeployments.iterator();
        while (iter.hasNext()) {
            DeploymentInfo nested = (DeploymentInfo)iter.next();
            if (!nested.url.getFile().endsWith("hibernate-service.xml")) continue;
            Iterator serviceIter = nested.mbeans.iterator();
            while (serviceIter.hasNext()) {
                ObjectName service = (ObjectName)serviceIter.next();
                if (!this.isHibernateMBean(service)) continue;
                Attribute attr = new Attribute("HarUrl", di.url);
                try {
                    this.server.setAttribute(service, attr);
                }
                catch (Exception e) {
                    throw new DeploymentException("Failed to set HarUrl attribute: " + e.getMessage(), (Throwable)e);
                }
            }
            break block2;
        }
    }

    private boolean isHibernateMBean(ObjectName service) {
        try {
            MBeanInfo serviceInfo = this.server.getMBeanInfo(service);
            return (class$org$jboss$hibernate$jmx$Hibernate == null ? (class$org$jboss$hibernate$jmx$Hibernate = HARDeployer.class$("org.jboss.hibernate.jmx.Hibernate")) : class$org$jboss$hibernate$jmx$Hibernate).getName().equals(serviceInfo.getClassName());
        }
        catch (Throwable t) {
            this.log.warn((Object)("Unable to determine whether MBean [" + service + "] is Hibernate MBean"));
            return false;
        }
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        super.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        try {
            this.serviceController.stop(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("problem stopping har module: " + di.url, (Throwable)e);
        }
        super.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.deployments.remove(di.url);
        try {
            this.serviceController.destroy(di.deployedObject);
            this.serviceController.remove(di.deployedObject);
        }
        catch (Exception e) {
            throw new DeploymentException("problem destroying har module: " + di.url, (Throwable)e);
        }
        super.destroy(di);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

