/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jmx;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.management.Notification;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.jboss.hibernate.jmx.HibernateMBean;
import org.jboss.system.ServiceMBeanSupport;

public class Hibernate
extends ServiceMBeanSupport
implements HibernateMBean {
    public static final String SESSION_FACTORY_CREATE = "hibernate.sessionfactory.create";
    public static final String SESSION_FACTORY_DESTROY = "hibernate.sessionfactory.destroy";
    private URL harUrl;
    private String datasourceName;
    private String dialect;
    private String defaultSchema;
    private String maxFetchDepth;
    private String jdbcBatchSize;
    private String batchVersionedDataEnabled;
    private String jdbcFetchSize;
    private String jdbcScrollableResultSetEnabled;
    private String getGeneratedKeysEnabled;
    private String streamsForBinaryEnabled;
    private String reflectionOptimizationEnabled;
    private String hbm2ddlAuto;
    private String querySubstitutions;
    private String showSqlEnabled;
    private String username;
    private String password;
    private String queryCacheEnabled;
    private String cacheProviderClass;
    private String deployedTreeCacheJndiName;
    private String minimalPutsEnabled;
    private String cacheRegionPrefix;
    private String sessionFactoryInterceptor;
    private boolean dirty = false;
    private String sessionFactoryName;
    private SessionFactory sessionFactory;
    static /* synthetic */ Class class$net$sf$hibernate$transaction$JBossTransactionManagerLookup;
    static /* synthetic */ Class class$net$sf$hibernate$transaction$JTATransactionFactory;

    public String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    public void setSessionFactoryName(String sessionFactoryName) {
        this.sessionFactoryName = sessionFactoryName;
        this.dirty = true;
    }

    public URL getHarUrl() {
        return this.harUrl;
    }

    public void setHarUrl(URL harUrl) {
        this.harUrl = harUrl;
        this.dirty = true;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
        this.dirty = true;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        this.dirty = true;
    }

    public String getHbm2ddlAuto() {
        return this.hbm2ddlAuto;
    }

    public void setHbm2ddlAuto(String hbm2ddlAuto) {
        this.hbm2ddlAuto = hbm2ddlAuto;
        this.dirty = true;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
        this.dirty = true;
    }

    public String getMaxFetchDepth() {
        return this.maxFetchDepth;
    }

    public void setMaxFetchDepth(String maxFetchDepth) {
        this.maxFetchDepth = maxFetchDepth;
        this.dirty = true;
    }

    public String getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    public void setJdbcBatchSize(String jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
        this.dirty = true;
    }

    public String getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    public void setJdbcFetchSize(String jdbcFetchSize) {
        this.jdbcFetchSize = jdbcFetchSize;
        this.dirty = true;
    }

    public String getJdbcScrollableResultSetEnabled() {
        return this.jdbcScrollableResultSetEnabled;
    }

    public void setJdbcScrollableResultSetEnabled(String jdbcScrollableResultSetEnabled) {
        this.jdbcScrollableResultSetEnabled = jdbcScrollableResultSetEnabled;
        this.dirty = true;
    }

    public String getGetGeneratedKeysEnabled() {
        return this.getGeneratedKeysEnabled;
    }

    public void setGetGeneratedKeysEnabled(String getGeneratedKeysEnabled) {
        this.getGeneratedKeysEnabled = getGeneratedKeysEnabled;
        this.dirty = true;
    }

    public String getQuerySubstitutions() {
        return this.querySubstitutions;
    }

    public void setQuerySubstitutions(String querySubstitutions) {
        this.querySubstitutions = querySubstitutions;
        this.dirty = true;
    }

    public String getQueryCacheEnabled() {
        return this.queryCacheEnabled;
    }

    public void setQueryCacheEnabled(String queryCacheEnabled) {
        this.queryCacheEnabled = queryCacheEnabled;
        this.dirty = true;
    }

    public String getCacheProviderClass() {
        return this.cacheProviderClass;
    }

    public void setCacheProviderClass(String cacheProviderClass) {
        this.cacheProviderClass = cacheProviderClass;
        this.dirty = true;
    }

    public String getCacheRegionPrefix() {
        return this.cacheRegionPrefix;
    }

    public void setCacheRegionPrefix(String cacheRegionPrefix) {
        this.cacheRegionPrefix = cacheRegionPrefix;
        this.dirty = true;
    }

    public String getMinimalPutsEnabled() {
        return this.minimalPutsEnabled;
    }

    public void setMinimalPutsEnabled(String minimalPutsEnabled) {
        this.minimalPutsEnabled = minimalPutsEnabled;
        this.dirty = true;
    }

    public String getShowSqlEnabled() {
        return this.showSqlEnabled;
    }

    public void setShowSqlEnabled(String showSqlEnabled) {
        this.showSqlEnabled = showSqlEnabled;
        this.dirty = true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.dirty = true;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.dirty = true;
    }

    public String getSessionFactoryInterceptor() {
        return this.sessionFactoryInterceptor;
    }

    public void setSessionFactoryInterceptor(String sessionFactoryInterceptor) {
        this.sessionFactoryInterceptor = sessionFactoryInterceptor;
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSessionFactoryRunning() {
        return this.sessionFactory != null;
    }

    public String getDeployedTreeCacheJndiName() {
        return this.deployedTreeCacheJndiName;
    }

    public void setDeployedTreeCacheJndiName(String deployedTreeCacheJndiName) {
        this.deployedTreeCacheJndiName = deployedTreeCacheJndiName;
    }

    public String getBatchVersionedDataEnabled() {
        return this.batchVersionedDataEnabled;
    }

    public void setBatchVersionedDataEnabled(String batchVersionedDataEnabled) {
        this.batchVersionedDataEnabled = batchVersionedDataEnabled;
        this.dirty = true;
    }

    public String getStreamsForBinaryEnabled() {
        return this.streamsForBinaryEnabled;
    }

    public void setStreamsForBinaryEnabled(String streamsForBinaryEnabled) {
        this.streamsForBinaryEnabled = streamsForBinaryEnabled;
        this.dirty = true;
    }

    public String getReflectionOptimizationEnabled() {
        return this.reflectionOptimizationEnabled;
    }

    public void setReflectionOptimizationEnabled(String reflectionOptimizationEnabled) {
        this.reflectionOptimizationEnabled = reflectionOptimizationEnabled;
        this.dirty = true;
    }

    public void rebuildSessionFactory() throws Exception {
        this.destroySessionFactory();
        this.buildSessionFactory();
    }

    public void startService() throws Exception {
        this.buildSessionFactory();
    }

    public void stopService() throws Exception {
        this.destroySessionFactory();
    }

    private void buildSessionFactory() throws Exception {
        Configuration cfg = new Configuration();
        cfg.addProperties(this.getProperties());
        File file = new File(this.harUrl.getFile());
        if (file.isDirectory()) {
            cfg.addDirectory(file);
        } else {
            cfg.addJar(file);
        }
        Interceptor interceptorInstance = this.generateInterceptorInstance();
        if (interceptorInstance != null) {
            cfg.setInterceptor(interceptorInstance);
        }
        this.sessionFactory = cfg.buildSessionFactory();
        this.dirty = false;
        this.sendNotification(new Notification(SESSION_FACTORY_CREATE, this.getServiceName(), this.getNextNotificationSequenceNumber()));
    }

    private Interceptor generateInterceptorInstance() {
        if (this.sessionFactoryInterceptor == null) {
            return null;
        }
        this.log.info((Object)("Generating session factory interceptor instance [" + this.sessionFactoryInterceptor + "]"));
        try {
            return (Interceptor)Class.forName(this.sessionFactoryInterceptor).newInstance();
        }
        catch (Throwable t) {
            this.log.warn((Object)"Unable to generate session factory interceptor instance", t);
            return null;
        }
    }

    private void destroySessionFactory() throws Exception {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
            this.sendNotification(new Notification(SESSION_FACTORY_DESTROY, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        }
    }

    private Properties getProperties() {
        Properties props = new Properties();
        this.setUnlessNull(props, "hibernate.connection.datasource", this.datasourceName);
        this.setUnlessNull(props, "hibernate.dialect", this.dialect);
        this.setUnlessNull(props, "hibernate.session_factory_name", this.sessionFactoryName);
        this.setUnlessNull(props, "hibernate.cache.provider_class", this.cacheProviderClass);
        this.setUnlessNull(props, "hibernate.cache.region_prefix", this.cacheRegionPrefix);
        this.setUnlessNull(props, "hibernate.treecache.jndiName", this.deployedTreeCacheJndiName);
        this.setUnlessNull(props, "hibernate.cache.use_minimal_puts", this.minimalPutsEnabled);
        this.setUnlessNull(props, "hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        this.setUnlessNull(props, "hibernate.default_schema", this.defaultSchema);
        this.setUnlessNull(props, "hibernate.jdbc.batch_size", this.jdbcBatchSize);
        this.setUnlessNull(props, "hibernate.jdbc.fetch_size", this.jdbcFetchSize);
        this.setUnlessNull(props, "hibernate.jdbc.use_scrollable_resultset", this.jdbcScrollableResultSetEnabled);
        this.setUnlessNull(props, "hibernate.cache.use_query_cache", this.queryCacheEnabled);
        this.setUnlessNull(props, "hibernate.query.substitutions", this.querySubstitutions);
        this.setUnlessNull(props, "hibernate.max_fetch_depth", this.maxFetchDepth);
        this.setUnlessNull(props, "hibernate.show_sql", this.showSqlEnabled);
        this.setUnlessNull(props, "hibernate.jdbc.use_get_generated_keys", this.getGeneratedKeysEnabled);
        this.setUnlessNull(props, "hibernate.connection.username", this.username);
        this.setUnlessNull(props, "hibernate.connection.password", this.password);
        this.setUnlessNull(props, "hibernate.transaction.manager_lookup_class", (class$net$sf$hibernate$transaction$JBossTransactionManagerLookup == null ? (class$net$sf$hibernate$transaction$JBossTransactionManagerLookup = Hibernate.class$("net.sf.hibernate.transaction.JBossTransactionManagerLookup")) : class$net$sf$hibernate$transaction$JBossTransactionManagerLookup).getName());
        this.setUnlessNull(props, "hibernate.transaction.factory_class", (class$net$sf$hibernate$transaction$JTATransactionFactory == null ? (class$net$sf$hibernate$transaction$JTATransactionFactory = Hibernate.class$("net.sf.hibernate.transaction.JTATransactionFactory")) : class$net$sf$hibernate$transaction$JTATransactionFactory).getName());
        this.setUnlessNull(props, "hibernate.jdbc.batch_versioned_data", this.batchVersionedDataEnabled);
        this.setUnlessNull(props, "hibernate.jdbc.use_streams_for_binary", this.streamsForBinaryEnabled);
        this.setUnlessNull(props, "hibernate.cglib.use_reflection_optimizer", this.reflectionOptimizationEnabled);
        return props;
    }

    private void setUnlessNull(Properties props, String key, String value) {
        if (value != null) {
            props.setProperty(key, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

