/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.session;

import javax.transaction.Synchronization;
import net.sf.hibernate.Session;
import org.jboss.hibernate.session.HibernateContext;
import org.jboss.logging.Logger;

class TransactionSynch
implements Synchronization {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$hibernate$session$TransactionSynch == null ? (class$org$jboss$hibernate$session$TransactionSynch = TransactionSynch.class$("org.jboss.hibernate.session.TransactionSynch")) : class$org$jboss$hibernate$session$TransactionSynch));
    private String name;
    private Session session;
    static /* synthetic */ Class class$org$jboss$hibernate$session$TransactionSynch;

    public TransactionSynch(String name, Session session) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing synch [name=" + name + ", session=" + session + "]"));
        }
        if (session == null) {
            throw new IllegalArgumentException("Session to synchronize cannot be null");
        }
        this.name = name;
        this.session = session;
    }

    public void beforeCompletion() {
        if (!this.session.isOpen()) {
            log.warn((Object)"Session already closed");
        } else {
            try {
                log.trace((Object)"Flushing Session");
                this.session.flush();
            }
            catch (Throwable t) {
                log.warn((Object)"Error flushing session");
            }
        }
    }

    public void afterCompletion(int status) {
        if (this.session.isOpen()) {
            try {
                log.trace((Object)"Closing Session");
                this.session.close();
            }
            catch (Throwable t) {
                log.warn((Object)"Unable to close session");
            }
        }
        if (this.session != HibernateContext.unbind(this.name)) {
            log.warn((Object)"Synch encountered different session in context while performing unbind");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

