/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ant;

import com.sshtools.ant.Ssh;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Sftp
extends Ssh {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    protected static final int MK_DIR = 4;
    protected static final int CHMOD = 5;
    private String remotedir = ".";
    private File listing;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    private String chmod = "777";
    private FileUtils fileUtils = FileUtils.newFileUtils();
    protected static final String[] ACTION_STRS = new String[]{"Sending", "Getting", "Deleting", "Listing", "Making directory", "chmod"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"Sent", "Retrieved", "Deleted", "Listed", "Created directory", "Mode changed"};

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setNewer(boolean bl) {
        this.newerOnly = bl;
    }

    public void setDepends(boolean bl) {
        this.newerOnly = bl;
    }

    public void setChmod(String string) {
        this.chmod = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setAction(String string) throws BuildException {
        this.log("DEPRECATED - The setAction(String) method has been deprecated. Use setAction(FTP.Action) instead.");
        Action action = new Action();
        action.setValue(string);
        this.action = action.getAction();
    }

    public void setAction(Action action) throws BuildException {
        this.action = action.getAction();
    }

    public void setSkipFailedTransfers(boolean bl) {
        this.skipFailedTransfers = bl;
    }

    public void setIgnoreNoncriticalErrors(boolean bl) {
        this.ignoreNoncriticalErrors = bl;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
        if (this.action == 5 && this.chmod == null) {
            throw new BuildException("chmod attribute must be set for chmod action!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int transferFiles(SftpClient sftpClient, FileSet fileSet) throws BuildException, IOException {
        DirectoryScanner directoryScanner;
        if (this.action == 0) {
            directoryScanner = fileSet.getDirectoryScanner(((ProjectComponent)this).project);
        } else {
            directoryScanner = new SftpDirectoryScanner(sftpClient);
            fileSet.setupDirectoryScanner((FileScanner)directoryScanner, ((ProjectComponent)this).project);
            directoryScanner.scan();
        }
        String[] stringArray = directoryScanner.getIncludedFiles();
        String string = null;
        if (directoryScanner.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            string = directoryScanner.getBasedir().getAbsolutePath();
        }
        BufferedWriter bufferedWriter = null;
        try {
            if (this.action == 3) {
                File file = this.fileUtils.getParentFile(this.listing);
                if (!file.exists()) {
                    file.mkdirs();
                }
                bufferedWriter = new BufferedWriter(new FileWriter(this.listing));
            }
            block8: for (int i = 0; i < stringArray.length; ++i) {
                switch (this.action) {
                    case 0: {
                        this.sendFile(sftpClient, string, stringArray[i]);
                        continue block8;
                    }
                    case 1: {
                        this.getFile(sftpClient, string, stringArray[i]);
                        continue block8;
                    }
                    case 2: {
                        this.delFile(sftpClient, stringArray[i]);
                        continue block8;
                    }
                    case 5: {
                        this.chmod(sftpClient, stringArray[i]);
                        ++this.transferred;
                        continue block8;
                    }
                    default: {
                        throw new BuildException("unknown ftp action ".concat(String.valueOf(String.valueOf(this.action))));
                    }
                }
            }
            Object var9_9 = null;
            if (bufferedWriter == null) return stringArray.length;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (bufferedWriter == null) throw throwable;
            bufferedWriter.close();
            throw throwable;
        }
        bufferedWriter.close();
        return stringArray.length;
    }

    protected void transferFiles(SftpClient sftpClient) throws BuildException, IOException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(i);
            if (fileSet == null) continue;
            this.transferFiles(sftpClient, fileSet);
        }
        this.log(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.transferred))).append(" files ").append(COMPLETED_ACTION_STRS[this.action]))));
        if (this.skipped != 0) {
            this.log(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.skipped))).append(" files were not successfully ").append(COMPLETED_ACTION_STRS[this.action]))));
        }
    }

    protected String resolveFile(String string) {
        return string.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    protected void createParents(SftpClient sftpClient, String string) throws BuildException, IOException {
        String string2;
        Vector<File> vector = new Vector<File>();
        File file = new File(string);
        while ((string2 = file.getParent()) != null) {
            file = new File(string2);
            vector.addElement(file);
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            file = (File)vector.elementAt(i);
            if (this.dirCache.contains(file)) continue;
            this.log("creating remote directory ".concat(String.valueOf(String.valueOf(this.resolveFile(file.getPath())))), 3);
            try {
                sftpClient.mkdir(this.resolveFile(file.getPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dirCache.addElement(file);
        }
    }

    protected boolean isUpToDate(SftpClient sftpClient, File file, String string) throws BuildException, IOException {
        try {
            this.log("checking date for ".concat(String.valueOf(String.valueOf(string))), 3);
            FileAttributes fileAttributes = sftpClient.stat(string);
            long l = fileAttributes.getModifiedTime().longValue() * (long)1000;
            long l2 = file.lastModified();
            if (this.action == 0) {
                boolean bl = l > l2;
                return bl;
            }
            boolean bl = l2 > l;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendFile(SftpClient var1_1, String var2_2, String var3_3) throws BuildException, IOException {
        block26: {
            block22: {
                block25: {
                    block21: {
                        var4_4 = null;
                        var5_5 = null;
                        try {
                            try {
                                var6_6 = this.project.resolveFile(new File(var2_2, var3_3).getPath());
                                var7_8 = this.resolveFile(var3_3);
                                if (this.newerOnly && this.isUpToDate(var1_1, var6_6, var7_8)) {
                                    var9_10 = null;
                                    break block21;
                                }
                                if (this.verbose) {
                                    this.log(String.valueOf(String.valueOf(new StringBuffer("transferring ").append(var6_6.getAbsolutePath()).append(" to ").append(this.remotedir).append(var7_8))));
                                }
                                var4_4 = new BufferedInputStream(new FileInputStream(var6_6));
                                this.createParents(var1_1, var3_3);
                                var1_1.put(var6_6.getAbsolutePath(), var7_8);
                                var1_1.chmod(Integer.parseInt(this.chmod, 8), var7_8);
                                this.log(String.valueOf(String.valueOf(new StringBuffer("File ").append(var6_6.getAbsolutePath()).append(" copied to ").append(this.host))), 3);
                                ++this.transferred;
                                break block22;
                            }
                            catch (IOException var6_7) {
                                var7_9 = "Could not put file: ".concat(String.valueOf(String.valueOf(var6_7.getMessage())));
                                if (this.skipFailedTransfers != true) throw new BuildException(var7_9);
                                this.log(var7_9, 1);
                                ++this.skipped;
                                var9_12 = null;
                                try {
                                    if (var4_4 != null) {
                                        var4_4.close();
                                    }
                                }
                                catch (IOException var10_16) {
                                    // empty catch block
                                }
                                try {
                                    if (var5_5 == null) return;
                                    var5_5.close();
                                    return;
                                }
                                catch (IOException var10_16) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable var8_18) {
                            block24: {
                                var9_13 = null;
                                ** try [egrp 2[TRYBLOCK] [2 : 288->301)] { 
lbl43:
                                // 1 sources

                                if (var4_4 != null) {
                                    var4_4.close();
                                }
                                break block24;
lbl46:
                                // 1 sources

                                catch (IOException var10_17) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [3 : 303->316)] { 
lbl50:
                            // 1 sources

                            if (var5_5 == null) throw var8_18;
                            var5_5.close();
                            throw var8_18;
lbl53:
                            // 1 sources

                            catch (IOException var10_17) {
                                // empty catch block
                            }
                            throw var8_18;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 288->301)] { 
lbl58:
                    // 1 sources

                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    break block25;
lbl61:
                    // 1 sources

                    catch (IOException var10_14) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [3 : 303->316)] { 
lbl65:
                // 1 sources

                if (var5_5 == null) return;
                var5_5.close();
                return;
lbl68:
                // 1 sources

                catch (IOException var10_14) {
                    // empty catch block
                }
                return;
            }
            var9_11 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 288->301)] { 
lbl74:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            break block26;
lbl77:
            // 1 sources

            catch (IOException var10_15) {
                // empty catch block
            }
        }
        try {}
        catch (IOException var10_15) {}
        if (var5_5 == null) return;
        var5_5.close();
        return;
    }

    protected void delFile(SftpClient sftpClient, String string) throws BuildException, IOException {
        if (this.verbose) {
            this.log("deleting ".concat(String.valueOf(String.valueOf(string))));
        }
        try {
            String string2 = this.resolveFile(string);
            sftpClient.rm(string2);
            this.log(String.valueOf(String.valueOf(new StringBuffer("File ").append(string).append(" deleted from ").append(this.host))), 3);
            ++this.transferred;
        }
        catch (IOException iOException) {
            String string3 = "could not delete file: ".concat(String.valueOf(String.valueOf(iOException.getMessage())));
            if (this.skipFailedTransfers) {
                this.log(string3, 1);
                ++this.skipped;
            }
            throw new BuildException(string3);
        }
    }

    protected void chmod(SftpClient sftpClient, String string) throws BuildException, IOException {
        sftpClient.chmod(Integer.parseInt(this.chmod, 8), this.resolveFile(string));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getFile(SftpClient var1_1, String var2_2, String var3_3) throws BuildException, IOException {
        block27: {
            block23: {
                block26: {
                    block22: {
                        var4_4 = null;
                        var5_5 = null;
                        try {
                            try {
                                var6_6 = this.project.resolveFile(new File(var2_2, var3_3).getAbsolutePath());
                                if (this.newerOnly && this.isUpToDate(var1_1, var6_6, this.resolveFile(var3_3))) {
                                    var10_8 = null;
                                    break block22;
                                }
                                if (this.verbose) {
                                    this.log(String.valueOf(String.valueOf(new StringBuffer("transferring ").append(this.remotedir).append(var3_3).append(" to ").append(var6_6.getAbsolutePath()))));
                                }
                                if (!(var7_16 = this.fileUtils.getParentFile(var6_6)).exists()) {
                                    var7_16.mkdirs();
                                }
                                var4_4 = new BufferedOutputStream(new FileOutputStream(var6_6));
                                var1_1.get(var6_6.getAbsolutePath(), var3_3);
                                var8_18 = var1_1.stat(var3_3);
                                var6_6.setLastModified(var8_18.getModifiedTime().longValue() * (long)1000);
                                this.log(String.valueOf(String.valueOf(new StringBuffer("File ").append(var6_6.getAbsolutePath()).append(" copied from ").append(this.host))), 3);
                                ++this.transferred;
                                break block23;
                            }
                            catch (IOException var6_7) {
                                var7_17 = "could not get file: ".concat(String.valueOf(String.valueOf(var6_7.getMessage())));
                                if (this.skipFailedTransfers != true) throw new BuildException(var7_17);
                                this.log(var7_17, 1);
                                ++this.skipped;
                                var10_10 = null;
                                try {
                                    if (var4_4 != null) {
                                        var4_4.close();
                                    }
                                }
                                catch (IOException var11_14) {
                                    // empty catch block
                                }
                                try {
                                    if (var5_5 == null) return;
                                    var5_5.close();
                                    return;
                                }
                                catch (IOException var11_14) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable var9_19) {
                            block25: {
                                var10_11 = null;
                                ** try [egrp 2[TRYBLOCK] [2 : 312->325)] { 
lbl46:
                                // 1 sources

                                if (var4_4 != null) {
                                    var4_4.close();
                                }
                                break block25;
lbl49:
                                // 1 sources

                                catch (IOException var11_15) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [3 : 327->340)] { 
lbl53:
                            // 1 sources

                            if (var5_5 == null) throw var9_19;
                            var5_5.close();
                            throw var9_19;
lbl56:
                            // 1 sources

                            catch (IOException var11_15) {
                                // empty catch block
                            }
                            throw var9_19;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 312->325)] { 
lbl61:
                    // 1 sources

                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    break block26;
lbl64:
                    // 1 sources

                    catch (IOException var11_12) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [3 : 327->340)] { 
lbl68:
                // 1 sources

                if (var5_5 == null) return;
                var5_5.close();
                return;
lbl71:
                // 1 sources

                catch (IOException var11_12) {
                    // empty catch block
                }
                return;
            }
            var10_9 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 312->325)] { 
lbl77:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            break block27;
lbl80:
            // 1 sources

            catch (IOException var11_13) {
                // empty catch block
            }
        }
        try {}
        catch (IOException var11_13) {}
        if (var5_5 == null) return;
        var5_5.close();
        return;
    }

    protected void makeRemoteDir(SftpClient sftpClient, String string) throws BuildException {
        if (this.verbose) {
            this.log("creating directory: ".concat(String.valueOf(String.valueOf(string))));
        }
        try {
            sftpClient.mkdir(string);
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        this.checkConfiguration();
        this.validate();
        try {
            Integer.parseInt(this.chmod, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("chmod attribute format is incorrect, use octal number format i.e 0777");
        }
        this.connectAndAuthenticate();
        SftpClient sftpClient = null;
        try {
            try {
                this.log("Opening SFTP client");
                sftpClient = this.ssh.openSftpClient();
                if (this.action == 4) {
                    this.makeRemoteDir(sftpClient, this.remotedir);
                } else {
                    this.log("Setting the remote directory");
                    sftpClient.cd(this.remotedir);
                    this.remotedir = sftpClient.pwd();
                    if (!this.remotedir.endsWith("/")) {
                        this.remotedir = String.valueOf(String.valueOf(this.remotedir)).concat("/");
                    }
                    this.log(String.valueOf(String.valueOf(ACTION_STRS[this.action])).concat(" files"));
                    this.transferFiles(sftpClient);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("error during FTP transfer: ".concat(String.valueOf(String.valueOf(iOException))));
            }
            Object var4_3 = null;
            if (sftpClient == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (sftpClient == null) throw throwable;
            if (sftpClient.isClosed()) throw throwable;
            try {
                this.log("disconnecting", 3);
                sftpClient.quit();
                this.ssh.disconnect();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        if (sftpClient.isClosed()) return;
        try {}
        catch (IOException iOException) {}
        this.log("disconnecting", 3);
        sftpClient.quit();
        this.ssh.disconnect();
        return;
    }

    public static class Action
    extends EnumeratedAttribute {
        private static final String[] validActions = new String[]{"send", "put", "recv", "get", "del", "delete", "list", "mkdir", "chmod"};

        public String[] getValues() {
            return validActions;
        }

        public int getAction() {
            String string = this.getValue().toLowerCase(Locale.US);
            if (string.equals("send") || string.equals("put")) {
                return 0;
            }
            if (string.equals("recv") || string.equals("get")) {
                return 1;
            }
            if (string.equals("del") || string.equals("delete")) {
                return 2;
            }
            if (string.equals("list")) {
                return 3;
            }
            if (string.equals("chmod")) {
                return 5;
            }
            if (string.equals("mkdir")) {
                return 4;
            }
            return 0;
        }
    }

    protected class SftpDirectoryScanner
    extends DirectoryScanner {
        protected SftpClient sftp = null;

        public SftpDirectoryScanner(SftpClient sftpClient) {
            this.sftp = sftpClient;
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            this.scandir(Sftp.this.remotedir, true);
        }

        protected void scandir(String string, boolean bl) {
            try {
                List list = this.sftp.ls(string);
                if (!string.endsWith("/")) {
                    string = String.valueOf(String.valueOf(string)).concat("/");
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    SftpFile sftpFile = (SftpFile)iterator.next();
                    if (sftpFile.getFilename().equals(".") || sftpFile.getFilename().equals("..")) continue;
                    if (sftpFile.isDirectory()) {
                        string2 = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(sftpFile.getFilename())));
                        if (this.isIncluded(string2)) {
                            if (!this.isExcluded(string2)) {
                                this.dirsIncluded.addElement(string2);
                                if (bl) {
                                    this.scandir(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(sftpFile.getFilename()))), bl);
                                }
                            } else {
                                this.dirsExcluded.addElement(string2);
                                if (bl && this.couldHoldIncluded(string2)) {
                                    this.scandir(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(sftpFile.getFilename()))), bl);
                                }
                            }
                        } else {
                            this.dirsNotIncluded.addElement(string2);
                            if (bl && this.couldHoldIncluded(string2)) {
                                this.scandir(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(sftpFile.getFilename()))), bl);
                            }
                        }
                        if (bl) continue;
                        this.scandir(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(sftpFile.getFilename()))), bl);
                        continue;
                    }
                    if (!sftpFile.isFile()) continue;
                    string2 = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(sftpFile.getFilename())));
                    if (this.isIncluded(string2)) {
                        if (!this.isExcluded(string2)) {
                            this.filesIncluded.addElement(string2);
                            continue;
                        }
                        this.filesExcluded.addElement(string2);
                        continue;
                    }
                    this.filesNotIncluded.addElement(string2);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while communicating with SFTP ", (Throwable)iOException);
            }
        }
    }
}

