/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ant;

import com.sshtools.ant.Sftp;
import com.sshtools.ant.SshSubTask;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.session.PseudoTerminal;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.session.SessionOutputReader;
import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Ssh
extends Task {
    protected String host;
    protected int port = 22;
    protected String username;
    protected String password;
    protected String keyfile;
    protected String passphrase;
    protected String cipher;
    protected String mac;
    protected String fingerprint;
    protected String logfile = null;
    protected boolean verifyhost = true;
    protected boolean always = false;
    protected SshClient ssh;
    protected Vector tasks = new Vector();
    protected String sshtoolsHome;
    protected String newline = "\n";
    private Logger logger;

    protected void validate() throws BuildException {
        if (this.host == null) {
            throw new BuildException("You must provide a host to connect to!");
        }
        if (this.username == null) {
            throw new BuildException("You must supply a username for authentication!");
        }
        if (this.password == null && this.keyfile == null) {
            throw new BuildException("You must supply either a password or keyfile/passphrase to authenticate!");
        }
        if (this.verifyhost && this.fingerprint == null) {
            throw new BuildException("Public key fingerprint required to verify the host");
        }
        this.logger = Logger.getLogger("com.sshtools");
        try {
            if (this.logfile != null) {
                FileHandler fileHandler = new FileHandler(this.logfile);
                this.logger.addHandler(fileHandler);
                this.logger.setLevel(Level.ALL);
            } else {
                this.logger.setLevel(Level.OFF);
            }
        }
        catch (IOException iOException) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("Failed to initialize logfile ").append(this.logfile).append(": ").append(iOException.getMessage()))));
        }
        catch (SecurityException securityException) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("Security exception on logfile ").append(this.logfile).append(": ").append(securityException.getMessage()))));
        }
    }

    protected void connectAndAuthenticate() throws BuildException {
        block18: {
            if (this.sshtoolsHome != null) {
                System.setProperty("sshtools.home", this.sshtoolsHome);
            }
            this.log("Initializing J2SSH");
            if (this.logfile != null) {
                System.setProperty("sshtools.logfile", this.logfile);
            }
            try {
                int n;
                PublicKeyAuthenticationClient publicKeyAuthenticationClient;
                ConfigurationLoader.initialize((boolean)false);
                this.log(String.valueOf(String.valueOf(new StringBuffer("Creating connection to ").append(this.host).append(":").append(String.valueOf(this.port)))));
                if (this.ssh != null) break block18;
                this.ssh = new SshClient();
                SshConnectionProperties sshConnectionProperties = new SshConnectionProperties();
                sshConnectionProperties.setHost(this.host);
                sshConnectionProperties.setPort(this.port);
                sshConnectionProperties.setUsername(this.username);
                if (this.cipher != null) {
                    if (SshCipherFactory.getSupportedCiphers().contains(this.cipher)) {
                        sshConnectionProperties.setPrefSCEncryption(this.cipher);
                        sshConnectionProperties.setPrefCSEncryption(this.cipher);
                    } else {
                        this.log(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.cipher))).append(" is not a supported cipher, using default ").append(SshCipherFactory.getDefaultCipher()))));
                    }
                }
                if (this.mac != null) {
                    if (SshHmacFactory.getSupportedMacs().contains(this.mac)) {
                        sshConnectionProperties.setPrefCSMac(this.mac);
                        sshConnectionProperties.setPrefSCMac(this.mac);
                    } else {
                        this.log(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mac))).append(" is not a supported mac, using default ").append(SshHmacFactory.getDefaultHmac()))));
                    }
                }
                this.log("Connecting....");
                this.ssh.connect(sshConnectionProperties, (HostKeyVerification)new AbstractKnownHostsKeyVerification(new File(System.getProperty("user.home"), String.valueOf(String.valueOf(new StringBuffer(".ssh").append(File.separator).append("known_hosts")))).getAbsolutePath()){

                    public void onUnknownHost(String string, SshPublicKey sshPublicKey) throws InvalidHostFileException {
                        if (Ssh.this.verifyhost) {
                            if (sshPublicKey.getFingerprint().equalsIgnoreCase(Ssh.this.fingerprint)) {
                                this.allowHost(string, sshPublicKey, Ssh.this.always);
                            }
                        } else {
                            this.allowHost(string, sshPublicKey, Ssh.this.always);
                        }
                    }

                    public void onHostKeyMismatch(String string, SshPublicKey sshPublicKey, SshPublicKey sshPublicKey2) throws InvalidHostFileException {
                        if (Ssh.this.verifyhost) {
                            if (sshPublicKey2.getFingerprint().equalsIgnoreCase(Ssh.this.fingerprint)) {
                                this.allowHost(string, sshPublicKey2, Ssh.this.always);
                            }
                        } else {
                            this.allowHost(string, sshPublicKey2, Ssh.this.always);
                        }
                    }

                    public void onDeniedHost(String string) {
                        Ssh.this.log("The server host key is denied!");
                    }
                });
                boolean bl = false;
                this.log("Authenticating ".concat(String.valueOf(String.valueOf(this.username))));
                if (this.keyfile != null) {
                    this.log("Performing public key authentication");
                    publicKeyAuthenticationClient = new PublicKeyAuthenticationClient();
                    SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse((File)new File(this.keyfile));
                    if (sshPrivateKeyFile.isPassphraseProtected() && this.passphrase == null) {
                        throw new BuildException("Private key file is passphrase protected, please supply a valid passphrase!");
                    }
                    SshPrivateKey sshPrivateKey = sshPrivateKeyFile.toPrivateKey(this.passphrase);
                    publicKeyAuthenticationClient.setUsername(this.username);
                    publicKeyAuthenticationClient.setKey(sshPrivateKey);
                    n = this.ssh.authenticate((SshAuthenticationClient)publicKeyAuthenticationClient);
                    if (n == 4) {
                        bl = true;
                    } else if (n == 3) {
                        this.log("Public key authentication completed, attempting password authentication");
                    } else {
                        throw new BuildException("Public Key Authentication failed!");
                    }
                }
                if (this.password == null || bl) break block18;
                this.log("Performing password authentication");
                publicKeyAuthenticationClient = new PasswordAuthenticationClient();
                publicKeyAuthenticationClient.setUsername(this.username);
                publicKeyAuthenticationClient.setPassword(this.password);
                n = this.ssh.authenticate((SshAuthenticationClient)publicKeyAuthenticationClient);
                if (n == 4) {
                    this.log("Authentication complete");
                    break block18;
                }
                if (n == 3) {
                    throw new BuildException("Password Authentication succeeded but further authentication required!");
                }
                throw new BuildException("Password Authentication failed!");
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
    }

    protected void disconnect() throws BuildException {
        try {
            this.log("Disconnecting from ".concat(String.valueOf(String.valueOf(this.host))));
            this.ssh.disconnect();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    public void execute() throws BuildException {
        this.validate();
        this.connectAndAuthenticate();
        Iterator iterator = ((AbstractList)this.tasks).iterator();
        while (iterator.hasNext()) {
            SshSubTask sshSubTask = (SshSubTask)iterator.next();
            sshSubTask.execute(this.ssh);
        }
        this.disconnect();
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setNewline(String string) {
        this.newline = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setKeyfile(String string) {
        this.keyfile = string;
    }

    public void setPassphrase(String string) {
        this.passphrase = string;
    }

    public void setCipher(String string) {
        this.cipher = string;
    }

    public void setMac(String string) {
        this.mac = string;
    }

    public void setLogfile(String string) {
        this.logfile = string;
    }

    public void setFingerprint(String string) {
        this.fingerprint = string;
    }

    public void setVerifyhost(boolean bl) {
        this.verifyhost = bl;
    }

    public void setAlways(boolean bl) {
        this.always = bl;
    }

    public void setSshtoolshome(String string) {
        this.sshtoolsHome = string;
    }

    public Sftp createSftp() {
        Sftp sftp = new Sftp();
        this.tasks.addElement(sftp);
        return new Sftp();
    }

    public SshSubTask createShell() {
        Shell shell = new Shell();
        this.tasks.addElement(shell);
        return shell;
    }

    public SshSubTask createExec() {
        Exec exec = new Exec(this);
        this.tasks.addElement(exec);
        return exec;
    }

    public class Shell
    extends SshSubTask
    implements PseudoTerminal {
        private String term = null;
        private int cols = 80;
        private int rows = 34;
        private int width = 0;
        private int height = 0;
        private String terminalModes = "";
        private Vector commands = new Vector();
        private SessionChannelClient session;
        protected SessionOutputReader output;

        public void execute(SshClient sshClient) throws BuildException {
            this.validate();
            try {
                this.session = sshClient.openSessionChannel();
                this.output = new SessionOutputReader(this.session);
                this.allocatePseudoTerminal(this.session);
                if (!this.session.startShell()) {
                    throw new BuildException("The session failed to start");
                }
                this.performTasks(this.session);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void validate() throws BuildException {
            if (Ssh.this.ssh == null) {
                throw new BuildException("Invalid SSH session");
            }
            if (!Ssh.this.ssh.isConnected()) {
                throw new BuildException("The SSH session is not connected");
            }
        }

        protected void allocatePseudoTerminal(SessionChannelClient sessionChannelClient) throws BuildException {
            try {
                if (this.term != null && !sessionChannelClient.requestPseudoTerminal((PseudoTerminal)this)) {
                    throw new BuildException("The server failed to allocate a pseudo terminal");
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }

        protected void performTasks(SessionChannelClient sessionChannelClient) throws BuildException {
            try {
                if (this.commands.size() > 0) {
                    Iterator iterator = ((AbstractList)this.commands).iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e instanceof Write) {
                            ((Write)e).execute();
                            continue;
                        }
                        if (e instanceof Read) {
                            ((Read)e).execute();
                            continue;
                        }
                        throw new BuildException("Unexpected shell operation ".concat(String.valueOf(String.valueOf(e.toString()))));
                    }
                } else {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)sessionChannelClient.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        Ssh.this.log(string);
                    }
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }

        public void setTerm(String string) {
            this.term = string;
        }

        public void setCols(int n) {
            this.cols = n;
        }

        public void setRows(int n) {
            this.rows = n;
        }

        public String getTerm() {
            return this.term;
        }

        public int getColumns() {
            return this.cols;
        }

        public int getRows() {
            return this.rows;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String getEncodedTerminalModes() {
            return this.terminalModes;
        }

        public Write createWrite() {
            Write write = new Write();
            this.commands.add(write);
            return write;
        }

        public Read createRead() {
            Read read = new Read();
            this.commands.add(read);
            return read;
        }

        public class Write {
            protected boolean echo = true;
            protected String taskString = "";
            protected boolean newline = true;

            public void execute() throws BuildException {
                try {
                    if (this.echo) {
                        Ssh.this.log(this.taskString);
                    }
                    Shell.this.session.getOutputStream().write(this.taskString.getBytes());
                    if (this.newline) {
                        Shell.this.session.getOutputStream().write(((Shell)Shell.this).Ssh.this.newline.getBytes());
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException((Throwable)iOException);
                }
            }

            public void addText(String string) {
                this.setString(Ssh.this.getProject().replaceProperties(string));
            }

            public void setString(String string) {
                this.taskString = String.valueOf(String.valueOf(this.taskString)).concat(String.valueOf(String.valueOf(string)));
            }

            public void setEcho(boolean bl) {
                this.echo = bl;
            }

            public void setNewline(boolean bl) {
                this.newline = bl;
            }
        }

        public class Read {
            protected String taskString = "";
            private int timeout = 0;

            public void execute() throws BuildException {
                try {
                    Shell.this.output.markCurrentPosition();
                    if (!Shell.this.output.waitForString(this.taskString, this.timeout)) {
                        throw new BuildException("Timeout waiting for string ".concat(String.valueOf(String.valueOf(this.taskString))));
                    }
                    Ssh.this.log(Shell.this.output.getMarkedOutput());
                }
                catch (InterruptedException interruptedException) {
                    throw new BuildException((Throwable)interruptedException);
                }
            }

            public void addText(String string) {
                this.setString(Ssh.this.getProject().replaceProperties(string));
            }

            public void setTimeout(int n) {
                this.timeout = n;
            }

            public void setString(String string) {
                this.taskString = String.valueOf(String.valueOf(this.taskString)).concat(String.valueOf(String.valueOf(string)));
            }
        }
    }

    public class Exec
    extends Shell {
        private String cmd;

        public Exec(Ssh ssh) {
        }

        public void execute(SshClient sshClient) throws BuildException {
            this.validate();
            try {
                SessionChannelClient sessionChannelClient = sshClient.openSessionChannel();
                this.output = new SessionOutputReader(sessionChannelClient);
                this.allocatePseudoTerminal(sessionChannelClient);
                if (!sessionChannelClient.executeCommand(this.cmd)) {
                    throw new BuildException("The command failed to start");
                }
                this.performTasks(sessionChannelClient);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setCmd(String string) {
            this.cmd = string;
        }
    }
}

