/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.qc;

import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterBean;
import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterPunchData;
import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterResult;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.tma.qc.Overlap;
import at.tugraz.genome.tma.qc.PunchValues;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

public class QualityControlBean
extends AlgorithmAdapterBean {
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    SessionContext sessionContext;

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    protected Collection executeAlgorithm(AlgorithmAdapterPunchData data, Hashtable parameters) throws TmaGlobalException {
        Long[] imageIds;
        ArrayList<AlgorithmAdapterResult> results = new ArrayList<AlgorithmAdapterResult>();
        Integer cy3_threshold_obj = (Integer)parameters.get("red_threshold");
        int cy3_threshold = cy3_threshold_obj;
        Integer cy5_threshold_obj = (Integer)parameters.get("green_threshold");
        int cy5_threshold = cy5_threshold_obj;
        Hashtable image_table = data.getBufferedImages();
        Long cy3_image_id = (Long)image_table.get("Cy3ID");
        Long cy5_image_id = (Long)image_table.get("Cy5ID");
        BufferedImage cy3_image = (BufferedImage)image_table.get("Cy3image");
        BufferedImage cy5_image = (BufferedImage)image_table.get("Cy5image");
        if (cy3_image != null) {
            imageIds = new Long[]{cy3_image_id};
            AlgorithmAdapterResult cy3_result = new AlgorithmAdapterResult(data, imageIds, "Cy3 Positive Region(%) ", this.getSingleImageResultValue(cy3_image, cy3_threshold));
            results.add(cy3_result);
        }
        if (cy5_image != null) {
            imageIds = new Long[]{cy5_image_id};
            AlgorithmAdapterResult cy5_result = new AlgorithmAdapterResult(data, imageIds, "Cy5 Positive Region(%) ", this.getSingleImageResultValue(cy5_image, cy5_threshold));
            results.add(cy5_result);
        }
        if (cy3_image != null && cy5_image != null) {
            imageIds = new Long[]{cy3_image_id, cy5_image_id};
            AlgorithmAdapterResult result = new AlgorithmAdapterResult(data, imageIds, "Overlap (%) ", this.getOverlapResultValue(cy3_image, cy5_image, cy3_threshold, cy5_threshold));
            results.add(result);
        }
        return results;
    }

    private String getOverlapResultValue(BufferedImage cy3_image, BufferedImage cy5_image, int cy3_threshold, int cy5_threshold) {
        Overlap overlap_obj = new Overlap(cy3_image, cy5_image);
        double overlap_percent = 0.0;
        try {
            overlap_percent = overlap_obj.getOverlapPercentBasedOnPosRegions(cy3_threshold, cy5_threshold);
        }
        catch (ArithmeticException arith_exc) {
            overlap_percent = 0.0;
        }
        catch (IllegalArgumentException ex) {
            overlap_percent = -1.0;
        }
        DecimalFormat df = new DecimalFormat("#.###");
        df.applyPattern("#.###");
        df.getDecimalFormatSymbols().setDecimalSeparator('.');
        return df.format(overlap_percent);
    }

    private String getSingleImageResultValue(BufferedImage buff_image, int threshold) {
        PunchValues punch_values = new PunchValues(buff_image);
        Vector pos_reg_vec = punch_values.getPosRegion(threshold);
        int pos_area = punch_values.getPosArea(pos_reg_vec);
        int punch_area = punch_values.getPunchArea();
        double pos_area_percent = 0.0;
        pos_area_percent = punch_area != 0 ? (double)pos_area * 100.0 / (double)punch_area : -1.0;
        DecimalFormat df = new DecimalFormat("#.###");
        df.applyPattern("#.###");
        df.getDecimalFormatSymbols().setDecimalSeparator('.');
        String strPos_area_percent = df.format(pos_area_percent);
        double mean_value = 0.0;
        if (pos_area != 0) {
            mean_value = punch_values.getMeanValueOfPosRegion(pos_reg_vec);
        }
        System.out.println("resultvalue" + strPos_area_percent);
        return strPos_area_percent;
    }

    public String getVersion() {
        return "1.3";
    }

    public Boolean isStartable() {
        return new Boolean(true);
    }

    public void setSessionContext(SessionContext sessionContext) {
    }

    public String start(ObjectMessage inputmsg) {
        return super.start(inputmsg);
    }
}

