/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.varia.deployment.BeanShellScript;
import org.jboss.varia.deployment.BeanShellSubDeployerMBean;

public class BeanShellSubDeployer
extends SubDeployerSupport
implements BeanShellSubDeployerMBean {
    public static final String BEANSHELL_EXTENSION = ".bsh";
    public static final String BASE_SCRIPT_OBJECT_NAME = "jboss.scripts:type=BeanShell";
    protected ServiceControllerMBean serviceController;
    static /* synthetic */ Class class$org$jboss$system$ServiceControllerMBean;

    public BeanShellSubDeployer() {
        this.setSuffixes(new String[]{"bsh"});
        this.setRelativeOrder(800);
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create((Class)(class$org$jboss$system$ServiceControllerMBean == null ? (class$org$jboss$system$ServiceControllerMBean = BeanShellSubDeployer.class$("org.jboss.system.ServiceControllerMBean")) : class$org$jboss$system$ServiceControllerMBean), (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        super.startService();
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
    }

    public boolean accepts(DeploymentInfo sdi) {
        String urlStr = sdi.url.toString();
        return urlStr.toLowerCase().endsWith(BEANSHELL_EXTENSION);
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        super.init(di);
        di.watch = di.url;
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("Deploying BeanShell script, create step: url " + di.url));
            String lURL = di.url.toString();
            int lIndex = lURL.lastIndexOf("/");
            di.shortName = lURL.substring(lIndex >= 0 ? lIndex + 1 : 0);
            BeanShellScript script = new BeanShellScript(di);
            ObjectName bshScriptName = script.getPreferedObjectName();
            ObjectName[] depends = script.getDependsServices();
            if (bshScriptName == null) {
                bshScriptName = ObjectNameConverter.convert((String)("jboss.scripts:type=BeanShell,url=" + di.url));
            }
            di.deployedObject = bshScriptName;
            try {
                this.server.unregisterMBean(bshScriptName);
            }
            catch (Exception e) {
                this.log.info((Object)e);
            }
            this.server.registerMBean((Object)script, bshScriptName);
            this.log.debug((Object)("Deploying: " + di.url));
            if (depends == null) {
                this.serviceController.create(bshScriptName);
            } else {
                this.serviceController.create(bshScriptName, Arrays.asList(depends));
            }
            super.create(di);
        }
        catch (Exception e) {
            this.destroy(di);
            throw new DeploymentException("create operation failed for script " + di.url, (Throwable)e);
        }
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("start script, deploymentInfo: " + di + ", short name: " + di.shortName + ", parent short name: " + (di.parent == null ? "no parent" : di.parent.shortName)));
            this.serviceController.start(di.deployedObject);
            this.log.debug((Object)("Deployed: " + di.url));
            super.start(di);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + di.url, (Throwable)e);
        }
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        try {
            this.serviceController.stop(di.deployedObject);
            super.stop(di);
        }
        catch (Exception e) {
            throw new DeploymentException("problem stopping ejb module: " + di.url, (Throwable)e);
        }
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        try {
            this.serviceController.destroy(di.deployedObject);
            this.serviceController.remove(di.deployedObject);
            super.destroy(di);
        }
        catch (Exception e) {
            throw new DeploymentException("problem destroying BSH Script: " + di.url, (Throwable)e);
        }
    }

    public URL createScriptDeployment(String bshScript, String scriptName) throws DeploymentException {
        URL scriptURL = null;
        try {
            File scriptFile = File.createTempFile(scriptName, BEANSHELL_EXTENSION);
            FileWriter fw = new FileWriter(scriptFile);
            fw.write(bshScript);
            fw.close();
            scriptURL = scriptFile.toURL();
            this.mainDeployer.deploy(scriptURL);
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to deploy: " + scriptName, (Throwable)e);
        }
        return scriptURL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

