/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.expression.AndExpression;
import net.sf.hibernate.expression.BetweenExpression;
import net.sf.hibernate.expression.Conjunction;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Disjunction;
import net.sf.hibernate.expression.EqExpression;
import net.sf.hibernate.expression.EqPropertyExpression;
import net.sf.hibernate.expression.GeExpression;
import net.sf.hibernate.expression.GtExpression;
import net.sf.hibernate.expression.IlikeExpression;
import net.sf.hibernate.expression.InExpression;
import net.sf.hibernate.expression.LeExpression;
import net.sf.hibernate.expression.LePropertyExpression;
import net.sf.hibernate.expression.LikeExpression;
import net.sf.hibernate.expression.LtExpression;
import net.sf.hibernate.expression.LtPropertyExpression;
import net.sf.hibernate.expression.MatchMode;
import net.sf.hibernate.expression.NotExpression;
import net.sf.hibernate.expression.NotNullExpression;
import net.sf.hibernate.expression.NullExpression;
import net.sf.hibernate.expression.OrExpression;
import net.sf.hibernate.expression.SQLCriterion;
import net.sf.hibernate.expression.SimpleExpression;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;

public final class Expression {
    private Expression() {
    }

    public static SimpleExpression eq(String propertyName, Object value) {
        return new EqExpression(propertyName, value);
    }

    public static SimpleExpression like(String propertyName, Object value) {
        return new LikeExpression(propertyName, value);
    }

    public static SimpleExpression like(String propertyName, String value, MatchMode matchMode) {
        return new LikeExpression(propertyName, value, matchMode);
    }

    public static Criterion ilike(String propertyName, String value, MatchMode matchMode) {
        return new IlikeExpression(propertyName, value, matchMode);
    }

    public static Criterion ilike(String propertyName, Object value) {
        return new IlikeExpression(propertyName, value);
    }

    public static SimpleExpression gt(String propertyName, Object value) {
        return new GtExpression(propertyName, value);
    }

    public static SimpleExpression lt(String propertyName, Object value) {
        return new LtExpression(propertyName, value);
    }

    public static SimpleExpression le(String propertyName, Object value) {
        return new LeExpression(propertyName, value);
    }

    public static SimpleExpression ge(String propertyName, Object value) {
        return new GeExpression(propertyName, value);
    }

    public static Criterion between(String propertyName, Object lo, Object hi) {
        return new BetweenExpression(propertyName, lo, hi);
    }

    public static Criterion in(String propertyName, Object[] values) {
        return new InExpression(propertyName, values);
    }

    public static Criterion in(String propertyName, Collection values) {
        return new InExpression(propertyName, values.toArray());
    }

    public static Criterion isNull(String propertyName) {
        return new NullExpression(propertyName);
    }

    public static Criterion eqProperty(String propertyName, String otherPropertyName) {
        return new EqPropertyExpression(propertyName, otherPropertyName);
    }

    public static Criterion ltProperty(String propertyName, String otherPropertyName) {
        return new LtPropertyExpression(propertyName, otherPropertyName);
    }

    public static Criterion leProperty(String propertyName, String otherPropertyName) {
        return new LePropertyExpression(propertyName, otherPropertyName);
    }

    public static Criterion isNotNull(String propertyName) {
        return new NotNullExpression(propertyName);
    }

    public static Criterion and(Criterion lhs, Criterion rhs) {
        return new AndExpression(lhs, rhs);
    }

    public static Criterion or(Criterion lhs, Criterion rhs) {
        return new OrExpression(lhs, rhs);
    }

    public static Criterion not(Criterion expression) {
        return new NotExpression(expression);
    }

    public static Criterion sql(String sql, Object[] values, Type[] types) {
        return new SQLCriterion(sql, values, types);
    }

    public static Criterion sql(String sql, Object value, Type type) {
        return new SQLCriterion(sql, new Object[]{value}, new Type[]{type});
    }

    public static Criterion sql(String sql) {
        return new SQLCriterion(sql, ArrayHelper.EMPTY_OBJECT_ARRAY, ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public static Conjunction conjunction() {
        return new Conjunction();
    }

    public static Disjunction disjunction() {
        return new Disjunction();
    }

    public static Criterion allEq(Map propertyNameValues) {
        Conjunction conj = Expression.conjunction();
        Iterator iter = propertyNameValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            conj.add(Expression.eq((String)me.getKey(), me.getValue()));
        }
        return conj;
    }
}

