/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.ToOne;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.ForeignKeyDirection;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ReflectHelper;

public class OneToOne
extends ToOne {
    private boolean constrained;
    private ForeignKeyDirection foreignKeyType;
    private SimpleValue identifier;

    public OneToOne(Table table, SimpleValue identifier) throws MappingException {
        super(table);
        this.identifier = identifier;
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
        try {
            if (this.getType() == null) {
                this.setType(TypeFactory.oneToOne(ReflectHelper.reflectedPropertyClass(propertyClass, propertyName), this.foreignKeyType, this.referencedPropertyName));
            }
        }
        catch (HibernateException he) {
            throw new MappingException("Problem trying to set association type by reflection", he);
        }
    }

    public void createForeignKey() {
        if (this.constrained && this.referencedPropertyName == null) {
            this.createForeignKeyOfClass(((EntityType)this.getType()).getAssociatedClass());
        }
    }

    public List getConstraintColumns() {
        ArrayList list = new ArrayList();
        Iterator iter = this.identifier.getColumnIterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public ForeignKeyDirection getForeignKeyType() {
        return this.foreignKeyType;
    }

    public Value getIdentifier() {
        return this.identifier;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setForeignKeyType(ForeignKeyDirection foreignKeyType) {
        this.foreignKeyType = foreignKeyType;
    }

    public void setIdentifier(SimpleValue identifier) {
        this.identifier = identifier;
    }

    public boolean isNullable() {
        return !this.constrained;
    }
}

