/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.RGcalibration;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class Overlap {
    protected BufferedImage buff_image_cy3_;
    protected BufferedImage buff_image_cy5_;

    public Overlap(BufferedImage buff_image_cy3, BufferedImage buff_image_cy5) throws IllegalArgumentException {
        if (buff_image_cy3 == null || buff_image_cy5 == null) {
            throw new IllegalArgumentException("Overlap: images null");
        }
        this.buff_image_cy3_ = buff_image_cy3;
        this.buff_image_cy5_ = buff_image_cy5;
    }

    public int getOverlap(int cy3_threshold, int cy5_threshold) throws IllegalArgumentException {
        Raster cy3_raster = this.buff_image_cy3_.getData();
        Raster cy5_raster = this.buff_image_cy5_.getData();
        int overlap = 0;
        if (cy3_raster.getWidth() == cy5_raster.getWidth() && cy3_raster.getHeight() == cy5_raster.getHeight()) {
            int x_count = 0;
            while (x_count < cy3_raster.getWidth()) {
                int y_count = 0;
                while (y_count < cy3_raster.getHeight()) {
                    if (cy3_raster.getSample(x_count, y_count, 0) >= cy3_threshold && this.isInNeighbourhood(cy3_raster, x_count, y_count, cy3_threshold) && cy5_raster.getSample(x_count, y_count, 0) >= cy5_threshold && this.isInNeighbourhood(cy3_raster, x_count, y_count, cy5_threshold)) {
                        ++overlap;
                    }
                    ++y_count;
                }
                ++x_count;
            }
            return overlap;
        }
        throw new IllegalArgumentException("Overlap: getOverlap - images not comparable");
    }

    public double getOverlapPercentBasedOnPosRegions(int cy3_threshold, int cy5_threshold) throws IllegalArgumentException, ArithmeticException {
        Raster cy3_raster = this.buff_image_cy3_.getData();
        Raster cy5_raster = this.buff_image_cy5_.getData();
        double overlap_percent = 0.0;
        int overlap = 0;
        int pos_count = 0;
        if (cy3_raster.getWidth() == cy5_raster.getWidth() && cy3_raster.getHeight() == cy5_raster.getHeight()) {
            int x_count = 0;
            while (x_count < cy3_raster.getWidth()) {
                int y_count = 0;
                while (y_count < cy3_raster.getHeight()) {
                    if (cy3_raster.getSample(x_count, y_count, 0) >= cy3_threshold && this.isInNeighbourhood(cy3_raster, x_count, y_count, cy3_threshold)) {
                        ++pos_count;
                    }
                    if (cy5_raster.getSample(x_count, y_count, 0) >= cy5_threshold && this.isInNeighbourhood(cy5_raster, x_count, y_count, cy5_threshold)) {
                        ++pos_count;
                    }
                    if (cy3_raster.getSample(x_count, y_count, 0) >= cy3_threshold && this.isInNeighbourhood(cy3_raster, x_count, y_count, cy3_threshold) && cy5_raster.getSample(x_count, y_count, 0) >= cy5_threshold && this.isInNeighbourhood(cy5_raster, x_count, y_count, cy5_threshold)) {
                        ++overlap;
                    }
                    ++y_count;
                }
                ++x_count;
            }
            double union = (double)pos_count - (double)overlap;
            if (union > 0.0) {
                overlap_percent = (double)overlap * 100.0 / union;
                return overlap_percent;
            }
            throw new ArithmeticException("Division by zero!");
        }
        throw new IllegalArgumentException("Overlap: getOverlap - images not comparable");
    }

    private boolean isInNeighbourhood(Raster raster, int x_count, int y_count, int threshold) {
        boolean has_neighbours = false;
        int count = 0;
        int h_count = -1;
        while (h_count <= 1) {
            int v_count = -1;
            while (v_count <= 1) {
                try {
                    int sample = raster.getSample(x_count + h_count, y_count + v_count, 0);
                    if (sample >= threshold) {
                        ++count;
                    }
                }
                catch (IndexOutOfBoundsException bounds_exc) {
                    ++count;
                }
                ++v_count;
            }
            ++h_count;
        }
        if (count >= 9) {
            has_neighbours = true;
        }
        return has_neighbours;
    }
}

