/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.RGcalibration;

import at.tugraz.genome.tma.RGcalibration.ThresholdCalculator;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.Iterator;
import java.util.Vector;

public class PunchValues {
    public static final int NEIGHBOURHOOD_CONSTANT = 9;
    protected BufferedImage image_;

    public PunchValues(BufferedImage image) throws IllegalArgumentException {
        if (image == null) {
            throw new IllegalArgumentException("PunchValues: images null");
        }
        this.image_ = image;
    }

    public double getMeanValueOfPosRegion(Vector pos_region_vec) {
        double mean_value;
        block4: {
            mean_value = 0.0;
            try {
                Iterator iter = pos_region_vec.iterator();
                int sum = 0;
                while (iter.hasNext()) {
                    Integer int_ob = (Integer)iter.next();
                    sum += int_ob.intValue();
                }
                if (pos_region_vec.size() != 0) {
                    mean_value = sum / pos_region_vec.size();
                    break block4;
                }
                mean_value = -1.0;
            }
            catch (NullPointerException null_exc) {
                null_exc.printStackTrace();
            }
        }
        return mean_value;
    }

    public int getPosArea(Vector pos_region_vec) {
        return pos_region_vec.size();
    }

    public Vector getPosRegion(int threshold) {
        Raster raster = this.image_.getData();
        Vector<Integer> pos_region_vec = new Vector<Integer>();
        int x_count = 0;
        while (x_count < raster.getWidth()) {
            int y_count = 0;
            while (y_count < raster.getHeight()) {
                int sample = raster.getSample(x_count, y_count, 0);
                if (sample >= threshold && this.isInNeighbourhood(raster, x_count, y_count, threshold)) {
                    pos_region_vec.add(new Integer(sample));
                }
                ++y_count;
            }
            ++x_count;
        }
        return pos_region_vec;
    }

    public int getPunchArea() {
        Raster raster = this.image_.getData();
        int num_pixel = 0;
        int threshold = this.getPunchThreshold();
        int x_count = 0;
        while (x_count < raster.getWidth()) {
            int y_count = 0;
            while (y_count < raster.getHeight()) {
                int sample = raster.getSample(x_count, y_count, 0);
                if (sample >= threshold) {
                    ++num_pixel;
                }
                ++y_count;
            }
            ++x_count;
        }
        return num_pixel;
    }

    private int getPunchThreshold() {
        int threshold = -1;
        ThresholdCalculator threshold_calc = new ThresholdCalculator(this.image_);
        threshold = threshold_calc.getThreshold();
        return threshold;
    }

    private boolean isInNeighbourhood(Raster raster, int x_count, int y_count, int threshold) {
        boolean has_neighbours = false;
        int count = 0;
        int h_count = -1;
        while (h_count <= 1) {
            int v_count = -1;
            while (v_count <= 1) {
                try {
                    int sample = raster.getSample(x_count + h_count, y_count + v_count, 0);
                    if (sample >= threshold) {
                        ++count;
                    }
                }
                catch (IndexOutOfBoundsException bounds_exc) {
                    ++count;
                }
                ++v_count;
            }
            ++h_count;
        }
        if (count >= 9) {
            has_neighbours = true;
        }
        return has_neighbours;
    }
}

