/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.RGcalibration;

import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class ThresholdCalculator {
    protected BufferedImage buff_image_;

    public ThresholdCalculator(BufferedImage image) throws IllegalArgumentException {
        if (image == null) {
            throw new IllegalArgumentException("ThresholdCalculator: image null");
        }
        this.buff_image_ = image;
    }

    private Histogram createHistogram(BufferedImage buff_image) {
        int[] bins = new int[]{65535};
        double[] low = new double[]{0.0};
        double[] high = new double[]{65535.0};
        Histogram hist = new Histogram(bins, low, high);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(buff_image);
        pb.add(null);
        pb.add(1);
        pb.add(1);
        pb.add(bins);
        pb.add(low);
        pb.add(high);
        RenderedOp dst = JAI.create((String)"histogram", (ParameterBlock)pb, null);
        hist = (Histogram)dst.getProperty("histogram");
        return hist;
    }

    private int[] getItensityValues(int[] bins) throws IllegalArgumentException {
        if (bins == null) {
            throw new IllegalArgumentException("TMAHistogram: bins null");
        }
        int[] itensity_values = new int[bins.length];
        int count = 0;
        while (count < bins.length) {
            itensity_values[count] = count;
            ++count;
        }
        return itensity_values;
    }

    public int getMeanValueOfItensity(int[] bins, int[] intensity_values) throws IllegalArgumentException {
        int sum_intensity = 0;
        int total_num_pixel = 0;
        if (bins == null || intensity_values == null) {
            throw new IllegalArgumentException("TMAHistogram: either bins or intensity_values null");
        }
        int count = 0;
        while (count < bins.length) {
            sum_intensity += intensity_values[count] * bins[count];
            total_num_pixel += bins[count];
            ++count;
        }
        if (total_num_pixel != 0) {
            int mean_value = sum_intensity / total_num_pixel;
            return mean_value;
        }
        return -1;
    }

    public int getThreshold() {
        Histogram hist = this.createHistogram(this.buff_image_);
        int minimum = 1000000000;
        int threshold = -1;
        int[] bins = hist.getBins(0);
        try {
            int count = 0;
            while (count <= hist.getNumBins(0) * 2 / 15) {
                if (hist.getBinSize(0, count) <= minimum) {
                    minimum = hist.getBinSize(0, count);
                    threshold = count;
                }
                ++count;
            }
            if (threshold == hist.getNumBins(0) * 2 / 15) {
                threshold = 1000;
            }
        }
        catch (IllegalArgumentException exc) {
            exc.printStackTrace();
            System.out.println("caught IllegalArgumentException in ThresholdCalculator::getThreshold:");
            System.out.println("ThresholdCalculator: bins null");
        }
        return threshold;
    }
}

