/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.webservice.deployment.ServiceDescription;
import org.jboss.webservice.metadata.PortComponentMetaData;

public class PortComponentInfo {
    private DeploymentInfo di;
    private PortComponentMetaData pcMetaData;
    private ServiceDescription serviceDesc;
    private String serviceID;
    private ObjectName objectName;

    public PortComponentInfo(DeploymentInfo di, PortComponentMetaData pcMetaData) {
        this.di = di;
        this.pcMetaData = pcMetaData;
        this.serviceID = di.getCanonicalName() + "#" + pcMetaData.getPortComponentName();
        try {
            this.objectName = ObjectName.getInstance("jboss.ws4ee:port-component=" + this.serviceID);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid serviceID: " + this.serviceID);
        }
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.di;
    }

    public PortComponentMetaData getPortComponentMetaData() {
        return this.pcMetaData;
    }

    public String getServiceEndpointURL() {
        return this.pcMetaData.getServiceEndpointURL().toExternalForm();
    }

    public void setServiceDesc(ServiceDescription serviceDesc) {
        this.serviceDesc = serviceDesc;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDesc;
    }

    public String toString() {
        return "[id=" + this.serviceID + ",address=" + this.pcMetaData.getServiceEndpointURL() + "]";
    }
}

