/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.handler;

import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.providers.java.RPCInvocation;
import org.jboss.logging.Logger;
import org.jboss.webservice.handler.HandlerChainBaseImpl;

public class ServerHandlerChain
extends HandlerChainBaseImpl {
    private static Logger log = Logger.getLogger((Class)ServerHandlerChain.class);

    public ServerHandlerChain(List infos, Set roles) {
        super(infos, roles);
    }

    public boolean handleRequest(MessageContext msgContext) {
        RPCInvocation invBefore = (RPCInvocation)msgContext.getProperty("axis.provider.java.rpc-invocation");
        if (invBefore == null) {
            throw new IllegalStateException("Cannot obtain RPCInvocation from message context");
        }
        String xmlBefore = invBefore.getRequestEnvelope().getAsStringFromInternal();
        if (log.isTraceEnabled()) {
            log.trace((Object)("RequestEnvelope before request handlers: " + xmlBefore));
        }
        boolean doNext = super.handleRequest(msgContext);
        this.checkMustUnderstand(msgContext);
        RPCInvocation invAfter = new RPCInvocation(invBefore);
        invAfter.prepareFromRequestEnvelope();
        String xmlAfter = invAfter.getRequestEnvelope().getAsStringFromInternal();
        if (!xmlBefore.equals(xmlAfter)) {
            if (log.isTraceEnabled()) {
                log.debug((Object)("RequestEnvelope after request handlers: " + xmlAfter));
            }
            msgContext.setProperty("axis.provider.java.rpc-invocation", (Object)invAfter);
        }
        return doNext;
    }

    public boolean handleResponse(MessageContext msgContext) {
        boolean status = super.handleResponse(msgContext);
        this.checkMustUnderstand(msgContext);
        return status;
    }
}

