/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.management.Notification;
import org.jboss.jmx.adaptor.snmp.agent.Clock;
import org.jboss.jmx.adaptor.snmp.agent.Counter;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.jmx.adaptor.snmp.agent.NotificationWrapper;
import org.jboss.jmx.adaptor.snmp.agent.SnmpVarBindFactory;
import org.jboss.jmx.adaptor.snmp.agent.TrapFactory;
import org.jboss.jmx.adaptor.snmp.config.notification.Mapping;
import org.jboss.jmx.adaptor.snmp.config.notification.NotificationMapList;
import org.jboss.jmx.adaptor.snmp.config.notification.VarBind;
import org.jboss.jmx.adaptor.snmp.config.notification.VarBindList;
import org.jboss.logging.Logger;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;

public class TrapFactorySupport
implements TrapFactory {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$jmx$adaptor$snmp$agent$TrapFactorySupport == null ? (class$org$jboss$jmx$adaptor$snmp$agent$TrapFactorySupport = TrapFactorySupport.class$("org.jboss.jmx.adaptor.snmp.agent.TrapFactorySupport")) : class$org$jboss$jmx$adaptor$snmp$agent$TrapFactorySupport));
    private SnmpVarBindFactory snmpVBFactory = new SnmpVarBindFactory();
    private String notificationMapResName = null;
    private Clock clock = null;
    private Counter trapCount = null;
    private NotificationMapList notificationMapList = null;
    private ArrayList mappingRegExpCache = null;
    private ArrayList notificationWrapperCache = null;
    static /* synthetic */ Class class$org$jboss$jmx$adaptor$snmp$agent$TrapFactorySupport;

    public void set(String notificationMapResName, Clock clock, Counter count) {
        this.notificationMapResName = notificationMapResName;
        this.clock = clock;
        this.trapCount = count;
    }

    public void start() throws Exception {
        log.debug((Object)("Reading resource: \"" + this.notificationMapResName + "\""));
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(this.getClass().getResourceAsStream(this.notificationMapResName));
        }
        catch (Exception e) {
            log.error((Object)("Accessing resource \"" + this.notificationMapResName + "\""), (Throwable)e);
            throw e;
        }
        try {
            this.notificationMapList = NotificationMapList.unmarshal(in);
        }
        catch (Exception e) {
            log.error((Object)("Reading resource \"" + this.notificationMapResName + "\""), (Throwable)e);
            throw e;
        }
        log.debug((Object)("\"" + this.notificationMapResName + "\" " + (this.notificationMapList.isValid() ? "valid" : "invalid") + ". Read " + this.notificationMapList.getMappingCount() + " mappings"));
        log.debug((Object)("Executing resource: \"" + this.notificationMapResName + "\""));
        this.mappingRegExpCache = new ArrayList(this.notificationMapList.getMappingCount());
        this.notificationWrapperCache = new ArrayList(this.notificationMapList.getMappingCount());
        for (int i = 0; i < this.notificationMapList.getMappingCount(); ++i) {
            String notificationType = this.notificationMapList.getMapping(i).getNotificationType();
            try {
                this.mappingRegExpCache.add(new RE((Object)notificationType));
            }
            catch (REException e) {
                this.mappingRegExpCache.add(null);
                log.warn((Object)("Error compiling notification map directive #" + i + " notification type\"" + notificationType + "\""), (Throwable)e);
            }
            String wrapperClassName = this.notificationMapList.getMapping(i).getVarBindList().getWrapperClass();
            log.debug((Object)("notification wrapper class: " + wrapperClassName));
            try {
                NotificationWrapper wrapper = (NotificationWrapper)Class.forName(wrapperClassName, true, this.getClass().getClassLoader()).newInstance();
                wrapper.set(this.clock, this.trapCount);
                this.notificationWrapperCache.add(wrapper);
                continue;
            }
            catch (Exception e) {
                this.notificationWrapperCache.add(null);
                log.warn((Object)("Error compiling notification map directive #" + i), (Throwable)e);
            }
        }
        log.debug((Object)"Trap factory going active");
    }

    private int findMappingIndex(Notification n) throws IndexOutOfBoundsException {
        for (int i = 0; i < this.notificationMapList.getMappingCount(); ++i) {
            RE p = (RE)this.mappingRegExpCache.get(i);
            if (p == null || !p.isMatch((Object)n.getType())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Match for \"" + n.getType() + "\" on mapping " + i));
            }
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public SnmpPduTrap generateV1Trap(Notification n) throws MappingFailedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"generateV1Trap");
        }
        int index = -1;
        try {
            index = this.findMappingIndex(n);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MappingFailedException("No mapping found for notification type: \"" + n.getType() + "\"");
        }
        Mapping m = this.notificationMapList.getMapping(index);
        SnmpPduTrap trapPdu = new SnmpPduTrap();
        trapPdu.setTimeStamp(this.clock.uptime());
        trapPdu.setGeneric(m.getGeneric());
        trapPdu.setSpecific(m.getSpecific());
        trapPdu.setEnterprise(m.getEnterprise());
        NotificationWrapper wrapper = (NotificationWrapper)this.notificationWrapperCache.get(index);
        if (wrapper != null) {
            wrapper.prime(n);
            VarBindList vbList = m.getVarBindList();
            for (int i = 0; i < vbList.getVarBindCount(); ++i) {
                VarBind vb = vbList.getVarBind(i);
                trapPdu.addVarBind(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
            }
        } else {
            throw new MappingFailedException("Varbind mapping failure: null wrapper defined for  notification type \"" + m.getNotificationType() + "\"");
        }
        return trapPdu;
    }

    public SnmpPduPacket generateV2Trap(Notification n) throws MappingFailedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"generateV2Trap");
        }
        int index = -1;
        try {
            index = this.findMappingIndex(n);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MappingFailedException("No mapping found for notification type: \"" + n.getType() + "\"");
        }
        Mapping m = this.notificationMapList.getMapping(index);
        SnmpPduRequest trapPdu = new SnmpPduRequest(167);
        NotificationWrapper wrapper = (NotificationWrapper)this.notificationWrapperCache.get(index);
        if (wrapper != null) {
            wrapper.prime(n);
            VarBindList vbList = m.getVarBindList();
            for (int i = 0; i < vbList.getVarBindCount(); ++i) {
                VarBind vb = vbList.getVarBind(i);
                trapPdu.addVarBind(this.snmpVBFactory.make(vb.getOid(), wrapper.get(vb.getTag())));
            }
        } else {
            log.warn((Object)("Varbind mapping failure: null wrapper defined for  notification type \"" + m.getNotificationType() + "\""));
        }
        return trapPdu;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

