/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;

public class AuthorizationInterceptor
extends AbstractInterceptor {
    private String azclassname = null;
    private RealmMapping realm;
    static /* synthetic */ Class class$java$security$Principal;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$String;

    public void setSecurityDomain(String securityDomain) {
        try {
            InitialContext ctx = new InitialContext();
            this.realm = (RealmMapping)ctx.lookup(securityDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAuthorizingClass(String az) {
        System.out.println("Authorizing Class=" + az);
        this.azclassname = az;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        String opName;
        String type = invocation.getType();
        if (type == "invoke" && (opName = invocation.getName()).equals("invoke")) {
            Object[] args = invocation.getArgs();
            org.jboss.invocation.Invocation inv = (org.jboss.invocation.Invocation)args[0];
            Principal caller = inv.getPrincipal();
            if (inv == null) {
                System.out.println("Invocation is null");
            }
            Object[] obj = inv.getArguments();
            ObjectName objname = (ObjectName)obj[0];
            String opname = (String)obj[1];
            boolean auth = false;
            try {
                auth = this.checkAuthorization(caller, objname.getCanonicalName(), opname);
            }
            catch (Exception e) {
                e.printStackTrace();
                auth = false;
            }
            if (!auth) {
                String msg = "Failed to authorize principal=" + caller + ",MBean=" + objname + ", Operation=" + opname;
                SecurityException ex = new SecurityException(msg);
                throw ex;
            }
        }
        AbstractInterceptor i = invocation.nextInterceptor();
        return i.invoke(invocation);
    }

    private boolean checkAuthorization(Principal caller, String objname, String opname) throws Exception {
        if (this.realm == null) {
            throw new SecurityException("Security Domain not defined for Authorization Interceptor");
        }
        Set roles = this.realm.getUserRoles(caller);
        boolean hasRole = this.realm.doesUserHaveRole(caller, roles);
        if (!hasRole) {
            throw new SecurityException("Caller not defined in the roles");
        }
        ArrayList<String> rolenames = new ArrayList<String>();
        Iterator iter = null;
        if (roles != null && !roles.isEmpty()) {
            iter = roles.iterator();
        }
        while (iter.hasNext()) {
            SimplePrincipal rolename = (SimplePrincipal)iter.next();
            rolenames.add(rolename.getName());
        }
        Class<?> cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader().loadClass(this.azclassname);
        }
        catch (Exception e) {
            String msg = "Define your own class which has a method authorize with signature";
            msg = msg + "public Boolean authorize( Principal caller, Collection roles,String objectname,String opname)";
            msg = msg + ". And replace " + this.azclassname + " its name";
            throw new Exception(msg);
        }
        Object obj = cl.newInstance();
        Method method = cl.getMethod("authorize", class$java$security$Principal == null ? (class$java$security$Principal = AuthorizationInterceptor.class$("java.security.Principal")) : class$java$security$Principal, class$java$util$Collection == null ? (class$java$util$Collection = AuthorizationInterceptor.class$("java.util.Collection")) : class$java$util$Collection, class$java$lang$String == null ? (class$java$lang$String = AuthorizationInterceptor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = AuthorizationInterceptor.class$("java.lang.String")) : class$java$lang$String);
        Boolean valid = (Boolean)method.invoke(obj, caller, rolenames, objname, opname);
        return valid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

