/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.ServiceDeployer;
import org.jboss.webservice.ServiceDeployerEJBMBean;
import org.jboss.webservice.metadata.PortComponentMetaData;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.metadata.WebservicesMetaData;
import org.jboss.webservice.server.ServiceEndpointServletEJB;

public class ServiceDeployerEJB
extends ServiceDeployer
implements ServiceDeployerEJBMBean {
    private final Logger log = Logger.getLogger((Class)ServiceDeployer.class);
    public static final String EJB_ENDPOINT_WEBAPP_URL = "ejb-endpoint-webapp-url";
    private ObjectName ejbDeployer;
    private ObjectName mainDeployer;

    public void setEJBDeployer(ObjectName deployerName) {
        this.ejbDeployer = deployerName;
    }

    public void setMainDeployer(ObjectName deployerName) {
        this.mainDeployer = deployerName;
    }

    protected void startService() throws Exception {
        super.startService();
        this.registerNotificationListener(this.ejbDeployer);
    }

    protected void stopService() {
        this.unregisterNotificationListener(this.ejbDeployer);
        super.stopService();
    }

    protected void deployWebservices(DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        super.deployWebservices(di, webservices);
        Document webDoc = this.createWebXML(di, webservices);
        Document jbossDoc = this.createJBossWebXML(di);
        ServerConfig config = ServerConfigLocator.locate();
        File tmpWar = null;
        try {
            File tmpdir = new File(config.getServerTempDir().getCanonicalPath() + "/deploy");
            String deploymentName = di.getCanonicalName().replace('/', '-') + "-ws";
            tmpWar = File.createTempFile(deploymentName, ".war", tmpdir);
            tmpWar.delete();
            File webInf = new File(tmpWar, "WEB-INF");
            webInf.mkdirs();
            File webXml = new File(webInf, "web.xml");
            FileWriter fw = new FileWriter(webXml);
            OutputFormat fmt = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)fw, fmt);
            writer.write(webDoc);
            writer.close();
            fw.close();
            File jbossWebXml = new File(webInf, "jboss-web.xml");
            fw = new FileWriter(jbossWebXml);
            writer = new XMLWriter((Writer)fw, fmt);
            writer.write(jbossDoc);
            writer.close();
            fw.close();
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to create webservice.war", (Throwable)e);
        }
        try {
            URL warURL = tmpWar.toURL();
            Object[] args = new Object[]{warURL};
            String[] sig = new String[]{"java.net.URL"};
            this.server.invoke(this.mainDeployer, "deploy", args, sig);
            di.context.put(EJB_ENDPOINT_WEBAPP_URL, warURL);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to deploy webservice.war", (Throwable)e);
        }
    }

    private Document createWebXML(DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
        DocumentFactory factory = DocumentFactory.getInstance();
        Document webDoc = factory.createDocument();
        Element webApp = webDoc.addElement("web-app");
        WebserviceDescriptionMetaData[] wsDescriptions = webservices.getWebserviceDescriptions();
        for (int i = 0; i < wsDescriptions.length; ++i) {
            WebserviceDescriptionMetaData wsDescription = wsDescriptions[i];
            PortComponentMetaData[] portComponents = wsDescription.getPortComponents();
            for (int j = 0; j < portComponents.length; ++j) {
                PortComponentMetaData pc = portComponents[j];
                String ejbLink = pc.getEjbLink();
                if (ejbLink == null) {
                    throw new DeploymentException("Cannot find ejb-link in port-component: " + pc.getPortComponentName());
                }
                Element servlet = webApp.addElement("servlet");
                Element servletName = servlet.addElement("servlet-name");
                servletName.addText(ejbLink);
                Element servletClass = servlet.addElement("servlet-class");
                servletClass.addText((class$org$jboss$webservice$server$ServiceEndpointServletEJB == null ? ServiceDeployerEJB.class$("org.jboss.webservice.server.ServiceEndpointServletEJB") : class$org$jboss$webservice$server$ServiceEndpointServletEJB).getName());
            }
        }
        ArrayList<String> urlPatters = new ArrayList<String>();
        for (int i = 0; i < wsDescriptions.length; ++i) {
            WebserviceDescriptionMetaData wsDescription = wsDescriptions[i];
            PortComponentMetaData[] portComponents = wsDescription.getPortComponents();
            for (int j = 0; j < portComponents.length; ++j) {
                PortComponentMetaData pc = portComponents[j];
                String ejbLink = pc.getEjbLink();
                Element servletMapping = webApp.addElement("servlet-mapping");
                Element servletName = servletMapping.addElement("servlet-name");
                servletName.addText(ejbLink);
                Element urlPatternElement = servletMapping.addElement("url-pattern");
                String urlPattern = "/*";
                BeanMetaData ejbMetaData = applMetaData.getBeanByEjbName(ejbLink);
                EjbPortComponentMetaData pcMetaData = ejbMetaData.getPortComponent();
                if (pcMetaData != null) {
                    urlPattern = pcMetaData.getURLPattern();
                }
                if (urlPatters.contains(urlPattern)) {
                    throw new IllegalArgumentException("Cannot use the same url-pattern with different endpoints, check your <port-component-uri> in jboss.xml");
                }
                urlPatternElement.addText(urlPattern);
                urlPatters.add(urlPattern);
            }
        }
        String authMethod = null;
        for (int i = 0; i < wsDescriptions.length; ++i) {
            WebserviceDescriptionMetaData wdmd = wsDescriptions[i];
            PortComponentMetaData[] ports = wdmd.getPortComponents();
            for (int j = 0; j < ports.length; ++j) {
                PortComponentMetaData port = ports[j];
                String portName = port.getPortComponentName();
                String ejbLink = port.getEjbLink();
                BeanMetaData smd = applMetaData.getBeanByEjbName(ejbLink);
                EjbPortComponentMetaData portMetaData = smd.getPortComponent();
                if (portMetaData == null) continue;
                Element securityConstraint = webApp.addElement("security-constraint");
                Element wrc = securityConstraint.addElement("web-resource-collection");
                Element wrName = wrc.addElement("web-resource-name");
                wrName.addText(portName);
                Element pattern = wrc.addElement("url-pattern");
                String uri = portMetaData.getURLPattern();
                pattern.addText(uri);
                if (portMetaData.getAuthMethod() != null) {
                    if (authMethod == null) {
                        authMethod = portMetaData.getAuthMethod();
                    }
                    Element authConstraint = securityConstraint.addElement("auth-constraint");
                    Element roleName = authConstraint.addElement("role-name");
                    roleName.addText("*");
                }
                if (portMetaData.getTransportGuarantee() == null) continue;
                Element userData = securityConstraint.addElement("user-data-constraint");
                Element transport = userData.addElement("transport-guarantee");
                transport.addText(portMetaData.getTransportGuarantee());
            }
        }
        if (authMethod != null) {
            Element loginConfig = webApp.addElement("login-config");
            Element method = loginConfig.addElement("auth-method");
            method.addText(authMethod);
            Element realm = loginConfig.addElement("realm-name");
            realm.addText("EJBServiceEndpointServlet Realm");
        }
        for (int i = 0; i < wsDescriptions.length; ++i) {
            WebserviceDescriptionMetaData wsDescription = wsDescriptions[i];
            PortComponentMetaData[] portComponents = wsDescription.getPortComponents();
            for (int j = 0; j < portComponents.length; ++j) {
                PortComponentMetaData pcMetaData = portComponents[j];
                String ejbLink = pcMetaData.getEjbLink();
                PortComponentInfo pcInfo = new PortComponentInfo(di, pcMetaData);
                this.modifyServletConfig(webDoc, ejbLink, pcInfo);
            }
        }
        return webDoc;
    }

    private Document createJBossWebXML(DeploymentInfo di) {
        ApplicationMetaData amd = (ApplicationMetaData)di.metaData;
        DocumentFactory factory = DocumentFactory.getInstance();
        Document jbossDoc = factory.createDocument();
        Element jbossWeb = jbossDoc.addElement("jboss-web");
        String securityDomain = amd.getSecurityDomain();
        if (securityDomain != null) {
            Element secDomain = jbossWeb.addElement("security-domain");
            secDomain.addText(securityDomain);
        }
        String contextRoot = (String)di.context.get("webservice-context-root");
        Element root = jbossWeb.addElement("context-root");
        root.addText(contextRoot);
        return jbossDoc;
    }

    protected void undeployWebservices(DeploymentInfo di, WebservicesMetaData webservices) {
        try {
            URL warURL = (URL)di.context.get(EJB_ENDPOINT_WEBAPP_URL);
            if (warURL != null) {
                Object[] args = new Object[]{warURL};
                String[] sig = new String[]{"java.net.URL"};
                this.server.invoke(this.mainDeployer, "undeploy", args, sig);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to undeploy webservice.war", (Throwable)e);
        }
        super.undeployWebservices(di, webservices);
    }

    protected URL getWebservicesDescriptor(DeploymentInfo di) {
        return di.localCl.findResource("META-INF/webservices.xml");
    }

    protected String getServiceEndpointServletName() {
        return ServiceEndpointServletEJB.class.getName();
    }
}

