/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.management.ObjectName;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.ServiceDeployer;
import org.jboss.webservice.ServiceDeployerJSEMBean;
import org.jboss.webservice.metadata.PortComponentMetaData;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.metadata.WebservicesMetaData;
import org.jboss.webservice.server.ServiceEndpointServletJSE;

public class ServiceDeployerJSE
extends ServiceDeployer
implements ServiceDeployerJSEMBean {
    private final Logger log = Logger.getLogger((Class)ServiceDeployer.class);
    private ObjectName warDeployer;

    public void setWARDeployer(ObjectName deployerName) {
        this.warDeployer = deployerName;
    }

    protected void startService() throws Exception {
        super.startService();
        this.registerNotificationListener(this.warDeployer);
    }

    protected void stopService() {
        this.unregisterNotificationListener(this.warDeployer);
        super.stopService();
    }

    protected URL getWebservicesDescriptor(DeploymentInfo di) {
        return di.localCl.findResource("WEB-INF/webservices.xml");
    }

    protected void createWebservice(DeploymentInfo di) throws DeploymentException {
        super.createWebservice(di);
        WebservicesMetaData webservices = (WebservicesMetaData)this.webservicesMap.get(di.url);
        this.modifyWebXML(di, webservices);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void modifyWebXML(DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        if (webservices == null) {
            throw new DeploymentException("webservices.xml not registerd");
        }
        File warFile = new File(di.localUrl.getFile());
        if (!warFile.isDirectory()) {
            throw new DeploymentException("Expected a war directory: " + di.localUrl);
        }
        File webXML = new File(di.localUrl.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new DeploymentException("Cannot find web.xml: " + webXML);
        }
        FileOutputStream fos = null;
        SAXReader reader = new SAXReader();
        Document doc = reader.read(webXML);
        this.modifyWebXMLDocument(doc, di, webservices);
        File orgWebXML = new File(webXML.getCanonicalPath() + ".org");
        orgWebXML.delete();
        if (!webXML.renameTo(orgWebXML)) {
            throw new DeploymentException("Cannot rename web.xml: " + orgWebXML);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        fos = new FileOutputStream(webXML);
        XMLWriter writer = new XMLWriter((OutputStream)fos, format);
        writer.write(doc);
        Object var12_13 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException e) {
            this.log.warn((Object)"Unexpected IOException on file close", (Throwable)e);
        }
        return;
        {
            catch (DeploymentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                this.log.warn((Object)"Unexpected IOException on file close", (Throwable)e);
            }
            throw throwable;
        }
    }

    private void modifyWebXMLDocument(Document doc, DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        WebserviceDescriptionMetaData[] wsDescriptions = webservices.getWebserviceDescriptions();
        for (int i = 0; i < wsDescriptions.length; ++i) {
            WebserviceDescriptionMetaData wsDescription = wsDescriptions[i];
            PortComponentMetaData[] portComponents = wsDescription.getPortComponents();
            for (int j = 0; j < portComponents.length; ++j) {
                PortComponentMetaData pcMetaData = portComponents[j];
                PortComponentInfo pcInfo = new PortComponentInfo(di, pcMetaData);
                String servletLink = pcMetaData.getServletLink();
                if (servletLink == null) {
                    throw new DeploymentException("Cannot find servlet-link in port-component: " + pcMetaData.getPortComponentName());
                }
                this.modifyServletConfig(doc, servletLink, pcInfo);
            }
        }
    }

    protected String getServiceEndpointServletName() {
        return ServiceEndpointServletJSE.class.getName();
    }
}

