/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.AttachmentPart;
import javax.xml.transform.Source;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.enum.Enum;
import org.jboss.logging.Logger;
import org.jboss.webservice.client.ServiceImpl;
import org.jboss.webservice.deployment.OperationDescription;
import org.jboss.webservice.deployment.ServiceDescription;

public class CallImpl
extends Call {
    private static final Logger log = Logger.getLogger((Class)CallImpl.class);
    private ServiceImpl jaxrpcService;
    private OperationDescription opDescription;
    private Map attachments = new HashMap();

    public CallImpl(ServiceImpl service) {
        super((Service)service);
        this.jaxrpcService = service;
    }

    public CallImpl(Object url) throws MalformedURLException {
        this(new ServiceImpl());
        this.setTargetEndpointAddress(new URL(url.toString()));
    }

    public void setOperation(String javaOpName) {
        super.setOperation(javaOpName);
        OperationDesc axisOp = this.getOperation();
        String wsdlOpName = this.getOperationName().getLocalPart();
        String portName = this.getPortName() != null ? this.getPortName().getLocalPart() : null;
        ServiceDescription serviceDesc = this.jaxrpcService.getServiceDescription(portName);
        Properties callProperties = serviceDesc.getCallProperties();
        if (callProperties != null) {
            Iterator<Object> keys = callProperties.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = callProperties.getProperty(key);
                this.setProperty(key, value);
            }
        }
        this.opDescription = null;
        Iterator itOp = serviceDesc.getOperations();
        while (this.opDescription == null && itOp.hasNext()) {
            OperationDescription operation = (OperationDescription)itOp.next();
            if (!operation.getWsdlName().equals(wsdlOpName)) continue;
            this.opDescription = operation;
        }
        if (this.opDescription != null) {
            if (!serviceDesc.getStyle().equals((Enum)axisOp.getStyle())) {
                log.debug((Object)("Fixing style: [was=" + axisOp.getStyle() + ",is=" + serviceDesc.getStyle() + "]"));
                axisOp.setStyle(serviceDesc.getStyle());
            }
            if (!serviceDesc.getUse().equals((Enum)axisOp.getUse())) {
                log.debug((Object)("Fixing use: [was=" + axisOp.getUse() + ",is=" + serviceDesc.getUse() + "]"));
                axisOp.setUse(serviceDesc.getUse());
            }
        } else {
            log.warn((Object)("Cannot find operation description for: " + wsdlOpName));
        }
    }

    protected String getWsdlOpName(String javaOpName) {
        String wsdlOpName = javaOpName;
        ServiceDescription serviceDesc = this.getServiceDescription();
        if (serviceDesc != null) {
            Iterator it = serviceDesc.getOperations();
            while (it.hasNext()) {
                OperationDescription operation = (OperationDescription)it.next();
                if (!javaOpName.equals(operation.getJavaName()) || wsdlOpName.equals(operation.getWsdlName())) continue;
                wsdlOpName = operation.getWsdlName();
                log.debug((Object)("Replacing operation name '" + javaOpName + "' with '" + wsdlOpName + "'"));
            }
        }
        return wsdlOpName;
    }

    private ServiceDescription getServiceDescription() {
        ServiceDescription serviceDesc = null;
        if (this.jaxrpcService != null) {
            String portName = this.getPortName() != null ? this.getPortName().getLocalPart() : null;
            serviceDesc = this.jaxrpcService.getServiceDescription(portName);
        }
        return serviceDesc;
    }

    public void addAttachment(String contentID, Object mimepart) {
        this.attachments.put(contentID, mimepart);
    }

    public Iterator getAttachmentIdentifiers() {
        return Collections.unmodifiableSet(this.attachments.keySet()).iterator();
    }

    public Object getAttachment(String contentID) {
        return this.attachments.get(contentID);
    }

    public void removeAttachment(String contentID) {
        this.attachments.remove(contentID);
    }

    protected void addAttachmentParts(Message msg) {
        Iterator it = this.getAttachmentIdentifiers();
        while (it.hasNext()) {
            String contentID = (String)it.next();
            Object part = this.getAttachment(contentID);
            AttachmentPart ap = null;
            if (part instanceof String) {
                ap = msg.createAttachmentPart(part, "text/plain");
            } else if (part instanceof Source) {
                ap = msg.createAttachmentPart(part, "application/xml");
            } else if (part instanceof URL) {
                URLDataSource ds = new URLDataSource((URL)part);
                ap = msg.createAttachmentPart(new DataHandler((DataSource)ds));
            } else if (part instanceof DataHandler) {
                ap = msg.createAttachmentPart((DataHandler)part);
            } else if (part instanceof MimeMultipart) {
                ap = msg.createAttachmentPart((Object)((MimeMultipart)part), "multipart/mixed");
            }
            if (ap == null) {
                throw new IllegalArgumentException("Unsupported attachment part: " + part);
            }
            ap.setContentId(contentID);
            this.attachmentParts.add(ap);
        }
        super.addAttachmentParts(msg);
        this.attachments.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] params) throws RemoteException {
        try {
            if (this.opDescription != null && this.opDescription.isOneWay()) {
                log.debug((Object)("Using one-way call semantics for: " + this.getOperationName()));
                super.invokeOneWay(params);
                Object var2_2 = null;
                return var2_2;
            }
            Object object = super.invoke(params);
            return object;
        }
        finally {
            this.msgContext = null;
            this.clearHeaders();
        }
    }
}

