/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.encoding.ser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.axis.description.AttributeDesc;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.deployment.BeanXMLMetaData;
import org.jboss.webservice.deployment.MetaDataRegistry;

public class MetaDataTypeDesc
extends TypeDesc {
    private final Logger log = Logger.getLogger((Class)MetaDataTypeDesc.class);

    public MetaDataTypeDesc(Class javaClass, QName xmlType, BeanXMLMetaData metaData) {
        super(javaClass);
        if (javaClass == null) {
            throw new IllegalArgumentException("javaClass cannot be null");
        }
        if (xmlType == null) {
            throw new IllegalArgumentException("xmlType cannot be null");
        }
        if (metaData == null) {
            metaData = this.getServerSideMetaData(xmlType);
        }
        try {
            if (metaData != null) {
                this.setXmlType(xmlType);
                this.setupElementDescriptions(metaData);
                this.setupElementOrder(metaData);
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Instanciation error", (Throwable)e);
            throw e;
        }
    }

    private BeanXMLMetaData getServerSideMetaData(QName xmlType) {
        BeanXMLMetaData metaData = null;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            ObjectName objectName = new ObjectName("jboss.ws4ee:service=AxisService");
            MetaDataRegistry registry = (MetaDataRegistry)server.getAttribute(objectName, "MetaDataRegistry");
            metaData = registry.getTypeMappingMetaData(xmlType);
        }
        catch (Exception e) {
            this.log.warn((Object)("Cannot obtain metaData from AxisService: " + e));
        }
        return metaData;
    }

    private void setupElementDescriptions(BeanXMLMetaData metaData) {
        Iterator itElDesc = metaData.getElementMetaData();
        while (itElDesc.hasNext()) {
            BeanXMLMetaData.ElementMetaData elMetaData = (BeanXMLMetaData.ElementMetaData)itElDesc.next();
            String fieldName = elMetaData.getFieldName();
            QName xmlName = elMetaData.getXmlName();
            QName xmlType = elMetaData.getXmlType();
            boolean asAttribute = elMetaData.isAsAttribute();
            boolean asContent = elMetaData.isAsContent();
            AttributeDesc fieldDesc = null;
            if (asAttribute) {
                fieldDesc = new AttributeDesc();
            } else {
                fieldDesc = new ElementDesc();
                ((ElementDesc)fieldDesc).setAsContent(asContent);
                ((ElementDesc)fieldDesc).setItemXmlType(elMetaData.getItemXmlType());
            }
            fieldDesc.setFieldName(fieldName);
            fieldDesc.setXmlName(xmlName);
            fieldDesc.setXmlType(xmlType);
            this.addFieldDesc((FieldDesc)fieldDesc);
        }
    }

    private void setupElementOrder(BeanXMLMetaData metaData) {
        Iterator itElementOrder = metaData.getElementOrder();
        if (itElementOrder.hasNext()) {
            Map bpdMap = this.getPropertyDescriptorMap();
            BeanPropertyDescriptor[] bpdArr = new BeanPropertyDescriptor[bpdMap.size()];
            int index = 0;
            if (bpdMap.size() > 0) {
                ArrayList keys = new ArrayList(bpdMap.keySet());
                BeanPropertyDescriptor bpd = (BeanPropertyDescriptor)bpdMap.get("class");
                if (bpd != null) {
                    bpdArr[index++] = bpd;
                    keys.remove("class");
                }
                while (itElementOrder.hasNext()) {
                    String fieldName = (String)itElementOrder.next();
                    bpd = (BeanPropertyDescriptor)bpdMap.get(fieldName);
                    if (bpd == null) continue;
                    bpdArr[index++] = bpd;
                    keys.remove(fieldName);
                }
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    bpd = (BeanPropertyDescriptor)bpdMap.get(name);
                    if (bpd == null) continue;
                    bpdArr[index++] = bpd;
                }
                this.setPropertyDescriptors(bpdArr);
            }
        }
    }
}

