/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.providers.java.RPCInvocation;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.webservice.Constants;
import org.jboss.webservice.server.InvokerProvider;
import org.jboss.webservice.server.ServiceException;

public class InvokerProviderJSE
extends InvokerProvider {
    private Logger log = Logger.getLogger((Class)InvokerProviderJSE.class);
    private Map methodMap = new HashMap();

    protected Object makeNewServiceObject(org.apache.axis.MessageContext msgContext, String className) throws Exception {
        this.log.debug((Object)("makeNewServiceObject: class=" + className));
        String serviceEndpointBean = this.portComponentInfo.getPortComponentMetaData().getServiceEndpointBean();
        if (serviceEndpointBean == null) {
            throw new ServiceException("Service endpoint bean class not set");
        }
        ClassLoader ctxLoader = this.getContextClassLoader();
        msgContext.setClassLoader(ctxLoader);
        Object obj = super.makeNewServiceObject(msgContext, serviceEndpointBean);
        return obj;
    }

    protected Object invokeTarget(RPCInvocation invocation) throws Exception {
        org.apache.axis.MessageContext msgContext = invocation.getMessageContext();
        try {
            if (!this.handlerChain.handleRequest((MessageContext)msgContext)) {
                this.log.warn((Object)"FIXME: handlerChain.handleRequest() returned false");
                return null;
            }
            invocation = (RPCInvocation)msgContext.getProperty("axis.provider.java.rpc-invocation");
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing request handler chain", (Throwable)e);
            throw e;
        }
        Object retObj = null;
        try {
            retObj = super.invokeTarget(invocation);
        }
        catch (Exception e) {
            msgContext.setProperty(Constants.LAST_FAULT, (Object)e);
            this.log.error((Object)"Error from service endpoint, processing fault handler chain", (Throwable)e);
            if (!this.handlerChain.handleFault((MessageContext)msgContext)) {
                this.log.warn((Object)"FIXME: handlerChain.handleFault() returned false");
                return null;
            }
            throw e;
        }
        try {
            invocation.prepareResponseEnvelope(retObj);
            if (!this.handlerChain.handleResponse((MessageContext)msgContext)) {
                this.log.warn((Object)"FIXME: handlerChain.handleResponse() returned false");
                return null;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error processing response handler chain", (Throwable)e);
            throw e;
        }
        return retObj;
    }

    protected Object invokeServiceEndpoint(org.apache.axis.MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        this.log.debug((Object)("Invoke JSE: " + method));
        Method beanMethod = (Method)this.methodMap.get(method);
        if (beanMethod == null) {
            beanMethod = obj.getClass().getMethod(method.getName(), method.getParameterTypes());
            this.methodMap.put(method, beanMethod);
        }
        Object retObj = beanMethod.invoke(obj, argValues);
        return retObj;
    }

    protected ClassLoader getContextClassLoader() {
        WebMetaData metaData = (WebMetaData)this.portComponentInfo.getDeploymentInfo().metaData;
        return metaData.getContextLoader();
    }
}

