/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.axis.utils.XMLUtils;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;
import org.w3c.dom.Document;

public class ServiceEndpointServlet
extends AxisServlet {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    private boolean assertServiceAccess(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String contextPath = req.getContextPath();
        String requestURI = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        if (requestURI.startsWith(contextPath + "/services/") && !"/Version".equals(pathInfo)) {
            this.reportTrouble(new IllegalAccessException(requestURI), res, res.getWriter());
            return false;
        }
        return true;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.assertServiceAccess(req, res)) {
            return;
        }
        super.doPost(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.assertServiceAccess(req, res)) {
            return;
        }
        String url = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        this.log.debug((Object)("doGet: " + url + (queryString != null ? "?" + queryString : "")));
        PrintWriter writer = res.getWriter();
        try {
            String transportURL;
            boolean listRequested;
            AxisServer engine = this.getEngine();
            String serviceName = this.getServiceName(req);
            SOAPService service = serviceName != null ? engine.getService(serviceName) : null;
            boolean wsdlRequested = req.getParameter("wsdl") != null || req.getParameter("WSDL") != null;
            boolean bl = listRequested = req.getParameter("list") != null || req.getParameter("LIST") != null;
            if (!listRequested && !wsdlRequested) {
                this.log.debug((Object)"Report available services");
                this.reportAvailableServices(res, writer, req);
                return;
            }
            if (service == null) {
                this.log.error((Object)("Cannot get axis service: " + serviceName));
                this.reportCantGetAxisService(req, res, writer);
                return;
            }
            if (listRequested) {
                this.log.debug((Object)"Process the list request");
                this.processListRequest(res, writer);
                return;
            }
            MessageContext msgContext = this.createMessageContext((AxisEngine)engine, req, res);
            if (service != null) {
                msgContext.setTargetService(serviceName);
            }
            if ((transportURL = this.getTransportURL(req, serviceName)) != null) {
                msgContext.setProperty("transport.url", (Object)transportURL);
                this.log.debug((Object)("Set transport.url=" + transportURL));
            }
            if (wsdlRequested) {
                String wsdlResource = req.getParameter("resource");
                if (wsdlResource != null) {
                    this.log.debug((Object)("Process wsdl import request: " + wsdlResource));
                    msgContext.setProperty("axis.wsdlgen.resource", (Object)wsdlResource);
                } else {
                    this.log.debug((Object)"Process wsdl request");
                }
                this.processWsdlRequest(msgContext, res, writer);
                return;
            }
            this.log.debug((Object)"Report service info");
            this.reportServiceInfo(res, writer, service, serviceName);
        }
        catch (AxisFault fault) {
            this.reportTrouble((Exception)((Object)fault), res, writer);
        }
        catch (Exception e) {
            this.reportTrouble(e, res, writer);
        }
        finally {
            AxisEngine.setCurrentMessageContext(null);
            writer.close();
        }
    }

    protected String getServiceName(HttpServletRequest req) {
        String serviceName = null;
        serviceName = req.getRequestURI().equals(req.getContextPath() + "/services/Version") ? "Version" : this.getServletConfig().getInitParameter("webserviceID");
        return serviceName;
    }

    protected String getTransportURL(HttpServletRequest req, String serviceName) {
        return req.getRequestURI();
    }

    protected void setupHTMLResponseHeader(HttpServletResponse res, PrintWriter writer) {
        writer.println("<head>");
        writer.println("<meta http-equiv='Content-Type content='text/html; charset=iso-8859-1'>");
        writer.println("<title>JBossWS</title>");
        writer.println("<link rel='stylesheet' href='/ws4ee/styles.css'>");
        writer.println("</head>");
    }

    protected void reportAvailableServices(HttpServletResponse res, PrintWriter writer, HttpServletRequest req) throws ConfigurationException, AxisFault {
        AxisServer engine = this.getEngine();
        res.setContentType("text/html");
        this.setupHTMLResponseHeader(res, writer);
        writer.println("<h2>And now... Some Services</h2>");
        writer.println("<ul>");
        AxisServiceMBean axisService = null;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            axisService = (AxisServiceMBean)MBeanProxy.get((Class)AxisServiceMBean.class, (ObjectName)AxisServiceMBean.OBJECT_NAME, (MBeanServer)server);
        }
        catch (MBeanProxyCreationException e) {
            throw new IllegalStateException("Cannot obtain: " + AxisServiceMBean.OBJECT_NAME);
        }
        Iterator it = engine.getConfig().getDeployedServices();
        while (it.hasNext()) {
            ServiceDesc sd = (ServiceDesc)it.next();
            String serviceName = sd.getName();
            PortComponentInfo pcInfo = axisService.getPortComponentInfo(serviceName);
            String serviceURL = null;
            serviceURL = pcInfo != null ? pcInfo.getServiceEndpointURL() : this.getWebappBase(req) + "/services/" + serviceName;
            StringBuffer sb = new StringBuffer("<li>" + serviceName + "<a href='" + serviceURL + "?wsdl'>&nbsp;<i>(wsdl)</i></a></li>");
            ArrayList operations = sd.getOperations();
            if (!operations.isEmpty()) {
                sb.append("<ul>");
                Iterator itOp = operations.iterator();
                while (itOp.hasNext()) {
                    OperationDesc desc = (OperationDesc)itOp.next();
                    sb.append("<li>" + desc.getName() + "</li>");
                }
                sb.append("</ul>");
            }
            writer.println(sb.toString());
        }
        writer.println("</ul>");
    }

    protected void processWsdlRequest(MessageContext msgContext, HttpServletResponse res, PrintWriter writer) throws AxisFault {
        String serviceURL = (String)msgContext.getProperty("transport.url");
        AxisServer engine = this.getEngine();
        engine.generateWSDL(msgContext);
        Document doc = (Document)msgContext.getProperty("WSDL");
        if (doc == null) {
            throw new AxisFault("Cannot get wsdl document for service: " + serviceURL);
        }
        res.setContentType("text/xml");
        XMLUtils.DocumentToWriter((Document)doc, (Writer)writer);
    }

    public AxisServer getEngine() throws AxisFault {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            this.axisServer = (AxisServer)server.getAttribute(AxisServiceMBean.OBJECT_NAME, "AxisServer");
        }
        catch (Exception e) {
            this.log.warn((Object)"Cannot access AxisService, using default server config");
            this.axisServer = super.getEngine();
        }
        return this.axisServer;
    }
}

