/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.coreintensity;

import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterBean;
import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterPunchData;
import at.tugraz.genome.tma.AlgorithmAdapter.AlgorithmAdapterResult;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;

public class CoreIntensityBean
extends AlgorithmAdapterBean {
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    SessionContext sessionContext;

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    protected Collection executeAlgorithm(AlgorithmAdapterPunchData data, Hashtable parameters) throws TmaGlobalException {
        ArrayList results = new ArrayList();
        Hashtable image_table = data.getBufferedImages();
        Long image_id = (Long)image_table.get("Cy3ID");
        BufferedImage image = (BufferedImage)image_table.get("Image");
        Long[] image_ids = new Long[]{image_id};
        AlgorithmAdapterResult result = new AlgorithmAdapterResult(data, image_ids, "Mean intensity", this.getMeanIntensity(image));
        return results;
    }

    private String getMeanIntensity(BufferedImage buff_image) {
        String mean_intensity = "";
        Raster raster = buff_image.getData();
        int sample = 0;
        double intensity = 0.0;
        int pixels = 0;
        int x_count = 0;
        while (x_count < raster.getWidth()) {
            int y_count = 0;
            while (y_count < raster.getHeight()) {
                sample = raster.getSample(x_count, y_count, 0);
                if (sample > 0) {
                    intensity += (double)sample;
                    ++pixels;
                }
                ++y_count;
            }
            ++x_count;
        }
        DecimalFormat df = new DecimalFormat("#####.##");
        df.getDecimalFormatSymbols().setDecimalSeparator('.');
        mean_intensity = df.format(intensity / (double)pixels);
        return mean_intensity;
    }

    public String getVersion() {
        return "1.3";
    }

    public Boolean isStartable() {
        return new Boolean(true);
    }

    public void setSessionContext(SessionContext sessionContext) {
    }

    public String start(ObjectMessage inputmsg) {
        return super.start(inputmsg);
    }
}

