/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.GlobalId;
import org.jboss.tm.JBossRollbackException;
import org.jboss.tm.LastResource;
import org.jboss.tm.LocalId;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionManagerService;
import org.jboss.tm.TxManager;
import org.jboss.tm.XidFactory;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.XidImpl;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutFactory;
import org.jboss.util.timeout.TimeoutTarget;

public class TransactionImpl
implements Transaction,
TimeoutTarget {
    private static final int HEUR_NONE = 4;
    private static final int RS_NEW = 0;
    private static final int RS_ENLISTED = 1;
    private static final int RS_SUSPENDED = 2;
    private static final int RS_ENDED = 3;
    private static final int RS_VOTE_READONLY = 4;
    private static final int RS_VOTE_OK = 5;
    private static final int RS_FORGOT = 6;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$tm$TransactionImpl == null ? (class$org$jboss$tm$TransactionImpl = TransactionImpl.class$("org.jboss.tm.TransactionImpl")) : class$org$jboss$tm$TransactionImpl));
    private boolean trace = log.isTraceEnabled();
    private XidImpl xid;
    private GlobalId gid;
    private HashSet threads = new HashSet(1);
    private HashMap transactionLocalMap = new HashMap();
    private Throwable cause;
    private Synchronization[] sync = new Synchronization[3];
    private int syncAllocSize = 3;
    private int syncCount = 0;
    private ArrayList resources = new ArrayList(3);
    private Resource lastResource;
    private boolean resourcesEnded = false;
    private long lastBranchId = 0L;
    private int status;
    private int heuristicCode = 4;
    private long start;
    private Timeout timeout;
    private long timeoutPeriod;
    private boolean locked = false;
    private Work work;
    private boolean done = false;
    static XidFactoryMBean xidFactory;
    static TransactionManagerService txManagerService;
    static /* synthetic */ Class class$org$jboss$tm$TransactionImpl;

    static void defaultXidFactory() {
        if (xidFactory == null) {
            xidFactory = new XidFactory();
        }
    }

    TransactionImpl(long timeout) {
        this.xid = xidFactory.newXid();
        this.gid = this.xid.getTrulyGlobalId();
        this.status = 0;
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout((long)(this.start + timeout), (TimeoutTarget)this);
        this.timeoutPeriod = timeout;
        if (this.trace) {
            log.trace((Object)("Created new instance for tx=" + this.toString()));
        }
    }

    TransactionImpl(GlobalId gid, long timeout) {
        this.gid = gid;
        this.xid = xidFactory.newXid();
        this.status = 0;
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout((long)(this.start + timeout), (TimeoutTarget)this);
        this.timeoutPeriod = timeout;
        if (this.trace) {
            log.trace((Object)("Created new instance for tx=" + this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedOut(Timeout timeout) {
        this.lock();
        try {
            log.warn((Object)("Transaction " + this.toString() + " timed out." + " status=" + this.getStringStatus(this.status)));
            if (this.timeout == null) {
                return;
            }
            this.timeout = null;
            switch (this.status) {
                case 3: 
                case 4: 
                case 6: {
                    return;
                }
                case 9: {
                    return;
                }
                case 8: {
                    this.gotHeuristic(null, 5);
                    this.status = 1;
                    return;
                }
                case 0: 
                case 2: {
                    this.status = 1;
                }
                case 1: {
                    this.interruptThreads();
                    return;
                }
                case 7: {
                    this.status = 1;
                    return;
                }
            }
            log.warn((Object)("Unknown status at timeout, tx=" + this.toString()));
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace((Object)("Committing, tx=" + this + ", status=" + this.getStringStatus(this.status)));
            }
            this.beforePrepare();
            if (this.status == 0) {
                switch (this.getCommitStrategy()) {
                    case 0: {
                        if (this.trace) {
                            log.trace((Object)("Zero phase commit " + this + ": No resources."));
                        }
                        this.status = 3;
                        break;
                    }
                    case 1: {
                        if (this.trace) {
                            log.trace((Object)("One phase commit " + this + ": One resource."));
                        }
                        this.commitResources(true);
                        break;
                    }
                    default: {
                        if (this.trace) {
                            log.trace((Object)("Two phase commit " + this + ": Many resources."));
                        }
                        if (!this.prepareResources()) {
                            boolean commitDecision;
                            boolean bl = commitDecision = this.status == 2 && (this.heuristicCode == 4 || this.heuristicCode == 7);
                            if (!commitDecision) break;
                            this.commitResources(false);
                            break;
                        }
                        this.status = 3;
                    }
                }
            }
            if (this.status != 3) {
                Throwable causedByThrowable = this.cause;
                this.rollbackResources();
                this.completeTransaction();
                throw new JBossRollbackException("Unable to commit, tx=" + this.toString() + " status=" + this.getStringStatus(this.status), causedByThrowable);
            }
            this.completeTransaction();
            this.checkHeuristics();
            if (this.trace) {
                log.trace((Object)("Committed OK, tx=" + this));
            }
        }
        finally {
            this.unlock();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace((Object)("rollback(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
            }
            this.checkWork();
            switch (this.status) {
                case 0: {
                    this.status = 1;
                }
                case 1: {
                    this.endResources();
                    this.rollbackResources();
                    this.completeTransaction();
                    this.heuristicCode = 4;
                    return;
                }
                case 7: {
                    this.status = 1;
                    return;
                }
            }
            throw new IllegalStateException("Cannot rollback(), tx=" + this.toString() + " status=" + this.getStringStatus(this.status));
        }
        finally {
            Thread.interrupted();
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes tx=" + this);
        }
        if (flag != 0x4000000 && flag != 0x2000000 && flag != 0x20000000) {
            throw new IllegalArgumentException("Bad flag: " + flag + " tx=" + this);
        }
        this.lock();
        try {
            Resource resource;
            if (this.trace) {
                log.trace((Object)("delistResource(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
            }
            if ((resource = this.findResource(xaRes)) == null) {
                throw new IllegalArgumentException("xaRes not enlisted " + xaRes);
            }
            switch (this.status) {
                case 0: 
                case 1: {
                    break;
                }
                case 7: {
                    throw new IllegalStateException("Already started preparing. " + this);
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back. " + this);
                }
                case 2: {
                    throw new IllegalStateException("Already prepared. " + this);
                }
                case 8: {
                    throw new IllegalStateException("Already started committing. " + this);
                }
                case 3: {
                    throw new IllegalStateException("Already committed. " + this);
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back. " + this);
                }
                case 6: {
                    throw new IllegalStateException("No transaction. " + this);
                }
                case 5: {
                    throw new IllegalStateException("Unknown state " + this);
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.getStringStatus(this.status) + " tx=" + this);
                }
            }
            try {
                boolean bl = resource.delistResource(xaRes, flag);
                return bl;
            }
            catch (XAException xae) {
                this.logXAException(xae);
                this.status = 1;
                this.cause = xae;
                boolean bl = false;
                this.unlock();
                return bl;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes tx=" + this);
        }
        this.lock();
        try {
            Resource resource;
            block26: {
                block27: {
                    if (this.trace) {
                        log.trace((Object)("enlistResource(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
                    }
                    switch (this.status) {
                        case 0: 
                        case 7: {
                            break;
                        }
                        case 2: {
                            throw new IllegalStateException("Already prepared. " + this);
                        }
                        case 8: {
                            throw new IllegalStateException("Already started committing. " + this);
                        }
                        case 3: {
                            throw new IllegalStateException("Already committed. " + this);
                        }
                        case 1: {
                            throw new RollbackException("Already marked for rollback " + this);
                        }
                        case 9: {
                            throw new RollbackException("Already started rolling back. " + this);
                        }
                        case 4: {
                            throw new RollbackException("Already rolled back. " + this);
                        }
                        case 6: {
                            throw new IllegalStateException("No transaction. " + this);
                        }
                        case 5: {
                            throw new IllegalStateException("Unknown state " + this);
                        }
                        default: {
                            throw new IllegalStateException("Illegal status: " + this.getStringStatus(this.status) + " tx=" + this);
                        }
                    }
                    if (this.resourcesEnded) {
                        throw new IllegalStateException("Too late to enlist resources " + this);
                    }
                    try {
                        resource = this.findResource(xaRes);
                        if (resource == null) break block26;
                        if (!resource.isEnlisted()) break block27;
                        boolean bl = false;
                        return bl;
                    }
                    catch (XAException xae) {
                        this.logXAException(xae);
                        this.cause = xae;
                        boolean bl = false;
                        return bl;
                    }
                }
                if (resource.isDelisted(xaRes)) {
                    resource = null;
                } else {
                    boolean bl = resource.startResource();
                    return bl;
                }
            }
            if ((resource = this.findResourceManager(xaRes)) != null) {
                resource = this.addResource(xaRes, resource.getXid(), resource);
                boolean bl = resource.startResource();
                return bl;
            }
            resource = this.addResource(xaRes, this.createXidBranch(), null);
            boolean bl = resource.startResource();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public int getStatus() throws SystemException {
        if (this.done) {
            return 6;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization s) throws RollbackException, IllegalStateException, SystemException {
        if (s == null) {
            throw new IllegalArgumentException("Null synchronization " + this);
        }
        this.lock();
        try {
            if (this.trace) {
                log.trace((Object)("registerSynchronization(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
            }
            switch (this.status) {
                case 0: 
                case 7: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Already prepared. " + this);
                }
                case 8: {
                    throw new IllegalStateException("Already started committing. " + this);
                }
                case 3: {
                    throw new IllegalStateException("Already committed. " + this);
                }
                case 1: {
                    throw new RollbackException("Already marked for rollback " + this);
                }
                case 9: {
                    throw new RollbackException("Already started rolling back. " + this);
                }
                case 4: {
                    throw new RollbackException("Already rolled back. " + this);
                }
                case 6: {
                    throw new IllegalStateException("No transaction. " + this);
                }
                case 5: {
                    throw new IllegalStateException("Unknown state " + this);
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.getStringStatus(this.status) + " tx=" + this);
                }
            }
            if (this.syncCount == this.syncAllocSize) {
                this.syncAllocSize = 2 * this.syncAllocSize;
                Synchronization[] sy = new Synchronization[this.syncAllocSize];
                System.arraycopy(this.sync, 0, sy, 0, this.syncCount);
                this.sync = sy;
            }
            this.sync[this.syncCount++] = s;
        }
        finally {
            this.unlock();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace((Object)("setRollbackOnly(): Entered, tx=" + this.toString() + " status=" + this.getStringStatus(this.status)));
            }
            switch (this.status) {
                case 0: 
                case 2: 
                case 7: {
                    this.status = 1;
                }
                case 1: 
                case 9: {
                    return;
                }
                case 8: {
                    throw new IllegalStateException("Already started committing. " + this);
                }
                case 3: {
                    throw new IllegalStateException("Already committed. " + this);
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back. " + this);
                }
                case 6: {
                    throw new IllegalStateException("No transaction. " + this);
                }
                case 5: {
                    throw new IllegalStateException("Unknown state " + this);
                }
            }
            throw new IllegalStateException("Illegal status: " + this.getStringStatus(this.status) + " tx=" + this);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateCurrentThread() {
        this.lock();
        try {
            this.threads.add(Thread.currentThread());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassociateCurrentThread() {
        if (this.done) {
            this.threads.remove(Thread.currentThread());
        } else {
            this.lock();
            try {
                this.threads.remove(Thread.currentThread());
            }
            finally {
                this.unlock();
            }
        }
        Thread.interrupted();
    }

    public int hashCode() {
        return this.xid.hashCode();
    }

    public String toString() {
        return "TransactionImpl:" + xidFactory.toString(this.xid);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TransactionImpl) {
            return this.getLocalIdValue() == ((TransactionImpl)obj).getLocalIdValue();
        }
        return false;
    }

    public long getLocalIdValue() {
        return this.xid.getLocalIdValue();
    }

    public LocalId getLocalId() {
        return this.xid.getLocalId();
    }

    public GlobalId getGlobalId() {
        return this.gid;
    }

    public XidImpl getXid() {
        return this.xid;
    }

    synchronized void lock() {
        if (this.done) {
            throw new IllegalStateException("Transaction has terminated " + this);
        }
        if (this.locked) {
            log.warn((Object)("Lock contention, tx=" + this.toString()));
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.done) continue;
                throw new IllegalStateException("Transaction has now terminated " + this);
            }
        }
        this.locked = true;
    }

    synchronized void unlock() {
        if (!this.locked) {
            log.warn((Object)("Unlocking, but not locked, tx=" + this.toString()), new Throwable("[Stack trace]"));
        }
        this.locked = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int prepare() throws HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.lock();
        try {
            if (this.trace) {
                log.trace((Object)("Preparing, tx=" + this + ", status=" + this.getStringStatus(this.status)));
            }
            this.checkWork();
            this.beforePrepare();
            if (this.status == 0) {
                switch (this.getCommitStrategy()) {
                    case 0: {
                        if (this.trace) {
                            log.trace((Object)("Prepare tx=" + this + ": No resources."));
                        }
                        this.status = 3;
                        this.completeTransaction();
                        int n = 3;
                        return n;
                    }
                }
                if (this.trace) {
                    log.trace((Object)("Prepare tx=" + this + ": Many resources."));
                }
                if (!this.prepareResources()) {
                    boolean commitDecision = this.status == 2 && (this.heuristicCode == 4 || this.heuristicCode == 7);
                } else {
                    if (this.trace) {
                        log.trace((Object)("Prepared tx=" + this + ": All readonly."));
                    }
                    this.status = 3;
                    this.completeTransaction();
                    int commitDecision = 3;
                    return commitDecision;
                }
            }
            if (this.status != 2) {
                Throwable causedByThrowable = this.cause;
                this.rollbackResources();
                this.completeTransaction();
                throw new JBossRollbackException("Unable to prepare, tx=" + this.toString() + " status=" + this.getStringStatus(this.status), causedByThrowable);
            }
            int n = 0;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(boolean onePhase) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.checkWork();
        if (onePhase) {
            this.commit();
            return;
        }
        this.lock();
        try {
            if (this.trace) {
                log.trace((Object)("Committing two phase, tx=" + this + ", status=" + this.getStringStatus(this.status)));
            }
            switch (this.status) {
                case 7: {
                    throw new IllegalStateException("Still preparing. " + this);
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back. " + this);
                }
                case 4: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already rolled back. " + this);
                }
                case 8: {
                    throw new IllegalStateException("Already started committing. " + this);
                }
                case 3: {
                    this.instanceDone();
                    this.checkHeuristics();
                    throw new IllegalStateException("Already committed. " + this);
                }
                case 6: {
                    throw new IllegalStateException("No transaction. " + this);
                }
                case 5: {
                    throw new IllegalStateException("Unknown state " + this);
                }
                case 1: {
                    this.endResources();
                    this.rollbackResources();
                    this.completeTransaction();
                    this.checkHeuristics();
                    throw new RollbackException("Already marked for rollback " + this);
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + this.getStringStatus(this.status) + " tx=" + this);
                }
            }
            this.commitResources(false);
            if (this.status != 3) {
                Throwable causedByThrowable = this.cause;
                this.rollbackResources();
                this.completeTransaction();
                throw new JBossRollbackException("Unable to commit, tx=" + this.toString() + " status=" + this.getStringStatus(this.status), causedByThrowable);
            }
            this.completeTransaction();
            this.checkHeuristics();
            if (this.trace) {
                log.trace((Object)("Committed OK, tx=" + this));
            }
        }
        finally {
            this.unlock();
        }
    }

    Work getWork() {
        return this.work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWork(Work work) throws WorkCompletedException {
        this.lock();
        try {
            if (work == null) {
                this.work = null;
                return;
            }
            if (this.status == 6 || this.status == 5) {
                throw new WorkCompletedException("The transaction is not active " + this + ": " + this.getStringStatus(this.status), "3");
            }
            if (this.status != 0) {
                throw new WorkCompletedException("Too late to start work " + this + ": " + this.getStringStatus(this.status), "2");
            }
            if (this.work != null) {
                throw new WorkCompletedException("Already have work " + this + ": " + this.work, "2");
            }
            this.work = work;
        }
        finally {
            this.unlock();
        }
    }

    boolean isDone() {
        return this.done;
    }

    private void beforePrepare() throws HeuristicMixedException, HeuristicRollbackException, RollbackException {
        switch (this.status) {
            case 7: {
                throw new IllegalStateException("Already started preparing. " + this);
            }
            case 2: {
                throw new IllegalStateException("Already prepared. " + this);
            }
            case 9: {
                throw new IllegalStateException("Already started rolling back. " + this);
            }
            case 4: {
                this.instanceDone();
                this.checkHeuristics();
                throw new IllegalStateException("Already rolled back." + this);
            }
            case 8: {
                throw new IllegalStateException("Already started committing. " + this);
            }
            case 3: {
                this.instanceDone();
                this.checkHeuristics();
                throw new IllegalStateException("Already committed. " + this);
            }
            case 6: {
                throw new IllegalStateException("No transaction. " + this);
            }
            case 5: {
                throw new IllegalStateException("Unknown state " + this);
            }
            case 1: {
                this.endResources();
                this.rollbackResources();
                this.completeTransaction();
                this.checkHeuristics();
                throw new RollbackException("Already marked for rollback " + this);
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Illegal status: " + this.getStringStatus(this.status) + " tx=" + this);
            }
        }
        this.doBeforeCompletion();
        if (this.trace) {
            log.trace((Object)("Before completion done, tx=" + this + ", status=" + this.getStringStatus(this.status)));
        }
        this.endResources();
    }

    private void completeTransaction() {
        this.cancelTimeout();
        this.doAfterCompletion();
        this.instanceDone();
    }

    private void interruptThreads() {
        TxManager manager = TxManager.getInstance();
        if (manager.isInterruptThreads()) {
            HashSet clone = (HashSet)this.threads.clone();
            this.threads.clear();
            Iterator i = clone.iterator();
            while (i.hasNext()) {
                Thread thread = (Thread)i.next();
                try {
                    thread.interrupt();
                }
                catch (Throwable ignored) {
                    if (!this.trace) continue;
                    log.trace((Object)("Ignored error interrupting thread: " + thread), ignored);
                }
            }
        }
    }

    private String getStringStatus(int status) {
        switch (status) {
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 0: {
                return "STATUS_ACTIVE";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    private String getStringXAErrorCode(int errorCode) {
        switch (errorCode) {
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case 9: {
                return "XA_NOMIGRATE";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 3: {
                return "XA_RDONLY";
            }
            case 4: {
                return "XA_RETRY";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
        }
        return "XA_UNKNOWN(" + errorCode + ")";
    }

    private void logXAException(XAException xae) {
        log.warn((Object)("XAException: tx=" + this.toString() + " errorCode=" + this.getStringXAErrorCode(xae.errorCode)), (Throwable)xae);
        if (txManagerService != null) {
            txManagerService.formatXAException(xae, log);
        }
    }

    private synchronized void instanceDone() {
        TxManager manager = TxManager.getInstance();
        if (this.status == 3) {
            manager.incCommitCount();
        } else {
            manager.incRollbackCount();
        }
        this.sync = null;
        this.resources = null;
        this.transactionLocalMap.clear();
        this.threads.clear();
        manager.releaseTransactionImpl(this);
        this.status = 6;
        this.notifyAll();
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimeout() {
        if (this.timeout != null) {
            this.unlock();
            try {
                this.timeout.cancel();
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)("failed to cancel timeout " + this), (Throwable)e);
                }
            }
            finally {
                this.lock();
            }
            this.timeout = null;
        }
    }

    private Resource findResource(XAResource xaRes) {
        for (int idx = this.resources.size() - 1; idx >= 0; --idx) {
            Resource resource = (Resource)this.resources.get(idx);
            if (xaRes != resource.getXAResource()) continue;
            return resource;
        }
        return null;
    }

    private Resource findResourceManager(XAResource xaRes) throws XAException {
        for (int i = 0; i < this.resources.size(); ++i) {
            Resource resource = (Resource)this.resources.get(i);
            if (!resource.isResourceManager(xaRes)) continue;
            return resource;
        }
        return null;
    }

    private Resource addResource(XAResource xaRes, Xid branchXid, Resource sameRMResource) {
        Resource resource = new Resource(xaRes, branchXid, sameRMResource);
        this.resources.add(resource);
        if (this.lastResource == null && xaRes instanceof LastResource) {
            this.lastResource = resource;
        }
        return resource;
    }

    private void endResources() {
        for (int idx = 0; idx < this.resources.size(); ++idx) {
            Resource resource = (Resource)this.resources.get(idx);
            try {
                resource.endResource();
                continue;
            }
            catch (XAException xae) {
                this.logXAException(xae);
                this.status = 1;
                this.cause = xae;
            }
        }
        this.resourcesEnded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBeforeCompletion() {
        this.unlock();
        try {
            for (int i = 0; i < this.syncCount; ++i) {
                try {
                    if (this.trace) {
                        log.trace((Object)("calling sync " + i + ", " + this.sync[i] + " tx=" + this));
                    }
                    this.sync[i].beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    if (this.trace) {
                        log.trace((Object)("failed before completion " + this.sync[i]), t);
                    }
                    this.status = 1;
                    this.cause = t;
                    break;
                }
            }
        }
        finally {
            this.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterCompletion() {
        this.unlock();
        try {
            for (int i = 0; i < this.syncCount; ++i) {
                try {
                    this.sync[i].afterCompletion(this.status);
                    continue;
                }
                catch (Throwable t) {
                    if (!this.trace) continue;
                    log.trace((Object)("failed after completion " + this.sync[i]), t);
                }
            }
        }
        finally {
            this.lock();
        }
    }

    private void gotHeuristic(Resource resource, int code) {
        switch (code) {
            case 5: {
                this.heuristicCode = 5;
                break;
            }
            case 6: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 6;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 7: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 7;
                    break;
                }
                if (this.heuristicCode != 6 && this.heuristicCode != 8) break;
                this.heuristicCode = 5;
                break;
            }
            case 8: {
                if (this.heuristicCode == 4) {
                    this.heuristicCode = 8;
                    break;
                }
                if (this.heuristicCode != 7 && this.heuristicCode != 6) break;
                this.heuristicCode = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (resource != null) {
            resource.forget();
        }
    }

    private void checkHeuristics() throws HeuristicMixedException, HeuristicRollbackException {
        switch (this.heuristicCode) {
            case 5: 
            case 8: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace((Object)("Throwing HeuristicMixedException, tx=" + this + "status=" + this.getStringStatus(this.status)));
                }
                throw new HeuristicMixedException();
            }
            case 6: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace((Object)("Throwing HeuristicRollbackException, tx=" + this + "status=" + this.getStringStatus(this.status)));
                }
                throw new HeuristicRollbackException();
            }
            case 7: {
                this.heuristicCode = 4;
                if (this.trace) {
                    log.trace((Object)("NOT Throwing HeuristicCommitException, tx=" + this + "status=" + this.getStringStatus(this.status)));
                }
                return;
            }
        }
    }

    private boolean prepareResources() {
        boolean readOnly = true;
        this.status = 7;
        block13: for (int i = 0; i < this.resources.size(); ++i) {
            if (this.status != 7) {
                return false;
            }
            Resource resource = (Resource)this.resources.get(i);
            if (!resource.isResourceManager() || resource == this.lastResource) continue;
            try {
                int vote = resource.prepare();
                if (vote == 5) {
                    readOnly = false;
                    continue;
                }
                if (vote == 4) continue;
                if (this.trace) {
                    log.trace((Object)("illegal vote in prepare resources tx=" + this + " resource=" + resource), (Throwable)new Exception());
                }
                this.status = 1;
                return false;
            }
            catch (XAException e) {
                readOnly = false;
                this.logXAException(e);
                switch (e.errorCode) {
                    case 7: {
                        this.gotHeuristic(resource, e.errorCode);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        this.gotHeuristic(resource, e.errorCode);
                        if (this.status != 7) continue block13;
                        this.status = 1;
                        break;
                    }
                    default: {
                        this.cause = e;
                        if (this.status != 7) continue block13;
                        this.status = 1;
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace((Object)("unhandled throwable in prepareResources " + this), t);
                }
                if (this.status == 7) {
                    this.status = 1;
                }
                this.cause = t;
            }
        }
        if (this.status != 7) {
            return false;
        }
        if (this.lastResource != null) {
            try {
                this.lastResource.prepareLastResource();
                this.lastResource.commit(false);
            }
            catch (XAException e) {
                this.logXAException(e);
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.gotHeuristic(this.lastResource, e.errorCode);
                        if (this.status == 7) {
                            this.status = 1;
                            break;
                        }
                    }
                    default: {
                        this.cause = e;
                        if (this.status == 7) {
                            this.status = 1;
                            break;
                        }
                    }
                }
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace((Object)("unhandled throwable in prepareResources " + this), t);
                }
                if (this.status == 7) {
                    this.status = 1;
                }
                this.cause = t;
            }
        }
        if (this.status == 7) {
            this.status = 2;
        }
        return readOnly;
    }

    private void commitResources(boolean onePhase) {
        this.status = 8;
        block6: for (int i = 0; i < this.resources.size(); ++i) {
            if (this.status != 8) {
                return;
            }
            Resource resource = (Resource)this.resources.get(i);
            if (!onePhase && this.lastResource == resource) continue;
            try {
                resource.commit(onePhase);
                continue;
            }
            catch (XAException e) {
                this.logXAException(e);
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.gotHeuristic(resource, e.errorCode);
                        if (!onePhase) continue block6;
                        this.status = 1;
                        break;
                    }
                    default: {
                        this.cause = e;
                        if (!onePhase) continue block6;
                        this.status = 1;
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (!this.trace) continue;
                log.trace((Object)("unhandled throwable in commitResources " + this), t);
            }
        }
        if (this.status == 8) {
            this.status = 3;
        }
    }

    private void rollbackResources() {
        this.status = 9;
        for (int i = 0; i < this.resources.size(); ++i) {
            Resource resource = (Resource)this.resources.get(i);
            try {
                resource.rollback();
                continue;
            }
            catch (XAException e) {
                this.logXAException(e);
                switch (e.errorCode) {
                    case 6: {
                        this.gotHeuristic(resource, e.errorCode);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        this.gotHeuristic(resource, e.errorCode);
                        break;
                    }
                    default: {
                        this.cause = e;
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (!this.trace) continue;
                log.trace((Object)("unhandled throwable in rollbackResources " + this), t);
            }
        }
        this.status = 4;
    }

    private Xid createXidBranch() {
        long branchId = ++this.lastBranchId;
        return xidFactory.newBranch(this.xid, branchId);
    }

    private int getCommitStrategy() {
        int resourceCount = this.resources.size();
        if (resourceCount == 0) {
            return 0;
        }
        if (resourceCount == 1) {
            return 1;
        }
        for (int i = 1; i < resourceCount; ++i) {
            Resource resource = (Resource)this.resources.get(i);
            if (!resource.isResourceManager()) continue;
            return 2;
        }
        return 1;
    }

    public long getTimeLeftBeforeTimeout() {
        return this.start + this.timeoutPeriod - System.currentTimeMillis();
    }

    Object getTransactionLocalValue(TransactionLocal tlocal) {
        return this.transactionLocalMap.get(tlocal);
    }

    void putTransactionLocalValue(TransactionLocal tlocal, Object value) {
        this.transactionLocalMap.put(tlocal, value);
    }

    boolean containsTransactionLocal(TransactionLocal tlocal) {
        return this.transactionLocalMap.containsKey(tlocal);
    }

    private void checkWork() {
        if (this.work != null) {
            throw new IllegalStateException("Work still outstanding " + this.work + " tx=" + this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Resource {
        private XAResource xaResource;
        private int resourceState;
        private Resource resourceSameRM;
        private Xid resourceXid;

        public Resource(XAResource xaResource, Xid resourceXid, Resource resourceSameRM) {
            this.xaResource = xaResource;
            this.resourceXid = resourceXid;
            this.resourceSameRM = resourceSameRM;
            this.resourceState = 0;
        }

        public XAResource getXAResource() {
            return this.xaResource;
        }

        public Xid getXid() {
            return this.resourceXid;
        }

        public boolean isEnlisted() {
            return this.resourceState == 1;
        }

        public boolean isResourceManager() {
            return this.resourceSameRM == null;
        }

        public boolean isResourceManager(XAResource xaRes) throws XAException {
            return this.resourceSameRM == null && xaRes.isSameRM(this.xaResource);
        }

        public boolean isDelisted(XAResource xaRes) throws XAException {
            return this.resourceState == 3 && !this.xaResource.isSameRM(xaRes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean startResource() throws XAException {
            int flags = 0x200000;
            if (this.resourceSameRM == null) {
                switch (this.resourceState) {
                    case 0: {
                        flags = 0;
                        break;
                    }
                    case 2: {
                        flags = 0x8000000;
                        break;
                    }
                    default: {
                        if (!TransactionImpl.this.trace) break;
                        log.trace((Object)("Unhandled resource state: " + this.resourceState + " (not RS_NEW or RS_SUSPENDED, using TMJOIN flags)"));
                    }
                }
            }
            if (TransactionImpl.this.trace) {
                log.trace((Object)("startResource(" + xidFactory.toString(this.resourceXid) + ") entered: " + this.xaResource.toString() + " flags=" + flags));
            }
            TransactionImpl.this.unlock();
            try {
                try {
                    this.xaResource.start(this.resourceXid, flags);
                }
                catch (XAException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (TransactionImpl.this.trace) {
                        log.trace((Object)"unhandled throwable error in startResource", t);
                    }
                    TransactionImpl.this.status = 1;
                    boolean bl = false;
                    Object var5_5 = null;
                    TransactionImpl.this.lock();
                    if (TransactionImpl.this.trace) {
                        log.trace((Object)("startResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flags=" + flags));
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                TransactionImpl.this.lock();
                if (TransactionImpl.this.trace) {
                    log.trace((Object)("startResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flags=" + flags));
                }
                throw throwable;
            }
            this.resourceState = 1;
            Object var5_6 = null;
            TransactionImpl.this.lock();
            if (TransactionImpl.this.trace) {
                log.trace((Object)("startResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flags=" + flags));
            }
            return true;
        }

        public boolean delistResource(XAResource xaRes, int flag) throws XAException {
            if (this.isDelisted(xaRes)) {
                log.warn((Object)("Resource already delisted.  tx=" + this.toString()));
                return false;
            }
            this.endResource(flag);
            return true;
        }

        public void endResource() throws XAException {
            if (this.resourceState == 1 || this.resourceState == 2) {
                if (TransactionImpl.this.trace) {
                    log.trace((Object)("endresources(" + this.xaResource + "): state=" + this.resourceState));
                }
                this.endResource(0x4000000);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endResource(int flag) throws XAException {
            if (TransactionImpl.this.trace) {
                log.trace((Object)("endResource(" + xidFactory.toString(this.resourceXid) + ") entered: " + this.xaResource.toString() + " flag=" + flag));
            }
            TransactionImpl.this.unlock();
            try {
                try {
                    this.xaResource.end(this.resourceXid, flag);
                }
                catch (XAException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (TransactionImpl.this.trace) {
                        log.trace((Object)"unhandled throwable error in endResource", t);
                    }
                    TransactionImpl.this.status = 1;
                    this.resourceState = 3;
                    Object var4_4 = null;
                    TransactionImpl.this.lock();
                    if (TransactionImpl.this.trace) {
                        log.trace((Object)("endResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flag=" + flag));
                    }
                    return;
                }
                if (flag == 0x2000000) {
                    this.resourceState = 2;
                } else {
                    if (flag == 0x20000000) {
                        TransactionImpl.this.status = 1;
                    }
                    this.resourceState = 3;
                }
                Object var4_5 = null;
                TransactionImpl.this.lock();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                TransactionImpl.this.lock();
                if (TransactionImpl.this.trace) {
                    log.trace((Object)("endResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flag=" + flag));
                }
                throw throwable;
            }
            if (TransactionImpl.this.trace) {
                log.trace((Object)("endResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flag=" + flag));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forget() {
            TransactionImpl.this.unlock();
            try {
                this.xaResource.forget(this.resourceXid);
            }
            catch (XAException xae) {
                TransactionImpl.this.logXAException(xae);
                TransactionImpl.this.cause = xae;
            }
            finally {
                TransactionImpl.this.lock();
            }
            this.resourceState = 6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int prepare() throws XAException {
            int vote;
            TransactionImpl.this.unlock();
            try {
                vote = this.xaResource.prepare(this.resourceXid);
            }
            finally {
                TransactionImpl.this.lock();
            }
            if (vote == 0) {
                this.resourceState = 5;
            } else if (vote == 3) {
                this.resourceState = 4;
            }
            return this.resourceState;
        }

        public void prepareLastResource() throws XAException {
            this.resourceState = 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(boolean onePhase) throws XAException {
            if (TransactionImpl.this.trace) {
                log.trace((Object)("Committing resource " + this.xaResource + " state=" + this.resourceState));
            }
            if (!onePhase && this.resourceState != 5) {
                return;
            }
            if (this.resourceSameRM != null) {
                return;
            }
            TransactionImpl.this.unlock();
            try {
                this.xaResource.commit(this.resourceXid, onePhase);
            }
            finally {
                TransactionImpl.this.lock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() throws XAException {
            if (this.resourceState == 4) {
                return;
            }
            if (this.resourceState == 6) {
                return;
            }
            if (this.resourceSameRM != null) {
                return;
            }
            TransactionImpl.this.unlock();
            try {
                this.xaResource.rollback(this.resourceXid);
            }
            finally {
                TransactionImpl.this.lock();
            }
        }
    }
}

