/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.io.Serializable;
import javax.transaction.xa.Xid;
import org.jboss.tm.GlobalId;
import org.jboss.tm.LocalId;

public class XidImpl
implements Xid,
Serializable {
    public static final int JBOSS_FORMAT_ID = 257;
    private static boolean trulyGlobalIdsEnabled = false;
    private final int formatId;
    private final byte[] globalId;
    private final byte[] branchId;
    private final int hash;
    private final long localId;
    private final GlobalId trulyGlobalId;

    public static void setTrulyGlobalIdsEnabled(boolean newValue) {
        trulyGlobalIdsEnabled = newValue;
    }

    public static boolean getTrulyGlobalIdsEnabled() {
        return trulyGlobalIdsEnabled;
    }

    static String toString(Xid id) {
        if (id == null) {
            return "[NULL Xid]";
        }
        String s = id.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        s = s + "[FormatId=" + id.getFormatId() + ", GlobalId=" + new String(id.getGlobalTransactionId()).trim() + ", BranchQual=" + new String(id.getBranchQualifier()).trim() + (id instanceof XidImpl ? ", localId=" + ((XidImpl)id).localId : "") + "]";
        return s;
    }

    public XidImpl(int formatId, byte[] globalId, byte[] branchId, int hash, long localId) {
        this.formatId = formatId;
        this.globalId = globalId;
        this.branchId = branchId;
        this.hash = hash;
        this.localId = localId;
        this.trulyGlobalId = trulyGlobalIdsEnabled ? new GlobalId(formatId, globalId) : null;
    }

    XidImpl(byte[] globalId, byte[] branchId, int hash, long localId) {
        this.formatId = 257;
        this.globalId = globalId;
        this.branchId = branchId;
        this.hash = hash;
        this.localId = localId;
        this.trulyGlobalId = trulyGlobalIdsEnabled ? new GlobalId(257, globalId, hash) : null;
    }

    public XidImpl(XidImpl xidImpl, byte[] branchId) {
        this.formatId = xidImpl.formatId;
        this.globalId = xidImpl.globalId;
        this.branchId = branchId;
        this.hash = xidImpl.hash;
        this.localId = xidImpl.localId;
        this.trulyGlobalId = trulyGlobalIdsEnabled ? xidImpl.trulyGlobalId : null;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    public byte[] getBranchQualifier() {
        if (this.branchId.length == 0) {
            return this.branchId;
        }
        return (byte[])this.branchId.clone();
    }

    public int getFormatId() {
        return this.formatId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XidImpl) {
            int i;
            XidImpl other = (XidImpl)obj;
            if (this.formatId != other.formatId || this.globalId.length != other.globalId.length || this.branchId.length != other.branchId.length) {
                return false;
            }
            for (i = 0; i < this.globalId.length; ++i) {
                if (this.globalId[i] == other.globalId[i]) continue;
                return false;
            }
            for (i = 0; i < this.branchId.length; ++i) {
                if (this.branchId[i] == other.branchId[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return XidImpl.toString(this);
    }

    public long getLocalIdValue() {
        return this.localId;
    }

    public LocalId getLocalId() {
        return new LocalId(this.localId);
    }

    public GlobalId getTrulyGlobalId() {
        return this.trulyGlobalId;
    }

    public boolean sameTransaction(XidImpl other) {
        if (other == this) {
            return true;
        }
        if (this.formatId != other.formatId || this.globalId.length != other.globalId.length) {
            return false;
        }
        for (int i = 0; i < this.globalId.length; ++i) {
            if (this.globalId[i] == other.globalId[i]) continue;
            return false;
        }
        return true;
    }

    byte[] getInternalGlobalTransactionId() {
        return this.globalId;
    }
}

