/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;

public abstract class SOAPConnectionFactory {
    private static final String JBOSS_SOAP_CONN_FACTORY = "org.jboss.webservice.soap.SOAPConnectionFactoryImpl";
    private static final String AXIS_SOAP_CONN_FACTORY = "org.apache.axis.soap.SOAPConnectionFactoryImpl";

    public static SOAPConnectionFactory newInstance() throws SOAPException, UnsupportedOperationException {
        SOAPConnectionFactory factory = null;
        String factoryName = null;
        try {
            factoryName = System.getProperty("javax.xml.soap.SOAPConnectionFactory", JBOSS_SOAP_CONN_FACTORY);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = null;
            try {
                factoryClass = loader.loadClass(factoryName);
            }
            catch (ClassNotFoundException ignore) {
                factoryName = AXIS_SOAP_CONN_FACTORY;
                factoryClass = loader.loadClass(factoryName);
            }
            factory = (SOAPConnectionFactory)factoryClass.newInstance();
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create SOAPConnectionFactory: " + factoryName, t);
        }
        return factory;
    }

    public abstract SOAPConnection createConnection() throws SOAPException;
}

