/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.jboss.deployment.spi.JBossTarget;
import org.jboss.deployment.spi.JarUtils;
import org.jboss.logging.Logger;

public class LocalhostTarget
implements JBossTarget {
    private static final Logger log = Logger.getLogger((Class)LocalhostTarget.class);

    public String getDescription() {
        return "JBoss localhost target";
    }

    public String getName() {
        return "localhost";
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error((Object)"Cannot obtain localhost", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(TargetModuleID targetModuleID) throws Exception {
        String deployDir = this.getDeploydir();
        FileOutputStream outs = null;
        FileInputStream ins = null;
        try {
            File deployableFile = new File(targetModuleID.getModuleID());
            File targetFile = new File(deployDir + "/" + deployableFile.getName());
            log.info((Object)("Writing deployableFile: " + deployableFile.getAbsolutePath() + " to: " + targetFile.getAbsolutePath()));
            outs = new FileOutputStream(targetFile);
            ins = new FileInputStream(deployableFile);
            JarUtils.copyStream(outs, ins);
            log.info((Object)"Waiting 10 seconds for deploy to finish...");
            Thread.sleep(10000L);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (outs != null) {
                    outs.close();
                }
                if (ins != null) {
                    ins.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (outs != null) {
                outs.close();
            }
            if (ins != null) {
                ins.close();
            }
        }
        catch (IOException e) {}
    }

    public void start(TargetModuleID targetModuleID) throws Exception {
    }

    public void stop(TargetModuleID targetModuleID) throws Exception {
    }

    public void undeploy(TargetModuleID targetModuleID) throws Exception {
        String deployDir = this.getDeploydir();
        File file = new File(deployDir + "/" + targetModuleID.getModuleID());
        file.delete();
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType) throws TargetException {
        return null;
    }

    private String getDeploydir() {
        String deployDir = System.getProperty("jboss.deploy.dir");
        if (deployDir == null) {
            String j2eeHome = System.getProperty("J2EE_HOME");
            if (j2eeHome == null) {
                throw new RuntimeException("Cannot obtain system property: jboss.deploy.dir or J2EE_HOME");
            }
            deployDir = j2eeHome + "/server/cts/deploy";
        }
        log.info((Object)("Using deploy dir: " + deployDir));
        return deployDir;
    }
}

