/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.hql.ParserHelper;
import net.sf.hibernate.hql.PreprocessingParser;
import net.sf.hibernate.impl.IteratorImpl;
import net.sf.hibernate.impl.ScrollableResultsImpl;
import net.sf.hibernate.loader.Loader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.PropertyMapping;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.ForUpdateFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.QueryJoinFragment;
import net.sf.hibernate.sql.QuerySelect;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTranslator
extends Loader {
    private final String queryString;
    private final Map typeMap = new SequencedHashMap();
    private final Map collections = new SequencedHashMap();
    private List returnedTypes = new ArrayList();
    private final List fromTypes = new ArrayList();
    private final List scalarTypes = new ArrayList();
    private final Map namedParameters = new HashMap();
    private final Map aliasNames = new HashMap();
    private final Map oneToOneOwnerNames = new HashMap();
    private final Set crossJoins = new HashSet();
    private final Map decoratedPropertyMappings = new HashMap();
    private final List scalarSelectTokens = new ArrayList();
    private final List whereTokens = new ArrayList();
    private final List havingTokens = new ArrayList();
    private final Map joins = new SequencedHashMap();
    private final List orderByTokens = new ArrayList();
    private final List groupByTokens = new ArrayList();
    private final Set querySpaces = new HashSet();
    private final Set entitiesToFetch = new HashSet();
    private Queryable[] persisters;
    private int[] owners;
    private String[] names;
    private boolean[] includeInSelect;
    private int selectLength;
    private Type[] returnTypes;
    private Type[] actualReturnTypes;
    private String[][] scalarColumnNames;
    private SessionFactoryImplementor factory;
    private Map tokenReplacements;
    private int nameCount = 0;
    private int parameterCount = 0;
    private boolean distinct = false;
    private boolean compiled;
    private String sqlString;
    private Class holderClass;
    private Constructor holderConstructor;
    private boolean hasScalars;
    private boolean shallowQuery;
    private QueryTranslator superQuery;
    private QueryableCollection collectionPersister;
    private int collectionOwnerColumn = -1;
    private String collectionOwnerName;
    private String fetchName;
    private String[] suffixes;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$hql$QueryTranslator == null ? (class$net$sf$hibernate$hql$QueryTranslator = QueryTranslator.class$("net.sf.hibernate.hql.QueryTranslator")) : class$net$sf$hibernate$hql$QueryTranslator));
    private final Map pathAliases = new HashMap();
    private final Map pathJoins = new HashMap();
    private static final Set BEFORE_CLASS_TOKENS = new HashSet();
    private static final Set NOT_AFTER_CLASS_TOKENS = new HashSet();
    static /* synthetic */ Class class$net$sf$hibernate$hql$QueryTranslator;

    public QueryTranslator(String queryString) {
        this.queryString = queryString;
    }

    void compile(QueryTranslator superquery) throws QueryException, MappingException {
        this.factory = superquery.factory;
        this.tokenReplacements = superquery.tokenReplacements;
        this.superQuery = superquery;
        this.shallowQuery = true;
        this.compile();
    }

    public synchronized void compile(SessionFactoryImplementor factory, Map replacements, boolean scalar) throws QueryException, MappingException {
        if (!this.compiled) {
            this.factory = factory;
            this.tokenReplacements = replacements;
            this.shallowQuery = scalar;
            this.compile();
        }
    }

    private void compile() throws QueryException, MappingException {
        log.trace((Object)"compiling query");
        try {
            ParserHelper.parse(new PreprocessingParser(this.tokenReplacements), this.queryString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", this);
            this.renderSQL();
        }
        catch (QueryException qe) {
            qe.setQueryString(this.queryString);
            throw qe;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.debug((Object)"unexpected query compilation problem", (Throwable)e);
            QueryException qe = new QueryException("Incorrect query syntax", e);
            qe.setQueryString(this.queryString);
            throw qe;
        }
        this.postInstantiate();
        this.compiled = true;
    }

    public Object loadSingleRow(ResultSet resultSet, SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) throws SQLException, HibernateException {
        return super.loadSingleRow(resultSet, session, queryParameters, returnProxies);
    }

    protected Loadable[] getPersisters() {
        return this.persisters;
    }

    public Type[] getReturnTypes() {
        return this.actualReturnTypes;
    }

    private String[][] getScalarColumnNames() {
        return this.scalarColumnNames;
    }

    private static void logQuery(String hql, String sql) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HQL: " + hql));
            log.debug((Object)("SQL: " + sql));
        }
    }

    void setAliasName(String alias, String name) {
        this.aliasNames.put(alias, name);
    }

    String getAliasName(String alias) {
        String name = (String)this.aliasNames.get(alias);
        if (name == null) {
            name = this.superQuery != null ? this.superQuery.getAliasName(alias) : alias;
        }
        return name;
    }

    String unalias(String path) {
        String alias = StringHelper.root(path);
        String name = this.getAliasName(alias);
        if (name != null) {
            return name + path.substring(alias.length());
        }
        return path;
    }

    void addEntityToFetch(String name, String oneToOneOwnerName) {
        this.addEntityToFetch(name);
        if (oneToOneOwnerName != null) {
            this.oneToOneOwnerNames.put(name, oneToOneOwnerName);
        }
    }

    void addEntityToFetch(String name) {
        this.entitiesToFetch.add(name);
    }

    public String getSQLString() {
        return this.sqlString;
    }

    private int nextCount() {
        int n;
        if (this.superQuery == null) {
            int n2 = this.nameCount;
            n = n2;
            this.nameCount = n2 + 1;
        } else {
            int n3 = this.superQuery.nameCount;
            n = n3;
            this.superQuery.nameCount = n3 + 1;
        }
        return n;
    }

    String createNameFor(Class type) {
        return QueryTranslator.generateAlias(type.getName(), this.nextCount());
    }

    String createNameForCollection(String role) {
        return QueryTranslator.generateAlias(role, this.nextCount());
    }

    Class getType(String name) {
        Class type = (Class)this.typeMap.get(name);
        if (type == null && this.superQuery != null) {
            type = this.superQuery.getType(name);
        }
        return type;
    }

    String getRole(String name) {
        String role = (String)this.collections.get(name);
        if (role == null && this.superQuery != null) {
            role = this.superQuery.getRole(name);
        }
        return role;
    }

    boolean isName(String name) {
        return this.aliasNames.containsKey(name) || this.typeMap.containsKey(name) || this.collections.containsKey(name) || this.superQuery != null && this.superQuery.isName(name);
    }

    PropertyMapping getPropertyMapping(String name) throws QueryException {
        PropertyMapping decorator = this.getDecoratedPropertyMapping(name);
        if (decorator != null) {
            return decorator;
        }
        Class type = this.getType(name);
        if (type == null) {
            String role = this.getRole(name);
            if (role == null) {
                throw new QueryException("alias not found: " + name);
            }
            return this.getCollectionPersister(role);
        }
        Queryable persister = this.getPersister(type);
        if (persister == null) {
            throw new QueryException("persistent class not found: " + type.getName());
        }
        return persister;
    }

    PropertyMapping getDecoratedPropertyMapping(String name) {
        return (PropertyMapping)this.decoratedPropertyMappings.get(name);
    }

    void decoratePropertyMapping(String name, PropertyMapping mapping) {
        this.decoratedPropertyMappings.put(name, mapping);
    }

    Queryable getPersisterForName(String name) throws QueryException {
        Class type = this.getType(name);
        Queryable persister = this.getPersister(type);
        if (persister == null) {
            throw new QueryException("persistent class not found: " + type.getName());
        }
        return persister;
    }

    Queryable getPersisterUsingImports(String className) {
        try {
            return (Queryable)this.factory.getPersister(this.factory.getImportedClassName(className));
        }
        catch (MappingException me) {
            return null;
        }
    }

    Queryable getPersister(Class clazz) throws QueryException {
        try {
            return (Queryable)this.factory.getPersister(clazz);
        }
        catch (Exception e) {
            throw new QueryException("persistent class not found: " + clazz.getName());
        }
    }

    QueryableCollection getCollectionPersister(String role) throws QueryException {
        try {
            return (QueryableCollection)this.factory.getCollectionPersister(role);
        }
        catch (ClassCastException cce) {
            throw new QueryException("collection role is not queryable: " + role);
        }
        catch (Exception e) {
            throw new QueryException("collection role not found: " + role);
        }
    }

    void addType(String name, Class type) {
        this.typeMap.put(name, type);
    }

    void addCollection(String name, String role) {
        this.collections.put(name, role);
    }

    void addFrom(String name, Class type, JoinFragment join) {
        this.addType(name, type);
        this.addFrom(name, join);
    }

    void addFromCollection(String name, String collectionRole, JoinFragment join) {
        this.addCollection(name, collectionRole);
        this.addJoin(name, join);
    }

    void addFrom(String name, JoinFragment join) {
        this.fromTypes.add(name);
        this.addJoin(name, join);
    }

    void addFromClass(String name, Queryable classPersister) {
        QueryJoinFragment ojf = this.createJoinFragment(false);
        ((JoinFragment)ojf).addCrossJoin(classPersister.getTableName(), name);
        this.crossJoins.add(name);
        this.addFrom(name, classPersister.getMappedClass(), ojf);
    }

    void addSelectClass(String name) {
        this.returnedTypes.add(name);
    }

    void addSelectScalar(Type type) {
        this.scalarTypes.add(type);
    }

    void appendWhereToken(String token) {
        this.whereTokens.add(token);
    }

    void appendHavingToken(String token) {
        this.havingTokens.add(token);
    }

    void appendOrderByToken(String token) {
        this.orderByTokens.add(token);
    }

    void appendGroupByToken(String token) {
        this.groupByTokens.add(token);
    }

    void appendScalarSelectToken(String token) {
        this.scalarSelectTokens.add(token);
    }

    void appendScalarSelectTokens(String[] tokens) {
        this.scalarSelectTokens.add(tokens);
    }

    void addJoin(String name, JoinFragment newjoin) {
        JoinFragment oldjoin = (JoinFragment)this.joins.get(name);
        if (oldjoin == null) {
            this.joins.put(name, newjoin);
        } else {
            oldjoin.addCondition(newjoin.toWhereFragmentString());
            if (oldjoin.toFromFragmentString().indexOf(newjoin.toFromFragmentString().trim()) < 0) {
                throw new AssertionFailure("bug in query parser: " + this.queryString);
            }
        }
    }

    void addNamedParameter(String name) {
        if (this.superQuery != null) {
            this.superQuery.addNamedParameter(name);
        }
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((ArrayList)o).add(loc);
        }
    }

    protected int[] getNamedParameterLocs(String name) throws QueryException {
        Object o = this.namedParameters.get(name);
        if (o == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name);
            qe.setQueryString(this.queryString);
            throw qe;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return ArrayHelper.toIntArray((ArrayList)o);
    }

    private static String scalarName(int x, int y) {
        return "" + 'x' + x + '_' + y + '_';
    }

    private void renderSQL() throws QueryException, MappingException {
        PropertyMapping p;
        int rtsize;
        if (this.returnedTypes.size() == 0 && this.scalarTypes.size() == 0) {
            this.returnedTypes = this.fromTypes;
            rtsize = this.returnedTypes.size();
        } else {
            rtsize = this.returnedTypes.size();
            Iterator iter = this.entitiesToFetch.iterator();
            while (iter.hasNext()) {
                this.returnedTypes.add(iter.next());
            }
        }
        int size = this.returnedTypes.size();
        this.persisters = new Queryable[size];
        this.names = new String[size];
        this.owners = new int[size];
        this.suffixes = new String[size];
        this.includeInSelect = new boolean[size];
        for (int i = 0; i < size; ++i) {
            String oneToOneOwner;
            String name = (String)this.returnedTypes.get(i);
            this.persisters[i] = this.getPersisterForName(name);
            this.suffixes[i] = size == 1 ? "" : Integer.toString(i) + '_';
            this.names[i] = name;
            boolean bl = this.includeInSelect[i] = !this.entitiesToFetch.contains(name);
            if (this.includeInSelect[i]) {
                ++this.selectLength;
            }
            if (name.equals(this.collectionOwnerName)) {
                this.collectionOwnerColumn = i;
            }
            this.owners[i] = (oneToOneOwner = (String)this.oneToOneOwnerNames.get(name)) == null ? -1 : this.returnedTypes.indexOf(oneToOneOwner);
        }
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
        String scalarSelect = this.renderScalarSelect();
        int scalarSize = this.scalarTypes.size();
        this.hasScalars = this.scalarTypes.size() != rtsize;
        this.returnTypes = new Type[scalarSize];
        for (int i = 0; i < scalarSize; ++i) {
            this.returnTypes[i] = (Type)this.scalarTypes.get(i);
        }
        QuerySelect sql = new QuerySelect(this.factory.getDialect());
        sql.setDistinct(this.distinct);
        if (!this.shallowQuery) {
            this.renderIdentifierSelect(sql);
            this.renderPropertiesSelect(sql);
        }
        if (this.collectionPersister != null) {
            sql.addSelectFragmentString(this.collectionPersister.selectFragment(this.fetchName));
        }
        if (this.hasScalars || this.shallowQuery) {
            sql.addSelectFragmentString(scalarSelect);
        }
        this.mergeJoins(sql.getJoinFragment());
        sql.setWhereTokens(this.whereTokens.iterator());
        sql.setGroupByTokens(this.groupByTokens.iterator());
        sql.setHavingTokens(this.havingTokens.iterator());
        sql.setOrderByTokens(this.orderByTokens.iterator());
        if (this.collectionPersister != null && this.collectionPersister.hasOrdering()) {
            sql.addOrderBy(this.collectionPersister.getSQLOrderByString(this.fetchName));
        }
        this.scalarColumnNames = QueryTranslator.generateColumnNames(this.returnTypes, this.factory);
        Iterator<Object> iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            p = this.getCollectionPersister((String)iter.next());
            this.addQuerySpace(p.getCollectionSpace());
        }
        iter = this.typeMap.keySet().iterator();
        while (iter.hasNext()) {
            p = this.getPersisterForName((String)iter.next());
            Serializable[] spaces = p.getPropertySpaces();
            for (int i = 0; i < spaces.length; ++i) {
                this.addQuerySpace(spaces[i]);
            }
        }
        this.sqlString = sql.toQueryString();
        if (this.holderClass != null) {
            this.holderConstructor = ReflectHelper.getConstructor(this.holderClass, this.returnTypes);
        }
        if (this.hasScalars) {
            this.actualReturnTypes = this.returnTypes;
        } else {
            this.actualReturnTypes = new Type[this.selectLength];
            int j = 0;
            for (int i = 0; i < this.persisters.length; ++i) {
                if (!this.includeInSelect[i]) continue;
                this.actualReturnTypes[j++] = Hibernate.entity(this.persisters[i].getMappedClass());
            }
        }
    }

    private void renderIdentifierSelect(QuerySelect sql) {
        int size = this.returnedTypes.size();
        for (int k = 0; k < size; ++k) {
            String name = (String)this.returnedTypes.get(k);
            String suffix = size == 1 ? "" : Integer.toString(k) + '_';
            sql.addSelectFragmentString(this.persisters[k].identifierSelectFragment(name, suffix));
        }
    }

    private void renderPropertiesSelect(QuerySelect sql) {
        int size = this.returnedTypes.size();
        for (int k = 0; k < size; ++k) {
            String suffix = size == 1 ? "" : Integer.toString(k) + '_';
            String name = (String)this.returnedTypes.get(k);
            sql.addSelectFragmentString(this.persisters[k].propertySelectFragment(name, suffix));
        }
    }

    private String renderScalarSelect() {
        boolean isSubselect = this.superQuery != null;
        StringBuffer buf = new StringBuffer(20);
        if (this.scalarTypes.size() == 0) {
            int size = this.returnedTypes.size();
            for (int k = 0; k < size; ++k) {
                this.scalarTypes.add(Hibernate.entity(this.persisters[k].getMappedClass()));
                String[] idColumnNames = this.persisters[k].getIdentifierColumnNames();
                for (int i = 0; i < idColumnNames.length; ++i) {
                    buf.append(this.returnedTypes.get(k)).append('.').append(idColumnNames[i]);
                    if (!isSubselect) {
                        buf.append(" as ").append(QueryTranslator.scalarName(k, i));
                    }
                    if (i == idColumnNames.length - 1 && k == size - 1) continue;
                    buf.append(", ");
                }
            }
        } else {
            Iterator iter = this.scalarSelectTokens.iterator();
            int c = 0;
            boolean nolast = false;
            int parenCount = 0;
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next instanceof String) {
                    String token = (String)next;
                    if ("(".equals(token)) {
                        ++parenCount;
                    } else if (")".equals(token)) {
                        --parenCount;
                    }
                    String lc = token.toLowerCase();
                    if (lc.equals(", ")) {
                        if (nolast) {
                            nolast = false;
                        } else if (!isSubselect && parenCount == 0) {
                            buf.append(" as ").append(QueryTranslator.scalarName(c++, 0));
                        }
                    }
                    buf.append(token);
                    if (!lc.equals("distinct") && !lc.equals("all")) continue;
                    buf.append(' ');
                    continue;
                }
                nolast = true;
                String[] tokens = (String[])next;
                for (int i = 0; i < tokens.length; ++i) {
                    buf.append(tokens[i]);
                    if (!isSubselect) {
                        buf.append(" as ").append(QueryTranslator.scalarName(c, i));
                    }
                    if (i == tokens.length - 1) continue;
                    buf.append(", ");
                }
                ++c;
            }
            if (!isSubselect && !nolast) {
                buf.append(" as ").append(QueryTranslator.scalarName(c++, 0));
            }
        }
        return buf.toString();
    }

    private void mergeJoins(JoinFragment ojf) throws MappingException, QueryException {
        Iterator iter = this.joins.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            String name = (String)me.getKey();
            JoinFragment join = (JoinFragment)me.getValue();
            if (this.typeMap.containsKey(name)) {
                Queryable p = this.getPersisterForName(name);
                boolean includeSubclasses = this.returnedTypes.contains(name) && !this.isShallowQuery();
                boolean isCrossJoin = this.crossJoins.contains(name);
                ojf.addFragment(join);
                ojf.addJoins(p.fromJoinFragment(name, isCrossJoin, includeSubclasses), p.queryWhereFragment(name, isCrossJoin, includeSubclasses));
                continue;
            }
            if (!this.collections.containsKey(name)) continue;
            ojf.addFragment(join);
        }
    }

    public final Set getQuerySpaces() {
        return this.querySpaces;
    }

    boolean isShallowQuery() {
        return this.shallowQuery;
    }

    void addQuerySpace(Serializable table) {
        this.querySpaces.add(table);
        if (this.superQuery != null) {
            this.superQuery.addQuerySpace(table);
        }
    }

    void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    boolean isSubquery() {
        return this.superQuery != null;
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    void setCollectionToFetch(String role, String name, String ownerName, String entityName) throws QueryException {
        this.fetchName = name;
        this.collectionPersister = this.getCollectionPersister(role);
        this.collectionOwnerName = ownerName;
        if (this.collectionPersister.getElementType().isEntityType()) {
            this.addEntityToFetch(entityName);
        }
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    protected void addFromAssociation(String elementName, String collectionRole) throws QueryException {
        Type collectionElementType = this.getCollectionPersister(collectionRole).getElementType();
        if (!collectionElementType.isEntityType()) {
            throw new QueryException("collection of values in filter: " + elementName);
        }
        QueryableCollection persister = this.getCollectionPersister(collectionRole);
        String[] keyColumnNames = persister.getKeyColumnNames();
        QueryJoinFragment join = this.createJoinFragment(false);
        String collectionName = persister.isOneToMany() ? elementName : this.createNameForCollection(collectionRole);
        ((JoinFragment)join).addCrossJoin(persister.getTableName(), collectionName);
        if (!persister.isOneToMany()) {
            this.addCollection(collectionName, collectionRole);
            Queryable p = (Queryable)persister.getElementPersister();
            String[] idColumnNames = p.getIdentifierColumnNames();
            String[] eltColumnNames = persister.getElementColumnNames();
            ((JoinFragment)join).addJoin(p.getTableName(), elementName, StringHelper.qualify(collectionName, eltColumnNames), idColumnNames, 0);
        }
        ((JoinFragment)join).addCondition(collectionName, keyColumnNames, " = ?");
        if (persister.hasWhere()) {
            ((JoinFragment)join).addCondition(persister.getSQLWhereString(collectionName));
        }
        EntityType elemType = (EntityType)collectionElementType;
        this.addFrom(elementName, elemType.getAssociatedClass(), join);
    }

    String getPathAlias(String path) {
        return (String)this.pathAliases.get(path);
    }

    JoinFragment getPathJoin(String path) {
        return (JoinFragment)this.pathJoins.get(path);
    }

    void addPathAliasAndJoin(String path, String alias, JoinFragment join) {
        this.pathAliases.put(path, alias);
        this.pathJoins.put(path, join.copy());
    }

    protected int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                for (int i = 0; i < locs.length; ++i) {
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException, SQLException {
        QueryTranslator.logQuery(this.queryString, this.sqlString);
        return this.list(session, queryParameters, this.getQuerySpaces(), this.actualReturnTypes);
    }

    public Iterator iterate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException, SQLException {
        QueryTranslator.logQuery(this.queryString, this.sqlString);
        PreparedStatement st = this.prepareQueryStatement(this.applyLocks(this.getSQLString(), queryParameters.getLockModes(), session.getFactory().getDialect()), queryParameters, false, session);
        ResultSet rs = this.getResultSet(st, queryParameters.getRowSelection(), session);
        return new IteratorImpl(rs, st, session, this.returnTypes, this.getScalarColumnNames(), this.holderClass);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException, SQLException {
        QueryTranslator.logQuery(this.queryString, this.sqlString);
        PreparedStatement st = this.prepareQueryStatement(this.applyLocks(this.getSQLString(), queryParameters.getLockModes(), session.getFactory().getDialect()), queryParameters, true, session);
        ResultSet rs = this.getResultSet(st, queryParameters.getRowSelection(), session);
        return new ScrollableResultsImpl(rs, st, session, this, queryParameters, this.returnTypes, this.getScalarColumnNames(), this.holderClass);
    }

    public static String[] concreteQueries(String query, SessionFactoryImplementor factory) {
        String[] tokens = StringHelper.split(" \n\r\f\t(),", query, true);
        if (tokens.length == 0) {
            return new String[]{query};
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        StringBuffer templateQuery = new StringBuffer(40);
        int count = 0;
        String last = null;
        int nextIndex = 0;
        String next = null;
        templateQuery.append(tokens[0]);
        for (int i = 1; i < tokens.length; ++i) {
            String token;
            if (!ParserHelper.isWhitespace(tokens[i - 1])) {
                last = tokens[i - 1].toLowerCase();
            }
            if (!ParserHelper.isWhitespace(token = tokens[i]) || last == null) {
                Class clazz;
                if (nextIndex <= i) {
                    for (nextIndex = i + 1; nextIndex < tokens.length && ParserHelper.isWhitespace(next = tokens[nextIndex].toLowerCase()); ++nextIndex) {
                    }
                }
                if (Character.isJavaIdentifierStart(token.charAt(0)) && (BEFORE_CLASS_TOKENS.contains(last) && !NOT_AFTER_CLASS_TOKENS.contains(next) || "class".equals(last)) && (clazz = QueryTranslator.getImportedClass(token, factory)) != null) {
                    String[] implementors = factory.getImplementors(clazz);
                    String placeholder = "$clazz" + count++ + "$";
                    if (implementors != null) {
                        placeholders.add(placeholder);
                        replacements.add(implementors);
                    }
                    token = placeholder;
                }
            }
            templateQuery.append(token);
        }
        String[] results = StringHelper.multiply(templateQuery.toString(), placeholders.iterator(), replacements.iterator());
        if (results.length == 0) {
            log.warn((Object)("no persistent classes found for query class: " + query));
        }
        return results;
    }

    Class getImportedClass(String name) {
        return QueryTranslator.getImportedClass(name, this.factory);
    }

    private static Class getImportedClass(String name, SessionFactoryImplementor factory) {
        try {
            return ReflectHelper.classForName(factory.getImportedClassName(name));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String[][] generateColumnNames(Type[] types, SessionFactoryImplementor f) throws MappingException {
        String[][] columnNames = new String[types.length][];
        for (int i = 0; i < types.length; ++i) {
            int span = types[i].getColumnSpan(f);
            columnNames[i] = new String[span];
            for (int j = 0; j < span; ++j) {
                columnNames[i][j] = QueryTranslator.scalarName(i, j);
            }
        }
        return columnNames;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        row = this.toResultRow(row);
        if (this.hasScalars) {
            String[][] scalarColumns = this.getScalarColumnNames();
            int queryCols = this.returnTypes.length;
            if (this.holderClass == null && queryCols == 1) {
                return this.returnTypes[0].nullSafeGet(rs, scalarColumns[0], session, null);
            }
            row = new Object[queryCols];
            for (int i = 0; i < queryCols; ++i) {
                row[i] = this.returnTypes[i].nullSafeGet(rs, scalarColumns[i], session, null);
            }
            return row;
        }
        if (this.holderClass == null) {
            return row.length == 1 ? row[0] : row;
        }
        return row;
    }

    protected List getResultList(List results) throws QueryException {
        if (this.holderClass != null) {
            for (int i = 0; i < results.size(); ++i) {
                Object[] row = (Object[])results.get(i);
                try {
                    results.set(i, this.holderConstructor.newInstance(row));
                    continue;
                }
                catch (Exception e) {
                    throw new QueryException("could not instantiate: " + this.holderClass, e);
                }
            }
        }
        return results;
    }

    private Object[] toResultRow(Object[] row) {
        if (this.selectLength == row.length) {
            return row;
        }
        Object[] result = new Object[this.selectLength];
        int j = 0;
        for (int i = 0; i < row.length; ++i) {
            if (!this.includeInSelect[i]) continue;
            result[j++] = row[i];
        }
        return result;
    }

    QueryJoinFragment createJoinFragment(boolean useThetaStyleInnerJoins) {
        return new QueryJoinFragment(this.factory.getDialect(), useThetaStyleInnerJoins);
    }

    void setHolderClass(Class clazz) {
        this.holderClass = clazz;
    }

    protected LockMode[] getLockModes(Map lockModes) {
        HashMap nameLockModes = new HashMap();
        if (lockModes != null) {
            Iterator iter = lockModes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry me = iter.next();
                nameLockModes.put(this.getAliasName((String)me.getKey()), me.getValue());
            }
        }
        LockMode[] lockModeArray = new LockMode[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            LockMode lm = (LockMode)nameLockModes.get(this.names[i]);
            if (lm == null) {
                lm = LockMode.NONE;
            }
            lockModeArray[i] = lm;
        }
        return lockModeArray;
    }

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sql;
        }
        HashMap aliasedLockModes = new HashMap();
        Iterator iter = lockModes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            aliasedLockModes.put(this.getAliasName((String)me.getKey()), me.getValue());
        }
        return sql + new ForUpdateFragment(aliasedLockModes).toFragmentString(dialect);
    }

    protected boolean upgradeLocks() {
        return true;
    }

    protected int getCollectionOwner() {
        return this.collectionOwnerColumn;
    }

    protected void setFactory(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected boolean isCompiled() {
        return this.compiled;
    }

    public String toString() {
        return this.queryString;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BEFORE_CLASS_TOKENS.add("from");
        BEFORE_CLASS_TOKENS.add(",");
        NOT_AFTER_CLASS_TOKENS.add("in");
        NOT_AFTER_CLASS_TOKENS.add("from");
        NOT_AFTER_CLASS_TOKENS.add(")");
    }
}

