/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.JVM;
import org.jboss.management.j2ee.LocalJBossServerDomainMBean;
import org.jboss.management.j2ee.factory.ManagedObjectFactory;
import org.jboss.management.j2ee.factory.ManagedObjectFactoryMap;
import org.jboss.system.ServiceControllerMBean;

public class LocalJBossServerDomain
extends J2EEDomain
implements NotificationListener,
LocalJBossServerDomainMBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$LocalJBossServerDomain == null ? (class$org$jboss$management$j2ee$LocalJBossServerDomain = LocalJBossServerDomain.class$("org.jboss.management.j2ee.LocalJBossServerDomain")) : class$org$jboss$management$j2ee$LocalJBossServerDomain));
    private ObjectName mainDeployer;
    private ObjectName sarDeployer;
    private ObjectName earDeployer;
    private ObjectName ejbDeployer;
    private ObjectName rarDeployer;
    private ObjectName jcaCMDeployer;
    private ObjectName warDeployer;
    private ObjectName jmsService;
    private ObjectName jndiService;
    private ObjectName jtaService;
    private ObjectName userTxService;
    private ObjectName mailService;
    private ObjectName rmiiiopService;
    private ManagedObjectFactoryMap managedObjFactoryMap;
    private Class managedObjFactoryMapClass = class$org$jboss$management$j2ee$factory$DefaultManagedObjectFactoryMap == null ? (class$org$jboss$management$j2ee$factory$DefaultManagedObjectFactoryMap = LocalJBossServerDomain.class$("org.jboss.management.j2ee.factory.DefaultManagedObjectFactoryMap")) : class$org$jboss$management$j2ee$factory$DefaultManagedObjectFactoryMap;
    static /* synthetic */ Class class$org$jboss$management$j2ee$LocalJBossServerDomain;
    static /* synthetic */ Class class$org$jboss$management$j2ee$factory$DefaultManagedObjectFactoryMap;

    public LocalJBossServerDomain() throws MalformedObjectNameException, InvalidParentException {
        super("jboss.management.local");
    }

    public ObjectName getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(ObjectName name) {
        this.mainDeployer = name;
    }

    public ObjectName getSARDeployer() {
        return this.sarDeployer;
    }

    public void setSARDeployer(ObjectName name) {
        this.sarDeployer = name;
    }

    public ObjectName getEARDeployer() {
        return this.earDeployer;
    }

    public void setEARDeployer(ObjectName name) {
        this.earDeployer = name;
    }

    public ObjectName getEJBDeployer() {
        return this.ejbDeployer;
    }

    public void setEJBDeployer(ObjectName name) {
        this.ejbDeployer = name;
    }

    public ObjectName getRARDeployer() {
        return this.rarDeployer;
    }

    public void setRARDeployer(ObjectName name) {
        this.rarDeployer = name;
    }

    public ObjectName getCMDeployer() {
        return this.jcaCMDeployer;
    }

    public void setCMDeployer(ObjectName name) {
        this.jcaCMDeployer = name;
    }

    public ObjectName getWARDeployer() {
        return this.warDeployer;
    }

    public void setWARDeployer(ObjectName name) {
        this.warDeployer = name;
    }

    public ObjectName getJMSService() {
        return this.jmsService;
    }

    public void setJMSService(ObjectName name) {
        this.jmsService = name;
    }

    public ObjectName getJNDIService() {
        return this.jndiService;
    }

    public void setJNDIService(ObjectName name) {
        this.jndiService = name;
    }

    public ObjectName getJTAService() {
        return this.jtaService;
    }

    public void setJTAService(ObjectName name) {
        this.jtaService = name;
    }

    public ObjectName getMailService() {
        return this.mailService;
    }

    public void setMailService(ObjectName name) {
        this.mailService = name;
    }

    public ObjectName getUserTransactionService() {
        return this.userTxService;
    }

    public void setUserTransactionService(ObjectName name) {
        this.userTxService = name;
    }

    public ObjectName getRMI_IIOPService() {
        return this.rmiiiopService;
    }

    public void setRMI_IIOPService(ObjectName name) {
        this.rmiiiopService = name;
    }

    public Class getManagementObjFactoryMapClass() {
        return this.managedObjFactoryMapClass;
    }

    public void setManagementObjFactoryMapClass(Class cls) {
        this.managedObjFactoryMapClass = cls;
    }

    public void handleNotification(Notification msg, Object handback) {
        MBeanServer mbeanServer = this.getServer();
        if (this.managedObjFactoryMap == null || mbeanServer == null) {
            return;
        }
        log.debug((Object)("handleNotification: " + msg));
        String type = msg.getType();
        Object userData = msg.getUserData();
        try {
            if (type.equals(" org.jboss.system.ServiceMBean.create")) {
                ManagedObjectFactory factory = this.managedObjFactoryMap.getFactory(msg);
                if (factory != null) {
                    factory.create(mbeanServer, userData);
                }
            } else if (type.equals(" org.jboss.system.ServiceMBean.destroy")) {
                ManagedObjectFactory factory = this.managedObjFactoryMap.getFactory(msg);
                if (factory != null) {
                    factory.destroy(mbeanServer, userData);
                }
            } else if (type.equals("org.jboss.deployment.SubDeployer.start")) {
                ManagedObjectFactory factory = this.managedObjFactoryMap.getFactory(msg);
                if (factory != null) {
                    factory.create(mbeanServer, userData);
                }
            } else if (type.equals("org.jboss.deployment.SubDeployer.destroy")) {
                ManagedObjectFactory factory = this.managedObjFactoryMap.getFactory(msg);
                if (factory != null) {
                    DeploymentInfo di = (DeploymentInfo)msg.getUserData();
                    factory.destroy(mbeanServer, di);
                }
            } else if (type.equals("org.jboss.deployment.MainDeployer.addDeployer")) {
                ObjectName deployerName = (ObjectName)msg.getUserData();
                this.registerWithDeployer(deployerName);
            } else if (type.equals("org.jboss.deployment.MainDeployer.removeDeployer")) {
                ObjectName deployerName = (ObjectName)msg.getUserData();
                this.unregisterWithDeployer(deployerName);
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to handle event", t);
        }
    }

    public void postCreation() {
        MBeanServer server = this.getServer();
        this.setupJ2EEMBeans(server);
        this.registerWithController(server);
    }

    public String toString() {
        return "LocalJBossServerDomain { " + super.toString() + " } []";
    }

    protected void createService() throws Exception {
        this.populateFactoryMap();
        MBeanServer server = this.getServer();
        this.registerWithCurrentDeployers(server);
    }

    protected void destroyService() throws Exception {
        MBeanServer server = this.getServer();
        this.unregisterWithCurrentDeployers(server);
        this.cleanupLeftoverMBeans(server);
    }

    protected void preDestruction() {
        MBeanServer server = this.getServer();
        this.unregisterWithController(server);
    }

    protected void registerWithDeployer(ObjectName deployerName) {
        log.debug((Object)("Registering as listener of deployer: " + deployerName));
        try {
            this.getServer().addNotificationListener(deployerName, this, null, null);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to register with deployer: " + deployerName), (Throwable)e);
        }
    }

    protected void unregisterWithDeployer(ObjectName deployerName) {
        log.debug((Object)("Unregistering as listener of deployer: " + deployerName));
        try {
            this.getServer().removeNotificationListener(deployerName, this);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to unregister with deployer: " + deployerName), (Throwable)e);
        }
    }

    private void populateFactoryMap() throws Exception {
        this.managedObjFactoryMap = (ManagedObjectFactoryMap)this.managedObjFactoryMapClass.newInstance();
        this.managedObjFactoryMap.setSARDeployer(this.sarDeployer);
        this.managedObjFactoryMap.setEARDeployer(this.earDeployer);
        this.managedObjFactoryMap.setEJBDeployer(this.ejbDeployer);
        this.managedObjFactoryMap.setRARDeployer(this.rarDeployer);
        this.managedObjFactoryMap.setCMDeployer(this.jcaCMDeployer);
        this.managedObjFactoryMap.setWARDeployer(this.warDeployer);
        this.managedObjFactoryMap.setJMSResource(this.jmsService);
        this.managedObjFactoryMap.setJNDIResource(this.jndiService);
        this.managedObjFactoryMap.setJTAResource(this.jtaService);
        this.managedObjFactoryMap.setJTAResource(this.userTxService);
        this.managedObjFactoryMap.setJavaMailResource(this.mailService);
        this.managedObjFactoryMap.setRMI_IIOPResource(this.rmiiiopService);
    }

    private void setupJ2EEMBeans(MBeanServer mbeanServer) {
        try {
            log.debug((Object)"setupJ2EEMBeans(), create J2EEServer instance");
            Package pkg = Package.getPackage("org.jboss");
            String vendor = pkg.getSpecificationVendor();
            String version = pkg.getImplementationVersion();
            J2EEServer j2eeServer = new J2EEServer("Local", this.getObjectName(), vendor, version);
            ObjectName lServer = j2eeServer.getObjectName();
            mbeanServer.registerMBean(j2eeServer, lServer);
            String hostName = "localhost";
            try {
                InetAddress lLocalHost = InetAddress.getLocalHost();
                hostName = lLocalHost.getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
            JVM jvm = new JVM("localhost", lServer, System.getProperty("java.version"), System.getProperty("java.vendor"), hostName);
            ObjectName jvmName = jvm.getObjectName();
            mbeanServer.registerMBean(jvm, jvmName);
        }
        catch (JMException jme) {
            log.debug((Object)"setupJ2EEMBeans - unexpected JMException", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"setupJ2EEMBeans - unexpected exception", (Throwable)e);
        }
    }

    private void registerWithController(MBeanServer mbeanServer) {
        try {
            mbeanServer.addNotificationListener(ServiceControllerMBean.OBJECT_NAME, this, null, null);
            log.debug((Object)("Registered as listener of: " + ServiceControllerMBean.OBJECT_NAME));
        }
        catch (JMException jme) {
            log.debug((Object)"unexpected exception", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"unexpected exception", (Throwable)e);
        }
    }

    private void unregisterWithController(MBeanServer mbeanServer) {
        try {
            mbeanServer.removeNotificationListener(ServiceControllerMBean.OBJECT_NAME, this);
            log.debug((Object)("UNRegistered as listener of: " + ServiceControllerMBean.OBJECT_NAME));
        }
        catch (JMException jme) {
            log.debug((Object)"unexpected exception", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"unexpected exception", (Throwable)e);
        }
    }

    private void registerWithCurrentDeployers(MBeanServer mbeanServer) throws Exception {
        log.debug((Object)("Registering with all deployers, mainDeployer=" + this.mainDeployer));
        mbeanServer.addNotificationListener(this.mainDeployer, this, null, null);
        log.debug((Object)"Getting current deployers");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Collection deployers = (Collection)mbeanServer.invoke(this.mainDeployer, "listDeployers", args, sig);
        Iterator iter = deployers.iterator();
        while (iter.hasNext()) {
            ObjectName name = (ObjectName)iter.next();
            this.registerWithDeployer(name);
        }
    }

    private void unregisterWithCurrentDeployers(MBeanServer mbeanServer) throws Exception {
        log.debug((Object)("Unregistering with all deployers, mainDeployer=" + this.mainDeployer));
        mbeanServer.removeNotificationListener(this.mainDeployer, this);
        log.debug((Object)"Getting current deployers");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Collection deployers = (Collection)mbeanServer.invoke(this.mainDeployer, "listDeployers", args, sig);
        Iterator iter = deployers.iterator();
        while (iter.hasNext()) {
            ObjectName name = (ObjectName)iter.next();
            this.unregisterWithDeployer(name);
        }
    }

    private void cleanupLeftoverMBeans(MBeanServer mbeanServer) throws Exception {
        ObjectName myName = this.getServiceName();
        String domain = myName.getDomain();
        ObjectName domainName = new ObjectName(domain + ":*");
        Set<ObjectName> domainNames = mbeanServer.queryNames(domainName, null);
        log.debug((Object)("Found " + domainNames.size() + " domain mbeans"));
        Iterator<ObjectName> domainIter = domainNames.iterator();
        while (domainIter.hasNext()) {
            try {
                ObjectName name = domainIter.next();
                if (name.equals(myName)) continue;
                this.server.unregisterMBean(name);
            }
            catch (MBeanException ignore) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

