/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.server.ntlm;

import cryptix.jce.provider.CryptixCrypto;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.text.DecimalFormat;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLM {
    protected static final byte[] MAGIC = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$server$ntlm$NTLM == null ? (class$at$tugraz$genome$usermanagement$server$ntlm$NTLM = NTLM.class$("at.tugraz.genome.usermanagement.server.ntlm.NTLM")) : class$at$tugraz$genome$usermanagement$server$ntlm$NTLM));
    private static final char[] bcdLookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$ntlm$NTLM;

    protected NTLM() {
    }

    protected static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    protected static byte getLoByte(char c) {
        return (byte)c;
    }

    protected static byte getHiByte(char c) {
        return (byte)(c >>> 8 & 0xFF);
    }

    protected static short swapBytes(short s) {
        return (short)(s << 8 & 0xFF00 | s >>> 8 & 0xFF);
    }

    protected static Key computeDESKey(byte[] keyData, int offset) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] desKeyData = new byte[8];
        int[] k = new int[7];
        int i = 0;
        while (i < 7) {
            k[i] = NTLM.unsignedByteToInt(keyData[offset + i]);
            ++i;
        }
        desKeyData[0] = (byte)(k[0] >>> 1);
        desKeyData[1] = (byte)((k[0] & 1) << 6 | k[1] >>> 2);
        desKeyData[2] = (byte)((k[1] & 3) << 5 | k[2] >>> 3);
        desKeyData[3] = (byte)((k[2] & 7) << 4 | k[3] >>> 4);
        desKeyData[4] = (byte)((k[3] & 0xF) << 3 | k[4] >>> 5);
        desKeyData[5] = (byte)((k[4] & 0x1F) << 2 | k[5] >>> 6);
        desKeyData[6] = (byte)((k[5] & 0x3F) << 1 | k[6] >>> 7);
        desKeyData[7] = (byte)(k[6] & 0x7F);
        int i2 = 0;
        while (i2 < 8) {
            desKeyData[i2] = (byte)(NTLM.unsignedByteToInt(desKeyData[i2]) << 1);
            ++i2;
        }
        DESKeySpec desKeySpec = new DESKeySpec(desKeyData);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
        return secretKey;
    }

    protected static byte[] encrypt(byte[] keys, byte[] plaintext) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] ciphertext = new byte[24];
        Cipher c = Cipher.getInstance("DES/ECB/NoPadding");
        Key k = NTLM.computeDESKey(keys, 0);
        c.init(1, k);
        c.doFinal(plaintext, 0, 8, ciphertext, 0);
        k = NTLM.computeDESKey(keys, 7);
        c.init(1, k);
        c.doFinal(plaintext, 0, 8, ciphertext, 8);
        k = NTLM.computeDESKey(keys, 14);
        c.init(1, k);
        c.doFinal(plaintext, 0, 8, ciphertext, 16);
        return ciphertext;
    }

    public static byte[] computeLMPassword(String password) throws IllegalArgumentException, NoSuchPaddingException, NoSuchAlgorithmException {
        if (password == null) {
            throw new IllegalArgumentException("password : null value not allowed");
        }
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            int len = password.length();
            if (len > 14) {
                len = 14;
            }
            Cipher c = Cipher.getInstance("DES/ECB/NoPadding");
            byte[] lm_pw = new byte[14];
            byte[] bytes = password.toUpperCase().getBytes();
            int i = 0;
            while (i < len) {
                lm_pw[i] = bytes[i];
                ++i;
            }
            while (i < 14) {
                lm_pw[i] = 0;
                ++i;
            }
            byte[] lm_hpw = new byte[16];
            Key k = NTLM.computeDESKey(lm_pw, 0);
            c.init(1, k);
            c.doFinal(MAGIC, 0, 8, lm_hpw, 0);
            k = NTLM.computeDESKey(lm_pw, 7);
            c.init(1, k);
            c.doFinal(MAGIC, 0, 8, lm_hpw, 8);
            return lm_hpw;
        }
        catch (InvalidKeySpecException ex) {
            return null;
        }
        catch (InvalidKeyException ex) {
            return null;
        }
        catch (BadPaddingException ex) {
            return null;
        }
        catch (IllegalBlockSizeException ex) {
            return null;
        }
        catch (ShortBufferException ex) {
            return null;
        }
    }

    public static byte[] computeNTPassword(String password) throws IllegalArgumentException, NoSuchAlgorithmException {
        if (password == null) {
            throw new IllegalArgumentException("password : null value not allowed");
        }
        Security.addProvider((Provider)new CryptixCrypto());
        int len = password.length();
        if (len > 14) {
            len = 14;
        }
        byte[] nt_pw = new byte[2 * len];
        int i = 0;
        while (i < len) {
            char ch = password.charAt(i);
            nt_pw[2 * i] = NTLM.getLoByte(ch);
            nt_pw[2 * i + 1] = NTLM.getHiByte(ch);
            ++i;
        }
        MessageDigest md = MessageDigest.getInstance("MD4");
        return md.digest(nt_pw);
    }

    public static void computeNTLMResponse(byte[] lmPassword, byte[] ntPassword, byte[] nonce, byte[] lmResponse, byte[] ntResponse) throws IllegalArgumentException, NoSuchPaddingException, NoSuchAlgorithmException {
        if (lmPassword.length != 16) {
            throw new IllegalArgumentException("lmPassword : illegal size");
        }
        if (ntPassword.length != 16) {
            throw new IllegalArgumentException("ntPassword : illegal size");
        }
        if (nonce.length != 8) {
            throw new IllegalArgumentException("nonce : illegal size");
        }
        if (lmResponse.length != 24) {
            throw new IllegalArgumentException("lmResponse : illegal size");
        }
        if (ntResponse.length != 24) {
            throw new IllegalArgumentException("ntResponse : illegal size");
        }
        try {
            byte[] lmHPw = new byte[21];
            byte[] ntHPw = new byte[21];
            System.arraycopy(lmPassword, 0, lmHPw, 0, 16);
            System.arraycopy(ntPassword, 0, ntHPw, 0, 16);
            int i = 16;
            while (i < 21) {
                lmHPw[i] = 0;
                ntHPw[i] = 0;
                ++i;
            }
            System.arraycopy(NTLM.encrypt(lmHPw, nonce), 0, lmResponse, 0, 24);
            System.arraycopy(NTLM.encrypt(ntHPw, nonce), 0, ntResponse, 0, 24);
        }
        catch (ShortBufferException ex) {
        }
        catch (IllegalBlockSizeException ex) {
        }
        catch (BadPaddingException ex) {
        }
        catch (InvalidKeySpecException ex) {
        }
        catch (InvalidKeyException ex) {}
    }

    public static byte[] formatRequest(String host, String hostDomain) throws IOException {
        hostDomain = hostDomain.toUpperCase();
        host = host.toUpperCase();
        short domainLen = (short)hostDomain.length();
        short hostLen = (short)host.length();
        short hostOff = 32;
        short domainOff = (short)(hostOff + hostLen);
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        DataOutputStream dataOut = new DataOutputStream(os);
        dataOut.writeBytes("NTLMSSP\u0000");
        dataOut.writeByte(1);
        dataOut.writeByte(0);
        dataOut.writeByte(0);
        dataOut.writeByte(0);
        dataOut.writeShort(NTLM.swapBytes((short)-19965));
        dataOut.writeShort(0);
        dataOut.writeShort(NTLM.swapBytes(domainLen));
        dataOut.writeShort(NTLM.swapBytes(domainLen));
        dataOut.writeShort(NTLM.swapBytes(domainOff));
        dataOut.writeShort(0);
        dataOut.writeShort(NTLM.swapBytes(hostLen));
        dataOut.writeShort(NTLM.swapBytes(hostLen));
        dataOut.writeShort(NTLM.swapBytes(hostOff));
        dataOut.writeShort(0);
        dataOut.write(host.getBytes());
        dataOut.write(hostDomain.getBytes());
        dataOut.flush();
        return os.toByteArray();
    }

    public static byte[] getNonce(byte[] msg) throws IllegalArgumentException {
        if (msg.length < 32) {
            throw new IllegalArgumentException("msg : illegal size");
        }
        byte[] nonce = new byte[8];
        System.arraycopy(msg, 24, nonce, 0, 8);
        return nonce;
    }

    public static byte[] formatResponse(String host, String user, String userDomain, byte[] lmPassword, byte[] ntPassword, byte[] nonce) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (host == null) {
            throw new IllegalArgumentException("host : null value not allowed");
        }
        if (user == null) {
            throw new IllegalArgumentException("user : null value not allowed");
        }
        if (userDomain == null) {
            throw new IllegalArgumentException("userDomain : null value not allowed");
        }
        if (lmPassword == null) {
            throw new IllegalArgumentException("lmPassword : null value not allowed");
        }
        if (ntPassword == null) {
            throw new IllegalArgumentException("ntPassword : null value not allowed");
        }
        if (nonce == null) {
            throw new IllegalArgumentException("nonce : null value not allowed");
        }
        if (lmPassword.length != 16) {
            throw new IllegalArgumentException("lmPassword : illegal size");
        }
        if (ntPassword.length != 16) {
            throw new IllegalArgumentException("ntPassword : illegal size");
        }
        if (nonce.length != 8) {
            throw new IllegalArgumentException("nonce : illegal size");
        }
        byte[] lmResponse = new byte[24];
        byte[] ntResponse = new byte[24];
        NTLM.computeNTLMResponse(lmPassword, ntPassword, nonce, lmResponse, ntResponse);
        userDomain = userDomain.toUpperCase();
        host = host.toUpperCase();
        short lmRespLen = 24;
        short ntRespLen = 24;
        short domainLen = (short)(2 * userDomain.length());
        short hostLen = (short)(2 * host.length());
        short userLen = (short)(2 * user.length());
        short domainOff = 64;
        short userOff = (short)(domainOff + domainLen);
        short hostOff = (short)(userOff + userLen);
        short lmRespOff = (short)(hostOff + hostLen);
        short ntRespOff = (short)(lmRespOff + lmRespLen);
        short msgLen = (short)(ntRespOff + ntRespLen);
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        DataOutputStream dataOut = new DataOutputStream(os);
        dataOut.writeBytes("NTLMSSP\u0000");
        dataOut.writeByte(3);
        dataOut.writeByte(0);
        dataOut.writeByte(0);
        dataOut.writeByte(0);
        dataOut.writeShort(NTLM.swapBytes(lmRespLen));
        dataOut.writeShort(NTLM.swapBytes(lmRespLen));
        dataOut.writeShort(NTLM.swapBytes(lmRespOff));
        dataOut.writeShort(0);
        dataOut.writeShort(NTLM.swapBytes(ntRespLen));
        dataOut.writeShort(NTLM.swapBytes(ntRespLen));
        dataOut.writeShort(NTLM.swapBytes(ntRespOff));
        dataOut.writeShort(0);
        dataOut.writeShort(NTLM.swapBytes(domainLen));
        dataOut.writeShort(NTLM.swapBytes(domainLen));
        dataOut.writeShort(NTLM.swapBytes(domainOff));
        dataOut.writeShort(0);
        dataOut.writeShort(NTLM.swapBytes(userLen));
        dataOut.writeShort(NTLM.swapBytes(userLen));
        dataOut.writeShort(NTLM.swapBytes(userOff));
        dataOut.writeShort(0);
        dataOut.writeShort(NTLM.swapBytes(hostLen));
        dataOut.writeShort(NTLM.swapBytes(hostLen));
        dataOut.writeShort(NTLM.swapBytes(hostOff));
        dataOut.writeShort(0);
        dataOut.writeInt(0);
        dataOut.writeShort(NTLM.swapBytes(msgLen));
        dataOut.writeShort(0);
        dataOut.writeShort(0);
        dataOut.writeShort(0);
        int i = 0;
        while (i < userDomain.length()) {
            dataOut.writeShort(NTLM.swapBytes((short)userDomain.charAt(i)));
            ++i;
        }
        int i2 = 0;
        while (i2 < user.length()) {
            dataOut.writeShort(NTLM.swapBytes((short)user.charAt(i2)));
            ++i2;
        }
        int i3 = 0;
        while (i3 < host.length()) {
            dataOut.writeShort(NTLM.swapBytes((short)host.charAt(i3)));
            ++i3;
        }
        dataOut.write(lmResponse);
        dataOut.write(ntResponse);
        dataOut.flush();
        return os.toByteArray();
    }

    public static final String bytesToHexStr(byte[] bcd) {
        StringBuffer s = new StringBuffer(bcd.length * 2);
        int i = 0;
        while (i < bcd.length) {
            s.append(bcdLookup[bcd[i] >>> 4 & 0xF]);
            s.append(bcdLookup[bcd[i] & 0xF]);
            ++i;
        }
        return s.toString();
    }

    public static void printHexBlock(String s, byte[] b) {
        String out = NTLM.bytesToHexStr(b);
        DecimalFormat format = new DecimalFormat("00000");
        logger_.debug((Object)(s + "[bytes : " + b.length + " ]"));
        int i = 0;
        while (i < out.length()) {
            try {
                logger_.debug((Object)(format.format(i / 2) + " " + out.substring(i, i + 40)));
            }
            catch (StringIndexOutOfBoundsException e) {
                logger_.debug((Object)(format.format(i / 2) + " " + out.substring(i)));
            }
            i += 40;
        }
    }

    public static void printHexBlock(String s, String out) {
        DecimalFormat format = new DecimalFormat("00000");
        logger_.debug((Object)(s + "[bytes : " + out.length() / 2 + " ]"));
        int i = 0;
        while (i < out.length()) {
            try {
                logger_.debug((Object)(format.format(i / 2) + " " + out.substring(i, i + 40)));
            }
            catch (StringIndexOutOfBoundsException e) {
                logger_.debug((Object)(format.format(i / 2) + " " + out.substring(i)));
            }
            i += 40;
        }
    }

    public static final byte[] hexStrToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return bytes;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.exit(1);
        }
        try {
            byte[] lm = NTLM.computeLMPassword(args[0]);
            byte[] nt = NTLM.computeNTPassword(args[0]);
            logger_.debug((Object)(NTLM.bytesToHexStr(lm).toUpperCase() + ":"));
            logger_.debug((Object)NTLM.bytesToHexStr(nt).toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

