/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.server.user.cache;

import at.tugraz.genome.usermanagement.server.config.ConfigLoader;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VOFactory.ExtendedUserVOFactory;
import at.tugraz.genome.usermanagement.server.user.cache.UserCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.util.MailManager;

public class ExtendedUserVOCache
implements UserCache {
    private static Map mapByName_;
    private static Map mapByID_;
    private static ExtendedUserVOCache cache_;
    private static final Log logger_;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$server$user$cache$ExtendedUserVOCache;

    private ExtendedUserVOCache() {
        mapByName_ = Collections.synchronizedMap(new HashMap());
        mapByID_ = Collections.synchronizedMap(new HashMap());
    }

    public static ExtendedUserVOCache getInstance() {
        if (cache_ == null) {
            cache_ = new ExtendedUserVOCache();
        }
        return cache_;
    }

    public void emptyCache() {
        cache_ = new ExtendedUserVOCache();
        if (mapByName_ != null) {
            mapByName_.clear();
        }
        if (mapByID_ != null) {
            mapByID_.clear();
        }
        mapByName_ = null;
        mapByID_ = null;
        mapByName_ = Collections.synchronizedMap(new HashMap());
        mapByID_ = Collections.synchronizedMap(new HashMap());
    }

    public void updateUser(String username) {
        ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(username, true);
        logger_.info((Object)("updated ExtendedUserVO of user : \"" + username + "\" in cache"));
    }

    public void checkForExpiryEmail(String username) {
        ExtendedUserVO vo = ExtendedUserVOFactory.getUserVO(username, false);
        if (vo != null && vo.getLdapAuthenticationEnabled() != null && vo.getLdapAuthenticationEnabled().equalsIgnoreCase("true") || vo.getApplicationAuthenticationEnabled() != null && vo.getApplicationAuthenticationEnabled().equalsIgnoreCase("true")) {
            long expireDate = vo.getExpireDate();
            long day = 86400000L;
            long oneAndHalfDay = 129600000L;
            long week = 7L * day;
            long weekMinusDay = week - day;
            String mailAdressAdministrator = ConfigLoader.getInstance().getProperties().getProperty("from");
            String messageToUser = ConfigLoader.getInstance().getProperties().getProperty("accountExpires1") + "\n";
            messageToUser = messageToUser + ConfigLoader.getInstance().getProperties().getProperty("accountExpires2") + " ";
            String messageToAdmin = ConfigLoader.getInstance().getProperties().getProperty("accountExpiresAdmin1") + " ";
            if (expireDate - System.currentTimeMillis() < oneAndHalfDay) {
                messageToUser = messageToUser + "1 " + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresDay") + "!\n\n";
                messageToUser = messageToUser + ConfigLoader.getInstance().getProperties().getProperty("accountExpires3");
                MailManager.send(vo.getEmail(), messageToUser);
                logger_.info((Object)("send user : " + vo.getName() + " a email urgent expiry note : " + vo.getEmail()));
                messageToAdmin = messageToAdmin + vo.getFullname() + " " + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresAdmin2") + " 1 " + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresDay") + "\n\n";
                messageToAdmin = messageToAdmin + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresAdmin3");
                MailManager.send(mailAdressAdministrator, messageToAdmin);
            } else if (expireDate - System.currentTimeMillis() < week && expireDate - System.currentTimeMillis() > weekMinusDay) {
                messageToUser = messageToUser + "1 " + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresWeek") + "!\n\n";
                messageToUser = messageToUser + ConfigLoader.getInstance().getProperties().getProperty("accountExpires3");
                MailManager.send(vo.getEmail(), messageToUser);
                logger_.info((Object)("send user : " + vo.getName() + " a email expiry note : " + vo.getEmail()));
                messageToAdmin = messageToAdmin + vo.getFullname() + " " + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresAdmin2") + " 1 " + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresWeek") + "\n\n";
                messageToAdmin = messageToAdmin + ConfigLoader.getInstance().getProperties().getProperty("accountExpiresAdmin3");
                MailManager.send(mailAdressAdministrator, messageToAdmin);
            }
        }
    }

    public ExtendedUserVO getUser(String name) {
        return (ExtendedUserVO)mapByName_.get(name);
    }

    public ExtendedUserVO getUserByID(Long id) {
        return (ExtendedUserVO)mapByID_.get(id);
    }

    public void putUserVO(String name, ExtendedUserVO vo) {
        mapByName_.put(name, vo);
        mapByID_.put(vo.getID(), vo);
    }

    public void putUserVO(Long id, ExtendedUserVO vo) {
        mapByID_.put(id, vo);
        mapByName_.put(vo.getName(), vo);
    }

    public boolean hasUser(String name) {
        return mapByName_.containsKey(name);
    }

    public boolean hasUser(Long id) {
        return mapByID_.containsKey(id);
    }

    public void removeUser(String name) {
        mapByName_.remove(name);
        logger_.info((Object)"deleted UserVO from cache (byName), todo: byID");
        Vector listOfVOs = new Vector(mapByID_.values());
        Iterator iter = listOfVOs.iterator();
        while (iter.hasNext()) {
            ExtendedUserVO vo = (ExtendedUserVO)iter.next();
            if (!vo.getName().equals(name)) continue;
            mapByID_.remove(vo.getID());
            logger_.info((Object)"deleted UserVO from cache (byID)");
            break;
        }
    }

    public void removeUser(Long id) {
        mapByID_.remove(id);
        logger_.info((Object)"deleted UserVO from cache (byID), todo: byName");
        Vector listOfVOs = new Vector(mapByName_.values());
        Iterator iter = listOfVOs.iterator();
        while (iter.hasNext()) {
            ExtendedUserVO vo = (ExtendedUserVO)iter.next();
            if (!vo.getName().equals(id)) continue;
            mapByName_.remove(vo.getID());
            logger_.info((Object)"deleted UserVO from cache (byName)");
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$server$user$cache$ExtendedUserVOCache == null ? (class$at$tugraz$genome$usermanagement$server$user$cache$ExtendedUserVOCache = ExtendedUserVOCache.class$("at.tugraz.genome.usermanagement.server.user.cache.ExtendedUserVOCache")) : class$at$tugraz$genome$usermanagement$server$user$cache$ExtendedUserVOCache));
    }
}

