/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.xml;

import at.tugraz.genome.usermanagement.server.acl.VO.AclVO;
import at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class AclXMLGenerator {
    private Document newDoc = null;

    public AclXMLGenerator(String realm, Vector groups, Vector resources, Vector acls) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        factory.setValidating(true);
        DOMImplementation implement = builder.getDOMImplementation();
        DocumentType docType = implement.createDocumentType("AclExport", "ID", "AclExport.dtd");
        this.newDoc = implement.createDocument("", "AclExport", docType);
        Element root = this.newDoc.getDocumentElement();
        root.setAttribute("Applicationname", realm);
        Element groupsElement = this.newDoc.createElement("Groups");
        int i = 0;
        while (i != groups.size()) {
            SmallGroupVO groupVO = (SmallGroupVO)groups.get(i);
            Element group = this.newDoc.createElement("Group");
            group.setAttribute("name", groupVO.getName());
            if (groupVO.isActiveInRealm(realm)) {
                group.setAttribute("active", "true");
            } else {
                group.setAttribute("active", "false");
            }
            Vector apps = groupVO.getRealmGroupIsAdmin();
            boolean isAdmin = false;
            int j = 0;
            while (j != apps.size()) {
                if (((ApplicationVO)apps.get(j)).getApplicationname().equalsIgnoreCase(realm)) {
                    isAdmin = true;
                }
                ++j;
            }
            if (isAdmin) {
                group.setAttribute("admin", "true");
            } else {
                group.setAttribute("admin", "false");
            }
            groupsElement.appendChild(group);
            ++i;
        }
        this.newDoc.getDocumentElement().appendChild(groupsElement);
        Element resourcesElement = this.newDoc.createElement("Resources");
        int i2 = 0;
        while (i2 != resources.size()) {
            ResourceVO resourceVO = (ResourceVO)resources.get(i2);
            Element resource = this.newDoc.createElement("Resource");
            resource.setAttribute("resourceKey", resourceVO.getResourceKey());
            resource.setAttribute("availableAccess", resourceVO.getAvailAccess());
            resource.setAttribute("description", resourceVO.getDescription());
            resourcesElement.appendChild(resource);
            ++i2;
        }
        this.newDoc.getDocumentElement().appendChild(resourcesElement);
        Element aclsElement = this.newDoc.createElement("Acls");
        int i3 = 0;
        while (i3 != acls.size()) {
            Element acl = this.newDoc.createElement("Acl");
            AclVO vo = (AclVO)acls.get(i3);
            acl.setAttribute("groupId", vo.getGroupId());
            acl.setAttribute("resourceKey", vo.getResourceKey());
            acl.setAttribute("accessLevel", vo.getAccessLevel());
            aclsElement.appendChild(acl);
            ++i3;
        }
        this.newDoc.getDocumentElement().appendChild(aclsElement);
    }

    public Document getDocument() {
        return this.newDoc;
    }
}

