/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.xml;

import at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO;
import at.tugraz.genome.usermanagement.server.right.VO.RightOfResourceVO;
import at.tugraz.genome.usermanagement.server.user.VO.PwdUserVO;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class UserXMLGenerator {
    private Document newDoc = null;

    public UserXMLGenerator(Vector users, Vector institutes) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        factory.setValidating(true);
        DOMImplementation implement = builder.getDOMImplementation();
        DocumentType docType = implement.createDocumentType("simple-usermanagement", "ID", "simple-usermanagement.dtd");
        this.newDoc = implement.createDocument("", "simple-usermanagement", docType);
        Element generalProperties = this.newDoc.createElement("general-properties");
        Element version = this.newDoc.createElement("version");
        version.appendChild(this.newDoc.createTextNode("1.0"));
        generalProperties.appendChild(version);
        this.newDoc.getDocumentElement().appendChild(generalProperties);
        Element organizations = this.newDoc.createElement("organizations");
        int i = 0;
        while (i != institutes.size()) {
            Element organization = this.newDoc.createElement("organization");
            InstitutVO instVO = (InstitutVO)institutes.get(i);
            Element organizationName = this.newDoc.createElement("organizationname");
            organizationName.appendChild(this.newDoc.createTextNode(instVO.getName()));
            organization.appendChild(organizationName);
            Element organizationId = this.newDoc.createElement("organizationid");
            organizationId.appendChild(this.newDoc.createTextNode(instVO.getId().toString()));
            organization.appendChild(organizationId);
            organizations.appendChild(organization);
            ++i;
        }
        this.newDoc.getDocumentElement().appendChild(organizations);
        Element usersElement = this.newDoc.createElement("users");
        int i2 = 0;
        while (i2 != users.size()) {
            PwdUserVO vo = (PwdUserVO)users.get(i2);
            Element user = this.newDoc.createElement("user");
            Element name = this.newDoc.createElement("username");
            name.appendChild(this.newDoc.createTextNode(vo.getName()));
            user.appendChild(name);
            Element firstname = this.newDoc.createElement("firstname");
            firstname.appendChild(this.newDoc.createTextNode(vo.getFirstName()));
            user.appendChild(firstname);
            Element lastname = this.newDoc.createElement("lastname");
            lastname.appendChild(this.newDoc.createTextNode(vo.getLastName()));
            user.appendChild(lastname);
            Element email = this.newDoc.createElement("email");
            email.appendChild(this.newDoc.createTextNode(vo.getEMail()));
            user.appendChild(email);
            Element descr = this.newDoc.createElement("description");
            descr.appendChild(this.newDoc.createTextNode(vo.getDescription()));
            user.appendChild(descr);
            Element pwd = this.newDoc.createElement("password");
            pwd.appendChild(this.newDoc.createTextNode(vo.getPasswordHash()));
            user.appendChild(pwd);
            Element token = this.newDoc.createElement("aastoken");
            user.appendChild(token);
            usersElement.appendChild(user);
            Element id = this.newDoc.createElement("userid");
            id.appendChild(this.newDoc.createTextNode(vo.getId().toString()));
            user.appendChild(id);
            Vector instiutes = vo.getInstitutes();
            Element organizationIds = this.newDoc.createElement("userorganizationids");
            int j = 0;
            while (j != instiutes.size()) {
                Element organizationId = this.newDoc.createElement("organizationid");
                organizationId.appendChild(this.newDoc.createTextNode(((InstitutVO)instiutes.get(j)).getId().toString()));
                organizationIds.appendChild(organizationId);
                ++j;
            }
            user.appendChild(organizationIds);
            Vector acls = vo.getAcls();
            Element roles = this.newDoc.createElement("roles");
            int j2 = 0;
            while (j2 != acls.size()) {
                Element role = this.newDoc.createElement("role");
                RightOfResourceVO resVO = (RightOfResourceVO)acls.get(j2);
                role.setAttribute("realm", resVO.getResource().getRealm());
                role.setAttribute("resource", resVO.getResource().getResourceKey());
                role.setAttribute("acl", resVO.getAllAccessLevel());
                roles.appendChild(role);
                ++j2;
            }
            user.appendChild(roles);
            ++i2;
        }
        this.newDoc.getDocumentElement().appendChild(usersElement);
    }

    public Document getDocument() {
        return this.newDoc;
    }
}

