/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.access.provider.ejb;

import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import com.opensymphony.module.access.AccessManager;
import com.opensymphony.module.access.DuplicateKeyException;
import com.opensymphony.module.access.ImmutableException;
import com.opensymphony.module.access.NotFoundException;
import com.opensymphony.module.access.entities.Acl_I;
import com.opensymphony.module.access.entities.Resource_I;
import com.opensymphony.module.access.provider.ResourceProvider;
import com.opensymphony.module.access.provider.ejb.AclEntity;
import com.opensymphony.module.access.provider.ejb.OsAcl;
import com.opensymphony.module.access.provider.ejb.OsAclHome;
import com.opensymphony.module.access.provider.ejb.OsResource;
import com.opensymphony.module.access.provider.ejb.OsResourceHome;
import com.opensymphony.module.access.provider.ejb.ResourceEntity;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBResourceProvider
implements ResourceProvider {
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$module$access$provider$ejb$EJBResourceProvider == null ? (class$com$opensymphony$module$access$provider$ejb$EJBResourceProvider = EJBResourceProvider.class$("com.opensymphony.module.access.provider.ejb.EJBResourceProvider")) : class$com$opensymphony$module$access$provider$ejb$EJBResourceProvider));
    private String realm;
    public static String aclLocation = "Acl";
    public static String resourceLocation = "Resource";
    static /* synthetic */ Class class$com$opensymphony$module$access$provider$ejb$EJBResourceProvider;

    public boolean init(Properties properties) {
        this.realm = properties.getProperty("realm");
        aclLocation = properties.getProperty("aclLocation");
        resourceLocation = properties.getProperty("resourceLocation");
        return true;
    }

    public String getRealm() {
        return this.realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userHasAccessLevel(String userId, String resourceKey, String accessLevel) throws NotFoundException {
        OsAcl acl = null;
        boolean ret = false;
        try {
            block13: {
                try {
                    InitialContext ic = new InitialContext();
                    OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
                    logger.debug((Object)("try to find resourceKey: \"" + resourceKey + "\", username: \"" + userId + "\", accessLevel: \"" + accessLevel + "\""));
                    try {
                        acl = home.findByRealmAndResourceKeyAndUserId(this.realm, resourceKey, userId);
                        String level = acl.getAccessLevel();
                        logger.debug((Object)("accesslevels available: + " + level + ", Realm : " + this.realm));
                        int i = 0;
                        while (i < accessLevel.length()) {
                            if (level.indexOf(String.valueOf(accessLevel.charAt(i))) > -1) {
                                ret = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (FinderException e) {
                        logger.debug((Object)"looking in groupsrights....");
                    }
                    if (ret) break block13;
                    logger.debug((Object)"looking for grouprights");
                    AccessManager am = AccessManager.getInstance();
                    List groups = am.listGroupsForUser(this.realm, userId);
                    if (groups == null) break block13;
                    logger.debug((Object)("user is in groups:" + groups.toString()));
                    int groupsize = groups.size();
                    logger.debug((Object)("found " + groupsize + " groups of user"));
                    int i = 0;
                    while (i < groupsize) {
                        SmallGroupVO group = (SmallGroupVO)groups.get(i);
                        try {
                            ret = this.groupHasAccessLevel(group.getName(), resourceKey, accessLevel);
                        }
                        catch (NotFoundException e) {
                            // empty catch block
                        }
                        if (ret) break;
                        ++i;
                    }
                }
                catch (NamingException e) {
                    logger.fatal((Object)("no OsAclHome found " + e.getMessage()));
                    Object var15_19 = null;
                    return ret;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.fatal((Object)("Error " + e.getMessage()));
                    Object var15_20 = null;
                    return ret;
                }
            }
            Object var15_18 = null;
            return ret;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            return ret;
        }
    }

    public String getUserAccessLevels(String userId, String resourceKey) throws NotFoundException {
        return this.getUserAccessLevels(userId, resourceKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserAccessLevels(String userId, String resourceKey, boolean checkGroups) throws NotFoundException {
        OsAcl acl = null;
        String ret = "";
        try {
            int i;
            List groups;
            try {
                InitialContext ic = new InitialContext();
                OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
                acl = home.findByRealmAndResourceKeyAndUserId(this.realm, resourceKey, userId);
                return acl.getAccessLevel();
            }
            catch (NamingException e) {
                return ret;
            }
            catch (FinderException e) {
                if (!checkGroups) throw new NotFoundException("User: " + userId + " has no access to resource: " + resourceKey);
                groups = AccessManager.getInstance().listGroupsForUser(this.realm, userId);
                i = 0;
            }
            while (i < groups.size()) {
                String group = (String)groups.get(i);
                try {
                    ret = this.getGroupAccessLevels(group, resourceKey, true);
                }
                catch (NotFoundException ex) {
                    // empty catch block
                }
                if (!"".equals(ret)) break;
                ++i;
            }
            if (!"".equals(ret)) return ret;
            throw new NotFoundException("User: " + userId + " and all groups he belongs has no access to resource: " + resourceKey);
        }
        catch (Throwable throwable) {
            return ret;
        }
    }

    public void updateUserAccessLevel(String realm, String userId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        OsAclHome home = null;
        OsResource res = null;
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            home = (OsAclHome)ic.lookup(aclLocation);
        }
        catch (NamingException e) {
            throw new NotFoundException("Access bean not found. Container problem");
        }
        OsAcl acl = null;
        try {
            acl = home.findByRealmAndResourceKeyAndUserId(this.realm, resourceKey, userId);
            OsResourceHome resource = null;
            try {
                resource = (OsResourceHome)ic.lookup(resourceLocation);
            }
            catch (NamingException e) {
                throw new NotFoundException("Access bean not found. Container problem");
            }
            try {
                res = resource.findByRealmAndResourceKey(realm, resourceKey);
            }
            catch (FinderException e) {
                throw new NotFoundException("No Resource with Key: " + resourceKey);
            }
            String availLevel = res.getAvailaccess();
            if (availLevel != null) {
                int i = 0;
                while (i < accessLevel.length()) {
                    if (availLevel.indexOf(String.valueOf(accessLevel.charAt(i))) == -1) {
                        throw new ImmutableException("Resorce Found but accessLevel not availible for this resource");
                    }
                    ++i;
                }
            }
            acl.setAccessLevel(accessLevel);
        }
        catch (FinderException e) {
            throw new NotFoundException("Access not found to update");
        }
        catch (Exception e) {
            throw new ImmutableException("the following error occured: " + e.getMessage());
        }
    }

    public void createUserAccessLevel(String realm, String userId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException, DuplicateKeyException {
        OsResource res = null;
        try {
            InitialContext ic = new InitialContext();
            OsResourceHome resource = (OsResourceHome)ic.lookup(resourceLocation);
            try {
                res = resource.findByRealmAndResourceKey(realm, resourceKey);
            }
            catch (FinderException e) {
                throw new NotFoundException("No Resource with Key: " + resourceKey);
            }
            String availLevel = res.getAvailaccess();
            if (availLevel != null) {
                int i = 0;
                while (i < accessLevel.length()) {
                    if (availLevel.indexOf(String.valueOf(accessLevel.charAt(i))) == -1) {
                        throw new NotFoundException("Resorce Found but accessLevel not availible for this resource");
                    }
                    ++i;
                }
            }
            OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
            try {
                OsAcl temp = home.findByRealmAndResourceKeyAndUserId(this.realm, resourceKey, userId);
                throw new javax.ejb.DuplicateKeyException("ACL for user " + userId + " in application " + this.realm + " already exists. Access Levels: " + temp.getAccessLevel());
            }
            catch (EJBException e) {
            }
            catch (FinderException e) {
                // empty catch block
            }
            home.create(resourceKey, accessLevel, null, userId, realm);
        }
        catch (Exception e) {
            throw new ImmutableException("ACL not created. Reason: " + e.getMessage());
        }
    }

    public void deleteUserAccessLevel(String userId, String resourceKey) throws NotFoundException, ImmutableException {
        OsAclHome home = null;
        try {
            InitialContext ic = new InitialContext();
            home = (OsAclHome)ic.lookup(aclLocation);
        }
        catch (NamingException e) {
            throw new ImmutableException("Not Removed. exception:" + e.getMessage());
        }
        OsAcl acl = null;
        try {
            acl = home.findByRealmAndResourceKeyAndUserId(this.realm, resourceKey, userId);
        }
        catch (EJBException e) {
        }
        catch (FinderException e) {
            throw new NotFoundException();
        }
        try {
            acl.remove();
        }
        catch (Exception e) {
            throw new ImmutableException("Not Removed. exception:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean groupHasAccessLevel(String groupId, String resourceKey, String accessLevel) throws NotFoundException {
        ret = false;
        try {
            block9: {
                try {
                    try {
                        EJBResourceProvider.logger.debug((Object)("groupId: " + groupId + ", resourceKey: " + resourceKey + ", accessLevel: " + accessLevel));
                        level = this.getGroupAccessLevels(groupId, resourceKey);
                        i = 0;
                        while (i < accessLevel.length()) {
                            if (level.indexOf(String.valueOf(accessLevel.charAt(i))) != -1) {
                                ret = true;
                                break block9;
                            }
                            ++i;
                        }
                        break block9;
                    }
                    catch (NotFoundException ef) {
                        am = AccessManager.getInstance();
                        arr = am.listGroupsInGroup(this.realm, groupId);
                        i = 0;
                        ** while (i < arr.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ret = this.groupHasAccessLevel((String)arr.get(i), resourceKey, accessLevel);
                        if (ret) ** break;
                        ++i;
                        continue;
                    }
                }
                catch (Exception e) {
                    var10_13 = null;
                    return ret;
                }
            }
            var10_12 = null;
            return ret;
        }
        catch (Throwable var9_15) {
            var10_14 = null;
            return ret;
        }
    }

    public String getGroupAccessLevels(String groupId, String resourceKey) throws NotFoundException {
        return this.getGroupAccessLevels(groupId, resourceKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getGroupAccessLevels(String groupId, String resourceKey, boolean checkParents) throws NotFoundException {
        String ret = "";
        OsAclHome home = null;
        try {
            int i;
            List groups;
            try {
                InitialContext ic = new InitialContext();
                home = (OsAclHome)ic.lookup(aclLocation);
                OsAcl acl = home.findByRealmAndGroupIdAndResourceKey(this.realm, groupId, resourceKey);
                return acl.getAccessLevel();
            }
            catch (FinderException e) {
                if (!checkParents) throw new NotFoundException("Access/Resource not found for Group:" + groupId + " Resource:" + resourceKey);
                groups = AccessManager.getInstance().listParentGroupsOfGroup(this.realm, groupId);
                i = 0;
            }
            while (i < groups.size()) {
                try {
                    OsAcl acl = home.findByRealmAndGroupIdAndResourceKey(this.realm, (String)groups.get(i), resourceKey);
                    ret = acl.getAccessLevel();
                }
                catch (EJBException e1) {
                }
                catch (FinderException e1) {
                    // empty catch block
                }
                if (!"".equals(ret)) break;
                ++i;
            }
            if (!"".equals(ret)) return ret;
            throw new NotFoundException("Access/Resource not found for Group/Parents:" + groupId + " Resource:" + resourceKey);
            catch (NamingException e) {
                return ret;
            }
        }
        catch (Throwable throwable) {
            return ret;
        }
    }

    public void updateGroupAccessLevels(String groupId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        OsAclHome home = null;
        OsResource res = null;
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            home = (OsAclHome)ic.lookup(aclLocation);
        }
        catch (NamingException e) {
            throw new NotFoundException("Access bean not found. Container problem");
        }
        OsAcl acl = null;
        try {
            acl = home.findByRealmAndGroupIdAndResourceKey(this.realm, groupId, resourceKey);
            OsResourceHome resource = null;
            try {
                resource = (OsResourceHome)ic.lookup(resourceLocation);
            }
            catch (NamingException e) {
                throw new NotFoundException("Acces bean not found. Container problem");
            }
            try {
                res = resource.findByRealmAndResourceKey(this.realm, resourceKey);
            }
            catch (FinderException e) {
                throw new NotFoundException("No Resource with Key: " + resourceKey);
            }
            String availLevel = res.getAvailaccess();
            if (availLevel != null) {
                int i = 0;
                while (i < accessLevel.length()) {
                    if (availLevel.indexOf(String.valueOf(accessLevel.charAt(i))) == -1) {
                        throw new ImmutableException("Resorce Found but accessLevel not availible for this resource");
                    }
                    ++i;
                }
            }
            acl.setAccessLevel(accessLevel);
        }
        catch (FinderException e) {
            throw new NotFoundException("Access not found to update");
        }
        catch (Exception e) {
            throw new ImmutableException("the following error occured: " + e.getMessage());
        }
    }

    public void createGroupAccessLevel(String realm, String groupId, String resourceKey, String accessLevel) throws NotFoundException, ImmutableException {
        OsResource res = null;
        try {
            InitialContext ic = new InitialContext();
            OsResourceHome resource = (OsResourceHome)ic.lookup(resourceLocation);
            try {
                res = resource.findByRealmAndResourceKey(realm, resourceKey);
            }
            catch (FinderException e) {
                throw new NotFoundException("No Resource with Key: " + resourceKey);
            }
            String availLevel = res.getAvailaccess();
            if (availLevel != null) {
                int i = 0;
                while (i < accessLevel.length()) {
                    if (availLevel.indexOf(String.valueOf(accessLevel.charAt(i))) == -1) {
                        throw new NotFoundException("Resorce Found but accessLevel not availible for this resource");
                    }
                    ++i;
                }
            }
            OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
            try {
                OsAcl temp = home.findByRealmAndGroupIdAndResourceKey(this.realm, groupId, resourceKey);
                throw new javax.ejb.DuplicateKeyException("ACL for Group " + groupId + " in application " + this.realm + " already exists. Access Levels: " + temp.getAccessLevel());
            }
            catch (EJBException e) {
            }
            catch (FinderException e) {
                // empty catch block
            }
            home.create(resourceKey, accessLevel, groupId, null, realm);
        }
        catch (Exception e) {
            throw new ImmutableException("ACL not created. Reason: " + e.getMessage());
        }
    }

    public void deleteGroupAccessLevel(String realm, String groupId, String resourceKey) throws NotFoundException, ImmutableException {
        OsAclHome home = null;
        try {
            InitialContext ic = new InitialContext();
            home = (OsAclHome)ic.lookup(aclLocation);
        }
        catch (NamingException e) {
            throw new ImmutableException("Not Removed. exception:" + e.getMessage());
        }
        OsAcl acl = null;
        try {
            logger.debug((Object)("looking for " + this.realm + " " + groupId + " " + resourceKey));
            acl = home.findByRealmAndGroupIdAndResourceKey(this.realm, groupId, resourceKey);
        }
        catch (EJBException e) {
        }
        catch (FinderException e) {
            throw new NotFoundException();
        }
        try {
            acl.remove();
        }
        catch (Exception e) {
            throw new ImmutableException("Not Removed. exception:" + e.getMessage());
        }
    }

    public void deleteResource(String realm, String resourceKey) throws NotFoundException, ImmutableException {
        OsResource res = null;
        try {
            InitialContext ic = new InitialContext();
            OsResourceHome home = (OsResourceHome)ic.lookup(resourceLocation);
            try {
                res = home.findByRealmAndResourceKey(realm, resourceKey);
                res.remove();
            }
            catch (FinderException fe) {
                throw new NotFoundException("Resource: '" + resourceKey + "' not found.");
            }
        }
        catch (NamingException e) {
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
        catch (EJBException e) {
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
        catch (RemoveException e) {
            throw new ImmutableException("Remove Error: " + e.getMessage());
        }
        catch (Exception e) {
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
    }

    public void deleteResourceAndRights(String realm, String resourceKey) throws NotFoundException, ImmutableException {
        OsResource res = null;
        UserTransaction trans = null;
        try {
            InitialContext ic = new InitialContext();
            OsResourceHome home = (OsResourceHome)ic.lookup(resourceLocation);
            trans = (UserTransaction)ic.lookup("java:comp/UserTransaction");
            try {
                trans.begin();
            }
            catch (NotSupportedException e) {
                throw new ImmutableException("Remove Transaction Error: " + e.getMessage());
            }
            catch (SystemException e) {
                throw new ImmutableException("Remove Transaction Error: " + e.getMessage());
            }
            try {
                res = home.findByRealmAndResourceKey(realm, resourceKey);
                this.removeAclForResource(ic, resourceKey, trans);
                res.remove();
                try {
                    trans.commit();
                }
                catch (Exception e) {
                    try {
                        trans.rollback();
                    }
                    catch (Exception e1) {
                        throw new ImmutableException("Remove Transaction Error: " + e.getMessage());
                    }
                }
            }
            catch (FinderException fe) {
                try {
                    trans.rollback();
                }
                catch (Exception e1) {
                    throw new ImmutableException("Transaction rollback Error: " + e1.getMessage() + " when finder Error: " + fe.getMessage());
                }
                throw new NotFoundException("Resource: '" + resourceKey + "' not found.");
            }
        }
        catch (NamingException e) {
            if (trans != null) {
                try {
                    if (trans.getStatus() == 0) {
                        trans.rollback();
                    }
                }
                catch (Exception e1) {
                    throw new ImmutableException("Transaction rollback Error: " + e1.getMessage() + " when Container Error: " + e.getMessage());
                }
            }
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
        catch (EJBException e) {
            if (trans != null) {
                try {
                    if (trans.getStatus() == 0) {
                        trans.rollback();
                    }
                }
                catch (Exception e1) {
                    throw new ImmutableException("Transaction rollback Error: " + e1.getMessage() + " when Container Error: " + e.getMessage());
                }
            }
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
        catch (RemoteException e) {
            if (trans != null) {
                try {
                    if (trans.getStatus() == 0) {
                        trans.rollback();
                    }
                }
                catch (Exception e1) {
                    throw new ImmutableException("Transaction rollback Error: " + e1.getMessage() + " when Container Error: " + e.getMessage());
                }
            }
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
        catch (RemoveException e) {
            if (trans != null) {
                try {
                    if (trans.getStatus() == 0) {
                        trans.rollback();
                    }
                }
                catch (Exception e1) {
                    throw new ImmutableException("Transaction rollback Error: " + e1.getMessage() + " when Container Error: " + e.getMessage());
                }
            }
            throw new ImmutableException("Remove Error: " + e.getMessage());
        }
    }

    private void removeAclForResource(InitialContext ic, String resourceKey, UserTransaction trans) throws NamingException, RemoteException, FinderException, ImmutableException {
        OsAclHome aHome = (OsAclHome)ic.lookup(aclLocation);
        Collection acls = aHome.findByResourceKey(resourceKey);
        OsAcl acl = null;
        Iterator itr = acls.iterator();
        while (itr.hasNext()) {
            acl = (OsAcl)itr.next();
            try {
                acl.remove();
            }
            catch (Exception e) {
                try {
                    trans.rollback();
                }
                catch (Exception e1) {
                    throw new ImmutableException("Transaction rollback error: " + e1.getMessage() + " When removing ACL Remove Error: " + e.getMessage());
                }
                throw new ImmutableException("ACL Remove Error: " + e.getMessage());
            }
        }
    }

    public boolean handles(String name) {
        return this.realm.equalsIgnoreCase(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<resourceProvider type=\"").append(this.getClass().getName()).append("\">");
        sb.append("<realm>").append(this.realm).append("</realm>");
        sb.append("param name=\"aclLocation\">").append(aclLocation).append("</param>");
        sb.append("param name=\"resourceLocation\">").append(resourceLocation).append("</param>");
        sb.append("<instance id=\"" + super.toString() + "\" />");
        sb.append("</resourceProvider>");
        return sb.toString();
    }

    public void createResource(String realm, String resourceKey, String description, String availAccess) throws DuplicateKeyException, ImmutableException {
        OsResource res = null;
        try {
            InitialContext ic = new InitialContext();
            logger.debug((Object)("try to find " + resourceLocation));
            OsResourceHome home = (OsResourceHome)ic.lookup(resourceLocation);
            try {
                res = home.findByRealmAndResourceKey(realm, resourceKey);
                logger.debug((Object)"resourceKey Found");
                throw new DuplicateKeyException("Resource: '" + resourceKey + "':'" + res.getDescription() + "' already Exist");
            }
            catch (FinderException fe) {
                try {
                    logger.debug((Object)("try to craete " + realm + resourceKey + description + availAccess));
                    home.create(realm, resourceKey, description, availAccess);
                }
                catch (CreateException e) {
                    throw new ImmutableException("Create Error: " + e.getMessage());
                }
            }
        }
        catch (NamingException e) {
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
        catch (EJBException e) {
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
        catch (Exception e) {
            throw new ImmutableException("Container Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getResources() throws NotFoundException {
        ArrayList<ResourceEntity> ret = new ArrayList<ResourceEntity>();
        try {
            try {
                InitialContext ic = new InitialContext();
                OsResourceHome home = (OsResourceHome)ic.lookup(resourceLocation);
                Collection res = home.findByRealm(this.realm);
                Iterator itr = res.iterator();
                while (itr.hasNext()) {
                    OsResource resource = (OsResource)itr.next();
                    ret.add(new ResourceEntity(resource));
                }
            }
            catch (NamingException e) {
                Object var8_11 = null;
                return ret;
            }
            catch (EJBException e) {
                Object var8_12 = null;
                return ret;
            }
            catch (FinderException e) {
                Object var8_13 = null;
                return ret;
            }
            Object var8_10 = null;
            return ret;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            return ret;
        }
    }

    public Resource_I getResourceByKey(String realm, String resourceKey) throws NotFoundException {
        try {
            InitialContext ic = new InitialContext();
            OsResourceHome home = (OsResourceHome)ic.lookup(resourceLocation);
            OsResource res = home.findByRealmAndResourceKey(realm, resourceKey);
            return new ResourceEntity(res);
        }
        catch (FinderException e) {
            throw new NotFoundException(resourceKey + " not found");
        }
        catch (NamingException e) {
            throw new NotFoundException("Container Error: " + e.getMessage());
        }
        catch (EJBException e) {
            throw new NotFoundException("Container Error: " + e.getMessage());
        }
        catch (Exception e) {
            throw new NotFoundException("Container Error: " + e.getMessage());
        }
    }

    public ArrayList getAclsByUserId(String userId) throws NotFoundException {
        ArrayList<AclEntity> ret = new ArrayList<AclEntity>();
        try {
            try {
                InitialContext ic = new InitialContext();
                OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
                Collection acls = home.findByUserId(this.realm, userId);
                Iterator itr = acls.iterator();
                while (itr.hasNext()) {
                    OsAcl acl = (OsAcl)itr.next();
                    ret.add(new AclEntity(acl));
                }
            }
            catch (FinderException e) {
                throw new NotFoundException(userId + " not found");
            }
            catch (NamingException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (EJBException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (Exception e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            Object var9_12 = null;
            return ret;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            return ret;
        }
    }

    public ArrayList getAclsByGroupId(String groupId) throws NotFoundException {
        ArrayList<AclEntity> ret = new ArrayList<AclEntity>();
        try {
            try {
                InitialContext ic = new InitialContext();
                OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
                Collection acls = home.findByGroupId(this.realm, groupId);
                Iterator itr = acls.iterator();
                while (itr.hasNext()) {
                    OsAcl acl = (OsAcl)itr.next();
                    ret.add(new AclEntity(acl));
                }
            }
            catch (FinderException e) {
                throw new NotFoundException(groupId + " not found");
            }
            catch (NamingException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (EJBException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (Exception e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            Object var9_12 = null;
            return ret;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            return ret;
        }
    }

    public ArrayList getAclsByResourceKey(String resourceKey) throws NotFoundException {
        ArrayList<AclEntity> ret = new ArrayList<AclEntity>();
        try {
            try {
                InitialContext ic = new InitialContext();
                OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
                Collection acls = home.findByResourceKey(resourceKey);
                Iterator itr = acls.iterator();
                while (itr.hasNext()) {
                    OsAcl acl = (OsAcl)itr.next();
                    ret.add(new AclEntity(acl));
                }
            }
            catch (FinderException e) {
                throw new NotFoundException(resourceKey + " not found");
            }
            catch (NamingException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (EJBException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (Exception e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            Object var9_12 = null;
            return ret;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            return ret;
        }
    }

    public ArrayList getAcls() throws NotFoundException {
        ArrayList<AclEntity> ret = new ArrayList<AclEntity>();
        try {
            try {
                InitialContext ic = new InitialContext();
                OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
                Collection res = home.findAll(this.realm);
                Iterator itr = res.iterator();
                while (itr.hasNext()) {
                    OsAcl acl = (OsAcl)itr.next();
                    ret.add(new AclEntity(acl));
                }
            }
            catch (FinderException e) {
                throw new NotFoundException(" not found");
            }
            catch (NamingException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (EJBException e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            catch (Exception e) {
                throw new NotFoundException("Container Error: " + e.getMessage());
            }
            Object var8_11 = null;
            return ret;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            return ret;
        }
    }

    public Acl_I getAclsByAclId(Long aclId) throws NotFoundException {
        try {
            InitialContext ic = new InitialContext();
            OsAclHome home = (OsAclHome)ic.lookup(aclLocation);
            OsAcl acl = home.findByPrimaryKey(aclId);
            return new AclEntity(acl);
        }
        catch (FinderException e) {
            throw new NotFoundException(aclId + " not found");
        }
        catch (NamingException e) {
            throw new NotFoundException("Container Error: " + e.getMessage());
        }
        catch (EJBException e) {
            throw new NotFoundException("Container Error: " + e.getMessage());
        }
        catch (Exception e) {
            throw new NotFoundException("Container Error: " + e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

