/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.access.provider.osuser;

import com.opensymphony.module.access.Entity;
import com.opensymphony.module.access.ImmutableException;
import com.opensymphony.module.access.NotFoundException;
import com.opensymphony.module.access.entities.Group_I;
import com.opensymphony.module.access.entities.User_I;
import com.opensymphony.module.access.provider.UserProvider;
import com.opensymphony.module.access.provider.osuser.OsGroup;
import com.opensymphony.module.access.provider.osuser.OsUser;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.Group;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class OSUserUserProvider
implements UserProvider {
    private String m_realm;

    public boolean isUserInGroup(String userId, String groupId) throws NotFoundException {
        try {
            UserManager um = UserManager.getInstance();
            User user = um.getUser(userId);
            return user.inGroup(groupId);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public boolean isGroupInGroup(String childGroupId, String parentGroupId) throws NotFoundException {
        return false;
    }

    public List listUsersInGroup(String groupId) throws NotFoundException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            UserManager um = UserManager.getInstance();
            List users = um.getGroup(groupId).getUsers();
            Iterator itr = users.iterator();
            while (itr.hasNext()) {
                User l_user = (User)itr.next();
                list.add(l_user.getName());
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public List listGroupsInGroup(String group) throws NotFoundException {
        return null;
    }

    public void addUserToGroup(String userId, String groupId) throws NotFoundException, ImmutableException {
        try {
            UserManager um = UserManager.getInstance();
            Group group = um.getGroup(groupId);
            User user = um.getUser(userId);
            group.addUser(user);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public void removeUserFromGroup(String userId, String groupId) throws NotFoundException, ImmutableException {
        try {
            UserManager um = UserManager.getInstance();
            Group group = um.getGroup(groupId);
            User user = um.getUser(userId);
            group.removeUser(user);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public void addGroupToGroup(String childGroupId, String parentGroupId) throws NotFoundException, ImmutableException {
        throw new ImmutableException("OSUser does not support adding Groups to Groups");
    }

    public void removeGroupFromGroup(String childGroupId, String parentGroupId) throws NotFoundException, ImmutableException {
        throw new ImmutableException("OSUser does not support adding Groups to Groups");
    }

    public boolean load(String name, Entity.Accessor accessor) {
        return false;
    }

    public boolean init(Properties properties) {
        this.m_realm = properties.getProperty("realm", "default");
        return true;
    }

    public boolean handles(String name) {
        return this.m_realm.equals(name);
    }

    public List listGroupsForUser(String userId) throws NotFoundException {
        List list = new ArrayList();
        try {
            UserManager um = UserManager.getInstance();
            list = um.getUser(userId).getGroups();
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public List listParentGroupsOfGroup(String group) throws NotFoundException {
        return null;
    }

    public ArrayList getUsers() throws NotFoundException {
        UserManager um = UserManager.getInstance();
        List users = um.getUsers();
        ArrayList<OsUser> ret = new ArrayList<OsUser>();
        int i = 0;
        while (i < users.size()) {
            User user = (User)users.get(i);
            ret.add(new OsUser(user));
            ++i;
        }
        return ret;
    }

    public ArrayList getGroups() throws NotFoundException {
        UserManager um = UserManager.getInstance();
        List groups = um.getGroups();
        ArrayList<OsGroup> ret = new ArrayList<OsGroup>();
        Iterator itr = groups.iterator();
        while (itr.hasNext()) {
            Group group = (Group)itr.next();
            ret.add(new OsGroup(group));
        }
        return ret;
    }

    public User_I getUser(String userId) throws NotFoundException {
        try {
            return new OsUser(UserManager.getInstance().getUser(userId));
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public Group_I getGroup(String groupId) throws NotFoundException {
        try {
            return new OsGroup(UserManager.getInstance().getGroup(groupId));
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    public ArrayList getUsersForGroup(String groupId) throws NotFoundException {
        Group_I group = this.getGroup(groupId);
        if (group != null) {
            return group.getUsers();
        }
        return new ArrayList();
    }

    public String getRealm() {
        return this.m_realm;
    }
}

