/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.ejb;

import com.opensymphony.module.propertyset.DuplicatePropertyKeyException;
import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertiesException;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.ejb.types.OsPropertyEntry;
import com.opensymphony.module.propertyset.ejb.types.OsPropertyEntryHome;
import com.opensymphony.util.EJBUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyStoreBean
implements SessionBean {
    SessionContext sessionContext;
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$module$propertyset$ejb$PropertyStoreBean == null ? (class$com$opensymphony$module$propertyset$ejb$PropertyStoreBean = PropertyStoreBean.class$("com.opensymphony.module.propertyset.ejb.PropertyStoreBean")) : class$com$opensymphony$module$propertyset$ejb$PropertyStoreBean));
    private transient OsPropertyEntryHome entryHome;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$PropertyStoreBean;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$OsPropertyEntryHome;
    static /* synthetic */ Class class$com$opensymphony$module$propertyset$ejb$types$OsPropertyEntry;

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        try {
            this.entryHome = (OsPropertyEntryHome)PortableRemoteObject.narrow((Object)new InitialContext().lookup("os.PropertyEntry"), (Class)(class$com$opensymphony$module$propertyset$ejb$types$OsPropertyEntryHome == null ? (class$com$opensymphony$module$propertyset$ejb$types$OsPropertyEntryHome = PropertyStoreBean.class$("com.opensymphony.module.propertyset.ejb.types.OsPropertyEntryHome")) : class$com$opensymphony$module$propertyset$ejb$types$OsPropertyEntryHome));
        }
        catch (NamingException e) {
            logger.fatal((Object)"Could not lookup PropertyEntryHome.", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        this.sessionContext = sessionContext;
    }

    public boolean exists(String entityName, long entityId, String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("exists(" + entityName + "," + entityId + ",\"" + key + "\")"));
        }
        return this.getType(entityName, entityId, key) != 0;
    }

    public Serializable get(String entityName, long entityId, int type, String key) {
        logger.debug((Object)("get(" + entityName + "," + entityId + "," + type + ",\"" + key + "\")"));
        try {
            OsPropertyEntry entry = this.entryHome.findByEntity(entityName, entityId, key);
            if (type != entry.getType()) {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)("wrong property key : " + key + " (wanted: " + type + ") get type = " + entry.getType()));
                }
                throw new InvalidPropertyTypeException();
            }
            return entry.getValue();
        }
        catch (ObjectNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no property found");
            }
            return null;
        }
        catch (PropertiesException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Could not retrieve value.", (Throwable)e);
            throw new PropertyImplementationException(e);
        }
    }

    public Collection getKeys(String entityName, long entityId, String prefix, int type) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getKeys(" + entityName + "," + entityId + ")"));
            }
            ArrayList<String> results = new ArrayList<String>();
            Iterator entries = this.entryHome.findByNameAndId(entityName, entityId).iterator();
            while (entries.hasNext()) {
                OsPropertyEntry entry = (OsPropertyEntry)EJBUtils.narrow(entries.next(), class$com$opensymphony$module$propertyset$ejb$types$OsPropertyEntry == null ? PropertyStoreBean.class$("com.opensymphony.module.propertyset.ejb.types.OsPropertyEntry") : class$com$opensymphony$module$propertyset$ejb$types$OsPropertyEntry);
                String key = entry.getKey();
                if (prefix != null && !key.startsWith(prefix) || type != 0 && type != entry.getType()) continue;
                results.add(key);
            }
            Collections.sort(results);
            return results;
        }
        catch (FinderException e) {
            logger.error((Object)"Could not find keys.", (Throwable)e);
            throw new PropertyImplementationException(e);
        }
    }

    public int getType(String entityName, long entityId, String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getType(" + entityName + "," + entityId + ",\"" + key + "\")"));
        }
        try {
            return this.entryHome.findByEntity(entityName, entityId, key).getType();
        }
        catch (ObjectNotFoundException e) {
            return 0;
        }
        catch (FinderException e) {
            logger.error((Object)"Could not find type.", (Throwable)e);
            throw new PropertyImplementationException(e);
        }
        catch (Exception re) {
            re.printStackTrace();
            return 0;
        }
    }

    public void remove(String entityName, long entityId, String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remove(" + entityName + "," + entityId + ",\"" + key + "\")"));
        }
        try {
            this.entryHome.findByEntity(entityName, entityId, key).remove();
        }
        catch (ObjectNotFoundException e) {
            logger.debug((Object)"Value did not exist anyway.");
        }
        catch (PropertiesException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Could not remove value.", (Throwable)e);
            throw new PropertyImplementationException("Could not remove value.", e);
        }
    }

    public void set(String entityName, long entityId, String key, int type, Serializable value) {
        logger.debug((Object)("set(" + entityName + "," + entityId + "," + type + ",\"" + key + "\", [" + value + "] )"));
        if (value == null) {
            this.remove(entityName, entityId, key);
            return;
        }
        OsPropertyEntry entry = null;
        try {
            entry = this.entryHome.findByEntity(entityName, entityId, key);
            if (entry.getType() != type) {
                logger.error((Object)"property is of different type");
                throw new DuplicatePropertyKeyException();
            }
        }
        catch (ObjectNotFoundException e) {
            try {
                logger.debug((Object)(entityName + " " + new Long(entityId) + " " + type + " " + key));
                entry = this.entryHome.create(entityName, new Long(entityId), type, key);
            }
            catch (CreateException ce) {
                ce.printStackTrace();
                logger.error((Object)("Could not create new property. " + entityName + " , key: " + key), (Throwable)ce);
                throw new PropertyImplementationException("Could not create new property.", ce);
            }
            catch (Exception e1) {
                logger.error((Object)("Could not create new property. " + entityName + " , Id: " + entityId + " + type : " + type + ", key: " + key));
            }
        }
        catch (PropertiesException e) {
            e.printStackTrace();
            logger.fatal((Object)e.toString());
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Could not set property.", (Throwable)e);
            throw new PropertyImplementationException("Could not set property.", e);
        }
        try {
            entry.setValue(value);
        }
        catch (Exception re) {
            logger.fatal((Object)re);
            re.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

