/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.propertyset.ejb.types.VO;

import com.opensymphony.module.propertyset.PropertiesException;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.ejb.types.VO.DataEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.DateEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.DecimalEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.NumberEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.StringEntityVO;
import com.opensymphony.module.propertyset.ejb.types.VO.exception.PropertyException;
import com.opensymphony.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;

public class PropertySetVO
implements Serializable {
    private Long id;
    private String entityName;
    private Long entityId;
    private int type;
    private String key;
    private String fullName;
    private HashMap keys;
    private HashMap numberEntityVO = new HashMap();
    private HashMap dataEntityVO = new HashMap();
    private HashMap dateEntityVO = new HashMap();
    private HashMap stringEntityVO = new HashMap();
    private HashMap decimalEntityVO = new HashMap();

    public Long getId() {
        return this.id;
    }

    public void setId(Long argId) {
        this.id = argId;
    }

    public String getFullname() {
        try {
            return this.getString("fullName");
        }
        catch (PropertyException ex) {
            return null;
        }
    }

    public void setFullname(String fullname) {
        this.setString("fullName", fullname);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String argEntityName) {
        this.entityName = argEntityName;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long argEntityId) {
        this.entityId = argEntityId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int argType) {
        this.type = argType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String argKey) {
        this.key = argKey;
    }

    public HashMap getNumberEntityVO() {
        return this.numberEntityVO;
    }

    public void addNumberEntityVO(NumberEntityVO argNumberEntityVO) {
        this.numberEntityVO.put(argNumberEntityVO.getKey(), argNumberEntityVO);
        this.keys.put(argNumberEntityVO.getKey(), argNumberEntityVO.getId());
    }

    public HashMap getDataEntityVO() {
        return this.dataEntityVO;
    }

    public void addDataEntityVO(DataEntityVO argDataEntityVO) {
        if (this.exists(argDataEntityVO.getKey())) {
            this.remove(argDataEntityVO.getKey());
        }
        this.dataEntityVO.put(argDataEntityVO.getKey(), argDataEntityVO);
        this.keys.put(argDataEntityVO.getKey(), argDataEntityVO.getId());
    }

    public HashMap getDateEntityVO() {
        return this.dateEntityVO;
    }

    public void addDateEntityVO(DateEntityVO argDateEntityVO) {
        this.dateEntityVO.put(argDateEntityVO.getKey(), argDateEntityVO);
        this.keys.put(argDateEntityVO.getKey(), argDateEntityVO.getId());
    }

    public HashMap getStringEntityVO() {
        return this.stringEntityVO;
    }

    public void addStringEntityVO(StringEntityVO argStringEntityVO) {
        this.stringEntityVO.put(argStringEntityVO.getKey(), argStringEntityVO);
        this.keys.put(argStringEntityVO.getKey(), argStringEntityVO.getId());
    }

    public boolean exists(String key) {
        return this.keys.containsKey(key);
    }

    public HashMap getDecimalEntityVO() {
        return this.decimalEntityVO;
    }

    public void addDecimalEntityVO(DecimalEntityVO argDecimalEntityVO) {
        this.decimalEntityVO.put(argDecimalEntityVO.getKey(), argDecimalEntityVO);
        this.keys.put(argDecimalEntityVO.getKey(), argDecimalEntityVO.getId());
    }

    public PropertySetVO() {
        this.keys = new HashMap();
    }

    public boolean getBoolean(String key) throws PropertyException {
        if (!this.numberEntityVO.containsKey(key)) {
            throw new PropertiesException("key not available");
        }
        Long number = ((NumberEntityVO)this.numberEntityVO.get(key)).getNumber();
        return number > 0L;
    }

    public void setBoolean(String key, boolean value) {
        NumberEntityVO entity = new NumberEntityVO();
        entity.setKey(key);
        entity.setType(1);
        if (value) {
            entity.setNumber(new Long(1L));
        } else {
            entity.setNumber(new Long(0L));
        }
        this.addNumberEntityVO(entity);
    }

    public String getString(String key) throws PropertyException {
        if (this.stringEntityVO.containsKey(key)) {
            StringEntityVO entity = (StringEntityVO)this.stringEntityVO.get(key);
            return entity.getValue();
        }
        return "not available";
    }

    public void setString(String key, String value) {
        StringEntityVO entity = new StringEntityVO();
        entity.setKey(key);
        entity.setType(5);
        entity.setValue(value);
        this.addStringEntityVO(entity);
    }

    public byte[] getData(String key) throws PropertyException {
        if (!this.dataEntityVO.containsKey(key)) {
            throw new PropertiesException("key not available");
        }
        DataEntityVO entity = (DataEntityVO)this.dataEntityVO.get(key);
        return entity.getBytes();
    }

    public void setData(String key, byte[] value) {
        DataEntityVO entity = new DataEntityVO();
        entity.setType(10);
        entity.setBytes(value);
        this.addDataEntityVO(entity);
    }

    public Long getDate(String key) throws PropertyException {
        if (!this.dateEntityVO.containsKey(key)) {
            throw new PropertiesException("key not available");
        }
        DateEntityVO entity = (DateEntityVO)this.dateEntityVO.get(key);
        return entity.getValue();
    }

    public void setDate(String key, long value) {
        DateEntityVO entity = new DateEntityVO();
        entity.setKey(key);
        entity.setType(7);
        entity.setValue(new Long(value));
        this.addDateEntityVO(entity);
    }

    public double getDouble(String key) throws PropertyException {
        if (!this.decimalEntityVO.containsKey(key)) {
            throw new PropertiesException("property with this key not available");
        }
        DecimalEntityVO entity = (DecimalEntityVO)this.decimalEntityVO.get(key);
        entity.setType(4);
        return new Double(entity.getValue().toString());
    }

    public void setDouble(String key, double value) {
        DecimalEntityVO entity = new DecimalEntityVO();
        entity.setKey(key);
        entity.setType(4);
        entity.setValue(new Double(value));
        this.addDecimalEntityVO(entity);
    }

    public int getInt(String key) throws PropertyException {
        if (!this.dataEntityVO.containsKey(key)) {
            throw new PropertiesException("key not available");
        }
        NumberEntityVO entity = (NumberEntityVO)this.dataEntityVO.get(key);
        return entity.getNumber().intValue();
    }

    public void getInt(String key, int value) {
        NumberEntityVO entity = new NumberEntityVO();
        entity.setKey(key);
        entity.setType(2);
        entity.setNumber(new Long(value));
        this.addNumberEntityVO(entity);
    }

    public long getLong(String key) throws PropertyException {
        if (!this.numberEntityVO.containsKey(key)) {
            throw new PropertiesException("key not available: " + key + "keys: " + this.numberEntityVO.toString());
        }
        NumberEntityVO entity = (NumberEntityVO)this.numberEntityVO.get(key);
        return entity.getNumber();
    }

    public void setLong(String key, long value) {
        NumberEntityVO entity = new NumberEntityVO();
        entity.setKey(key);
        entity.setType(3);
        entity.setNumber(new Long(value));
        this.addNumberEntityVO(entity);
    }

    public Object getObject(String key) throws PropertyException {
        if (!this.dataEntityVO.containsKey(key)) {
            throw new PropertiesException("key not available");
        }
        DataEntityVO entity = (DataEntityVO)this.dataEntityVO.get(key);
        return this.readObject(entity.getBytes());
    }

    public void getObject(String key, Object value) {
    }

    public Document getXML(String key) throws PropertyException {
        if (!this.dataEntityVO.containsKey(key)) {
            throw new PropertiesException("key not available");
        }
        DataEntityVO entity = (DataEntityVO)this.dataEntityVO.get(key);
        return this.readXML(entity.getBytes());
    }

    public void setObject(String key, Object value) {
        DataEntityVO entity = new DataEntityVO();
        entity.setType(9);
        entity.setBytes(this.writeObject(value));
        this.addDataEntityVO(entity);
    }

    public void setXML(String key, Document value) {
        DataEntityVO entity = new DataEntityVO();
        entity.setType(9);
        entity.setBytes(this.writeXML(value));
        this.addDataEntityVO(entity);
    }

    public String getText() {
        if (!this.dataEntityVO.containsKey(this.key)) {
            return "";
        }
        DataEntityVO entity = (DataEntityVO)this.dataEntityVO.get(this.key);
        return new String(entity.getBytes());
    }

    public void setText(String key, String value) {
        DataEntityVO entity = new DataEntityVO();
        entity.setType(6);
        entity.setBytes(value.getBytes());
        this.addDataEntityVO(entity);
    }

    private byte[] writeObject(Object o) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(bytes);
            stream.writeObject(o);
            stream.close();
            bytes.flush();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new PropertyImplementationException("Cannot serialize Object", e);
        }
    }

    private Object readObject(byte[] data) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(data);
            ObjectInputStream stream = new ObjectInputStream(bytes);
            Object result = stream.readObject();
            stream.close();
            return result;
        }
        catch (IOException e) {
            throw new PropertyImplementationException("Cannot deserialize Object", e);
        }
        catch (ClassNotFoundException e) {
            throw new PropertyImplementationException("Class not found for Object", e);
        }
    }

    private byte[] writeProperties(Properties p) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            p.store(bytes, null);
            bytes.flush();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new PropertyImplementationException("Cannot store Properties.", e);
        }
    }

    private Properties readProperties(byte[] data) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(data);
            Properties result = new Properties();
            result.load(bytes);
            return result;
        }
        catch (Exception e) {
            throw new PropertyImplementationException("Cannot load Properties.", e);
        }
    }

    private byte[] writeXML(Document doc) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            XMLUtils.print(doc, bytes);
            bytes.flush();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new PropertyImplementationException("Cannot serialize XML", e);
        }
    }

    private Document readXML(byte[] data) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(data);
            return XMLUtils.parse(bytes);
        }
        catch (Exception e) {
            throw new PropertyImplementationException("Cannot parse XML data.", e);
        }
    }

    public Collection getKeys() {
        String key;
        Vector<String> keys = new Vector<String>();
        Set set = this.numberEntityVO.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            keys.add(key);
        }
        set = this.dateEntityVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            keys.add(key);
        }
        set = this.dataEntityVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            keys.add(key);
        }
        set = this.stringEntityVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            keys.add(key);
        }
        set = this.decimalEntityVO.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            keys.add(key);
        }
        return keys;
    }

    public Collection getKeys(int type) {
        if (type == 0) {
            return this.getKeys();
        }
        Vector<String> keys = new Vector<String>();
        Iterator iter = null;
        switch (type) {
            case 1: {
                String key;
                Set set = this.numberEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((NumberEntityVO)this.dataEntityVO.get(key)).getType() != 1) continue;
                    keys.add(key);
                }
            }
            case 10: {
                String key;
                Set set = this.dataEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((DataEntityVO)this.dataEntityVO.get(key)).getType() != 10) continue;
                    keys.add(key);
                }
            }
            case 7: {
                String key;
                Set set = this.dateEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((DateEntityVO)this.dataEntityVO.get(key)).getType() != 7) continue;
                    keys.add(key);
                }
            }
            case 5: {
                String key;
                Set set = this.stringEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((StringEntityVO)this.dataEntityVO.get(key)).getType() != 5) continue;
                    keys.add(key);
                }
            }
            case 3: {
                String key;
                Set set = this.numberEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((NumberEntityVO)this.dataEntityVO.get(key)).getType() != 3) continue;
                    keys.add(key);
                }
            }
            case 2: {
                String key;
                Set set = this.numberEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((NumberEntityVO)this.dataEntityVO.get(key)).getType() != 2) continue;
                    keys.add(key);
                }
            }
            case 4: {
                String key;
                Set set = this.decimalEntityVO.keySet();
                iter = set.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        key = (String)iter.next();
                        if (((DecimalEntityVO)this.dataEntityVO.get(key)).getType() != 4) continue;
                        keys.add(key);
                    }
                }
            }
            case 8: {
                String key;
                Set set = this.dataEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((DataEntityVO)this.dataEntityVO.get(key)).getType() != 8) continue;
                    keys.add(key);
                }
            }
            case 9: {
                String key;
                Set set = this.dataEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((DataEntityVO)this.dataEntityVO.get(key)).getType() != 9) continue;
                    keys.add(key);
                }
            }
            case 6: {
                String key;
                Set set = this.dataEntityVO.keySet();
                iter = set.iterator();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (((DataEntityVO)this.dataEntityVO.get(key)).getType() != 6) continue;
                    keys.add(key);
                }
                break;
            }
        }
        return null;
    }

    public void remove(String key) {
        this.numberEntityVO.remove(key);
        this.dataEntityVO.remove(key);
        this.dateEntityVO.remove(key);
        this.stringEntityVO.remove(key);
        this.decimalEntityVO.remove(key);
    }
}

