/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sequence;

import com.opensymphony.module.sequence.Sequence;
import com.opensymphony.module.sequence.SequenceHome;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceGeneratorBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog((Class)(class$com$opensymphony$module$sequence$SequenceGeneratorBean == null ? (class$com$opensymphony$module$sequence$SequenceGeneratorBean = SequenceGeneratorBean.class$("com.opensymphony.module.sequence.SequenceGeneratorBean")) : class$com$opensymphony$module$sequence$SequenceGeneratorBean));
    private Map sequenceStore;
    private SequenceHome sequenceHome;
    private int increment;
    private int retry;
    private int retryPause;
    SessionContext sessionContext;
    static /* synthetic */ Class class$com$opensymphony$module$sequence$SequenceGeneratorBean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$opensymphony$module$sequence$SequenceHome;

    public void ejbCreate() throws CreateException {
        this.increment = this.getIntEnv("increment", 5);
        this.retry = this.getIntEnv("retry", 5);
        this.retryPause = this.getIntEnv("retryPause", 100);
        this.sequenceStore = new HashMap();
    }

    private int getIntEnv(String envName, int defaultValue) {
        try {
            return (Integer)PortableRemoteObject.narrow((Object)new InitialContext().lookup(envName), (Class)(class$java$lang$Integer == null ? (class$java$lang$Integer = SequenceGeneratorBean.class$("java.lang.Integer")) : class$java$lang$Integer));
        }
        catch (Exception e) {
            logger.debug((Object)e.toString());
            return defaultValue;
        }
    }

    private MemorySequence getMemorySequence(String sequenceName) throws RemoteException, CreateException {
        MemorySequence memorySequence = (MemorySequence)this.sequenceStore.get(sequenceName);
        if (memorySequence == null) {
            memorySequence = new MemorySequence();
            try {
                memorySequence.sequence = this.sequenceHome.findByPrimaryKey(sequenceName);
            }
            catch (FinderException e) {
                memorySequence.sequence = this.sequenceHome.create(sequenceName);
            }
            this.sequenceStore.put(sequenceName, memorySequence);
        }
        return memorySequence;
    }

    private void getNextHighCount(MemorySequence memorySequence) throws RemoteException {
        int retryAttempt = 0;
        while (true) {
            try {
                memorySequence.last = memorySequence.sequence.getCount(this.increment);
            }
            catch (Exception tre) {
                if (retryAttempt < this.retry) {
                    try {
                        Thread.sleep(this.retryPause);
                    }
                    catch (InterruptedException ie) {}
                } else {
                    throw new EJBException(tre);
                }
                ++retryAttempt;
                continue;
            }
            break;
        }
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        try {
            InitialContext jndiContext = new InitialContext();
            Object ref = jndiContext.lookup("osSequence");
            this.sequenceHome = (SequenceHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$com$opensymphony$module$sequence$SequenceHome == null ? (class$com$opensymphony$module$sequence$SequenceHome = SequenceGeneratorBean.class$("com.opensymphony.module.sequence.SequenceHome")) : class$com$opensymphony$module$sequence$SequenceHome));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public long getCount(String sequenceName) {
        long id = 20000L;
        try {
            if (sequenceName == null) {
                sequenceName = "os.PropertyEntry";
            }
            Sequence seq = this.sequenceHome.findByPrimaryKey(sequenceName);
            id = seq.getCount(1);
        }
        catch (FinderException ex) {
            try {
                Sequence seq = this.sequenceHome.create(sequenceName);
                seq.setActualcount(id);
            }
            catch (CreateException ex1) {
                throw new EJBException((Exception)((Object)ex1));
            }
        }
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MemorySequence {
        Sequence sequence;
        long last;

        private MemorySequence() {
        }
    }
}

