/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user;

import com.opensymphony.module.user.Entity;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.Group;
import com.opensymphony.module.user.ImmutableException;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.provider.CredentialsProvider;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.List;

public final class User
extends Entity
implements Principal {
    public static final String PROPERTY_FULLNAME = "fullName";
    public static final String PROPERTY_EMAIL = "email";

    User(String name, UserManager.Accessor managerAccessor) {
        super(name, managerAccessor);
        this.accessor = new Accessor();
        this.getCredentialsProvider().load(name, this.accessor);
    }

    public String getFullName() {
        return this.getPropertySet().getString(PROPERTY_FULLNAME);
    }

    public void setFullName(String fullName) {
        this.getPropertySet().setString(PROPERTY_FULLNAME, fullName);
    }

    public String getEmail() {
        return this.getPropertySet().getString(PROPERTY_EMAIL);
    }

    public void setEmail(String email) {
        this.getPropertySet().setString(PROPERTY_EMAIL, email);
    }

    public void setPassword(String password) throws ImmutableException {
        if (this.mutable && this.getCredentialsProvider().changePassword(this.name, password)) {
            return;
        }
        throw new ImmutableException();
    }

    public boolean authenticate(String password) {
        if (password == null) {
            return false;
        }
        return this.getCredentialsProvider().authenticate(this.name, password);
    }

    public List getGroups() {
        if (this.getAccessProvider() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.getAccessProvider().listGroupsContainingUser(this.getName()));
    }

    public boolean inGroup(Group group) {
        if (group == null) {
            return false;
        }
        return group.getAccessProvider().inGroup(this.getName(), group.getName());
    }

    public boolean inGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        try {
            return this.inGroup(this.getUserManager().getGroup(groupName));
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    public boolean addToGroup(Group group) {
        if (group == null) {
            return false;
        }
        return group.getAccessProvider().addToGroup(this.getName(), group.getName());
    }

    public boolean removeFromGroup(Group group) {
        if (group == null) {
            return false;
        }
        return group.getAccessProvider().removeFromGroup(this.getName(), group.getName());
    }

    public void store() throws ImmutableException {
        super.store();
        this.getProfileProvider().store(this.name, this.accessor);
        this.getCredentialsProvider().store(this.name, this.accessor);
    }

    public void remove() throws ImmutableException {
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (!this.mutable) {
            throw new ImmutableException("User is not mutable");
        }
        if (credentialsProvider == null) {
            throw new ImmutableException("No credentials provider for user");
        }
        if (!credentialsProvider.remove(this.name)) {
            throw new ImmutableException("Credentials provider failed to remove user");
        }
    }

    public final class Accessor
    extends Entity.Accessor
    implements Serializable {
        public User getUser() {
            return (User)this.getEntity();
        }
    }
}

