/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.user.adapter.weblogic;

import com.opensymphony.module.user.DuplicateEntityException;
import com.opensymphony.module.user.EntityNotFoundException;
import com.opensymphony.module.user.Group;
import com.opensymphony.module.user.ImmutableException;
import com.opensymphony.module.user.User;
import com.opensymphony.module.user.UserManager;
import com.opensymphony.module.user.adapter.weblogic.AclGroupAdapter;
import com.opensymphony.module.user.adapter.weblogic.CollectionEnum;
import com.opensymphony.module.user.adapter.weblogic.WeblogicUserAdapter;
import java.security.acl.NotOwnerException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import weblogic.logging.LogOutputStream;
import weblogic.security.acl.AbstractManageableRealm;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.DebuggableRealm;
import weblogic.security.acl.UserInfo;

public class OSUserRealm
extends AbstractManageableRealm
implements DebuggableRealm {
    private static final Log logger_ = LogFactory.getLog((Class)(class$com$opensymphony$module$user$adapter$weblogic$OSUserRealm == null ? (class$com$opensymphony$module$user$adapter$weblogic$OSUserRealm = OSUserRealm.class$("com.opensymphony.module.user.adapter.weblogic.OSUserRealm")) : class$com$opensymphony$module$user$adapter$weblogic$OSUserRealm));
    private UserManager um;
    LogOutputStream log;
    static /* synthetic */ Class class$com$opensymphony$module$user$adapter$weblogic$OSUserRealm;

    public void init(String s, Object o) throws NotOwnerException {
        super.init(s, o);
        DelayThread t = new DelayThread();
        t.start();
    }

    public OSUserRealm() {
        super("OSUserRealm");
    }

    public java.security.acl.Group getGroup(String name) {
        logger_.debug((Object)("getGroup(" + name + ")"));
        Group osGroup = null;
        try {
            if (this.um == null) {
                return null;
            }
            osGroup = this.um.getGroup(name);
        }
        catch (EntityNotFoundException enfe) {
            // empty catch block
        }
        if (osGroup == null) {
            return null;
        }
        return new AclGroupAdapter(osGroup);
    }

    public weblogic.security.acl.User getUser(String name) {
        logger_.debug((Object)("getUser(" + name + ")"));
        User osUser = null;
        try {
            if (this.um == null) {
                return null;
            }
            osUser = this.um.getUser(name);
        }
        catch (EntityNotFoundException enfe) {
            // empty catch block
        }
        if (osUser == null) {
            return null;
        }
        return new WeblogicUserAdapter(osUser, (BasicRealm)this);
    }

    public weblogic.security.acl.User getUser(UserInfo userInfo) {
        logger_.debug((Object)("getUser(" + userInfo + ")"));
        return this.getUser(userInfo.getName());
    }

    public Enumeration getUsers() {
        logger_.debug((Object)"getUsers()");
        if (this.um == null) {
            return null;
        }
        List users = this.um.getUsers();
        if (users == null) {
            return null;
        }
        Iterator iter = users.iterator();
        ArrayList<WeblogicUserAdapter> wlUserList = new ArrayList<WeblogicUserAdapter>();
        while (iter.hasNext()) {
            User osUser = (User)iter.next();
            wlUserList.add(new WeblogicUserAdapter(osUser, (BasicRealm)this));
        }
        return new CollectionEnum(wlUserList);
    }

    public Enumeration getGroups() {
        logger_.debug((Object)"getGroups()");
        if (this.um == null) {
            return null;
        }
        List groups = this.um.getGroups();
        if (groups == null) {
            return null;
        }
        Iterator iter = groups.iterator();
        ArrayList<AclGroupAdapter> aclGroupList = new ArrayList<AclGroupAdapter>();
        while (iter.hasNext()) {
            Group osGroup = (Group)iter.next();
            aclGroupList.add(new AclGroupAdapter(osGroup));
        }
        return new CollectionEnum(aclGroupList);
    }

    public void deleteUser(weblogic.security.acl.User user) throws SecurityException {
        logger_.debug((Object)("deleteUser(" + user + ")"));
        if (this.um == null) {
            return;
        }
        try {
            User osUser = this.um.getUser(user.getName());
            osUser.remove();
        }
        catch (EntityNotFoundException e) {
        }
        catch (ImmutableException e) {
            throw new SecurityException("Unable to delete user '" + user.getName() + "'. Users are immutable.");
        }
    }

    public void deleteGroup(java.security.acl.Group group) throws SecurityException {
        logger_.debug((Object)("deleteGroup(" + group + ")"));
        if (this.um == null) {
            return;
        }
        try {
            Group osGroup = this.um.getGroup(group.getName());
            osGroup.remove();
        }
        catch (EntityNotFoundException e) {
        }
        catch (ImmutableException e) {
            throw new SecurityException("Unable to delete group '" + group.getName() + "'. Groups are immutable.");
        }
    }

    public weblogic.security.acl.User newUser(String name, Object credential, Object constraints) throws SecurityException {
        logger_.debug((Object)("newUser(" + name + ", " + credential + ", " + constraints + ")"));
        if (this.um == null) {
            return null;
        }
        try {
            User osUser = null;
            osUser = this.um.createUser(name);
            if (!(credential instanceof String)) {
                throw new SecurityException("Unable to create user '" + name + "'. Non-String credentials (passwords) are not allowed.");
            }
            osUser.setPassword((String)credential);
            return new WeblogicUserAdapter(osUser, (BasicRealm)this);
        }
        catch (DuplicateEntityException e) {
            throw new SecurityException("Unable to create user '" + name + "'. User already exists");
        }
        catch (ImmutableException e) {
            throw new SecurityException("Unable to create user '" + name + "'. User set is immutable.");
        }
    }

    public java.security.acl.Group newGroup(String name) throws SecurityException {
        logger_.debug((Object)("newGroup(" + name + ")"));
        if (this.um == null) {
            return null;
        }
        try {
            Group osGroup = this.um.createGroup(name);
            return new AclGroupAdapter(osGroup);
        }
        catch (DuplicateEntityException e) {
            throw new SecurityException("Unable to create group '" + name + "'. Group already exists");
        }
        catch (ImmutableException e) {
            throw new SecurityException("Unable to create group '" + name + "'. Group set is immutable.");
        }
    }

    public void setDebug(boolean enable) {
        if (enable && this.log == null) {
            this.log = new LogOutputStream("RDBMSRealm");
        }
        if (!enable) {
            this.log = null;
        }
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DelayThread
    extends Thread {
        private DelayThread() {
        }

        public void run() {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            OSUserRealm.this.um = UserManager.getInstance();
        }
    }
}

